#include <iostream>

using namespace std;

int a = 42;
int b = 3;

int main() {
  cout << "COMPOUND:" << endl;

  cout << endl << "<var> += <const>:" << endl;
  cout << ( a += 3 ) << endl;

  cout << endl << "<var> += <var>:" << endl;
  cout << ( a += b ) << endl;

  cout << endl << "<var>++:" << endl;
  cout << ( a++ ) << endl;

  cout << endl << "++<var>:" << endl;
  cout << ( ++a ) << endl;

  return 0;
}

aspect SetTest1 {
  advice set("int ...::%") : before() {
    cout << "Before: " << tjp->signature() << endl;
    cout << "ent: " << *tjp->entity() << endl;
    cout << "new: " << *tjp->arg<0>() << endl;
  }

  advice set("int ...::%") : after() {
    cout << "After: " << tjp->signature() << endl;
    cout << "set: " << *tjp->entity() << endl;
  }
};

aspect SetTest2 {
  advice set("int ...::%") : around() {
    cout << "Around: " << tjp->signature() << endl;
    cout << "ent: " << *tjp->entity() << endl;
    cout << "new: " << *tjp->arg<0>() << endl;
    *tjp->arg<0>() *= 2;

    tjp->proceed();

    JoinPoint::Entity &tmp = *tjp->entity();
    cout << "set: " << tmp << endl;
    tmp += 32;
  }
};

aspect SetTest3 {
  advice set("int ...::%") : around() {
    cout << "ent (inner): " << *tjp->entity() << endl;
    cout << "new (inner): " << *tjp->arg<0>() << endl;

    tjp->proceed();

    cout << "set (inner): " << *tjp->entity() << endl;
  }
};

aspect GetTest {
  advice get("int ...::%") : after() {
    cout << "Get: " << tjp->signature() << " = " << *tjp->entity() << endl;
  }
};

aspect Call {
  advice call("int &operator ++(int &)") : around() {
    cout << "Hello Operator: " << tjp->signature() << endl;
    tjp->proceed();
    cout << "Bye." << endl;
  }
};
