//crypto.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2013
 *
 *  This file is part of aroarfw, a RoarAudio framework for
 *  embedded systems (Controlers).
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  aroarfw is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef _AROARFW_CRYPTO_H_
#define _AROARFW_CRYPTO_H_

#include <aroarfw/proto.h>

//! Hash types
typedef enum {
 //! None
 RHT_NONE       = 0,
 //! Old MD5, do not use
 RHT_MD5        = 1,
 //! SHA1, do avoid
 RHT_SHA1       = 2,
 //! 160 bit RIPEMD
 RHT_RIPEMD160  = 3,
 //! MD2, do not use
 RHT_MD2        = 5,
 //! 192 bit Tiger
 RHT_TIGER      = 6,
 //! HAVAL
 RHT_HAVAL      = 7,
 //! SHA256 (part of 'SHA2')
 RHT_SHA256     = 8,
 //! SHA384 (part of 'SHA2')
 RHT_SHA384     = 9,
 //! SHA512 (part of 'SHA2')
 RHT_SHA512     = 10,
 //! SHA224 (part of 'SHA2')
 RHT_SHA224     = 11,
 //! MD4, do not use
 RHT_MD4        = 301,
 //! Common CRC-32
 RHT_CRC32      = 302,
 //! RFC 1510 CRC
 RHT_RFC1510    = 303,
 //! OpenPGP's 24 bit CRC as descriped in RFC2440 and RFC4880
 RHT_RFC2440    = 304,
 //! WhirlPool
 RHT_WHIRLPOOL  = 305,
 //! Universally Unique Identifier (UUID)
 RHT_UUID       = 70000,
 //! 8 bit GTN.
 //! GTN is the Global Track Number as used by for example the RoarAudio PlayList Daemon (rpld).
 //! It is a creator-runtime-unique number to identify the object.
 RHT_GTN8       = 70001,
 //! 16 bit GTN.
 //! GTN is the Global Track Number as used by for example the RoarAudio PlayList Daemon (rpld).
 //! It is a creator-runtime-unique number to identify the object.
 RHT_GTN16      = 70002,
 //! 32 bit GTN ('short GTN').
 //! GTN is the Global Track Number as used by for example the RoarAudio PlayList Daemon (rpld).
 //! It is a creator-runtime-unique number to identify the object.
 RHT_GTN32      = 70004,
 //! 64 bit GTN ('long GTN').
 //! GTN is the Global Track Number as used by for example the RoarAudio PlayList Daemon (rpld).
 //! It is a creator-runtime-unique number to identify the object.
 RHT_GTN64      = 70008,
 //! Client ID
 RHT_CLIENTID   = 71000 + ROT_CLIENT,
 //! Stream ID
 RHT_STREAMID   = 71000 + ROT_STREAM,
 //! Source ID
 RHT_SOURCEID   = 71000 + ROT_SOURCE,
 //! Sample ID
 RHT_SAMPLEID   = 71000 + ROT_SAMPLE,
 //! Mixer ID
 RHT_MIXERID    = 71000 + ROT_MIXER,
 //! Bridge ID
 RHT_BRIDGEID   = 71000 + ROT_BRIDGE,
 //! Listen ID
 RHT_LISTENID   = 71000 + ROT_LISTEN,
 //! Action ID
 RHT_ACTIONID   = 71000 + ROT_ACTION,
 //! Message Queue ID
 RHT_MSGQUEUEID = 71000 + ROT_MSGQUEUE,
 //! Message Bus ID
 RHT_MSGBUSID   = 71000 + ROT_MSGBUS,
 //! 8 digit Global Trade Item Number
 RHT_GTIN8      = 72001,
 //! 13 digit Global Trade Item Number
 RHT_GTIN13     = 72002,
 //! 10 digit International Standard Book Number
 RHT_ISBN10     = 72003,
 //! 13 digit International Standard Book Number.
 //! Is the same as 13 digit Global Trade Item Number.
 RHT_ISBN13     = RHT_GTIN13,
 //! Adler-32, RFC1950 as used by zlib.
 RHT_ADLER32    = 73001
} rht_t;

//! Hash functions
typedef enum {
 //! This entry does not have anything to do with the object.
 //! Should not be used.
 RHF_NONE       =  0,
 //! This is an entry for exacltly this object
 RHF_OBJECT     =  1,
 //! This is the parent object
 RHF_PARENT     =  2,
 //! This is a logic group of this object
 RHF_LOGIC      =  3,
 //! This can be used to acces exactly this object with a premanent address.
 //! This is useful for use with Tantalos or GTIN/ISBN.
 RHF_PERMANENT  =  4,
 //! The device this is on or the device itself if this is a device
 RHF_DEVICE     =  5,
 //! The disk this is on, if this is a disk the same as HF_DEVICE
 RHF_DISK       =  6,
 //! This identifys the Song. This may for example be used with Tantalos or GTIN/ISBN
 RHF_SONG       =  7,
 //! The application, device or other source generating this object
 RHF_APP        =  8,
 //! The source file for this object
 RHF_FILE       =  9,
 //! This identifies any kind of artist/composer/interpret, to be used with Tantalos or GTIN/ISBN
 RHF_ARTIST     = 10,
 //! This identifies any kind of work/album/compilation, to be used with Tantalos or GTIN/ISBN
 RHF_WORK       = 11
} rhf_t;

#endif

//ll
