// ****************************************************************************
//
//          Aevol - An in silico experimental evolution platform
//
// ****************************************************************************
// 
// Copyright: See the AUTHORS file provided with the package or <www.aevol.fr>
// Web: http://www.aevol.fr/
// E-mail: See <http://www.aevol.fr/contact/>
// Original Authors : Guillaume Beslon, Carole Knibbe, David Parsons
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 
// ****************************************************************************


/*! \brief Definition of jumping polynomials for various settings of the Mersenne Twister
*/


#ifndef __AE_JUMP_POLYS_H__
#define __AE_JUMP_POLYS_H__

#if SFMT_MEXP == 607
const char* jump_poly = "2c375358c852082b88bdf47ffe5ac31b6cd4e255a12f271951f250f805d473248be9e75baee81f0474e793983cdc11c198d269b4bd9c34ca9eec3f91cceb172450d9b6001eaa29d97ba1cdb59c50684e";
#elif SFMT_MEXP == 1279
const char* jump_poly = "d9b26ff41ff79250750aa52e7426726d6ade8b9ee66174636bc772ade2aec8f913f573763a809dbeebac14488a5e04da0adc700e064da0ee470935e771d119eb9f08bfa78a3ac74516f4aa8b7885bf212287c03ab64837e8a56c12a0862adfc9a6d054e372b3ae2e11cd2d3c4a3ea924b6beb11f8f96227c61cf8b528b59565b2c040962d5d24d37cf7a0dee5175ca10e0ac797f8f1a3eb99a319ad15d540996";
#elif SFMT_MEXP == 2281
const char* jump_poly = "2b1e867bcc6a7adda82c2a26cb38b0ccb7f236848f6c3179e98b5d8b9db21d7df3bfa37941c8fcc0fa42cc4e244503040bad9575e6b0c138d52fe3f83b851495995a561ce64df116fa918b247e3a43817dd77f41115150cf2802c7a511f4e1487798ae3ee0b3cc2e155f82575731dc3bca3a08df85f511179bd7435c9594bd8dc28068d35251820015cd3ef7a23c8d5a1cabb6149a8e36216d4c9838b3ef79d06cb6e2f6e26daef80c2803f11bc03d06f75c2d69f064b72d3abf526961af2510cf688af3f2bfc56e7e4e11286a6302ee21e1109e0f3fbe328d9ad907976fde4aff6e683e3645e275a09a676ce585532bb21bc75bc4eeaf6643df3e886857411eb19bf93be3684689155441a89b32b070dc7af40e4aecaf632fd5cd7925b16af8";
#elif SFMT_MEXP == 4253
const char* jump_poly = "9da17b7f8b81dd8668afea353420300fc56674207f120d8350c6b565d3a04608ebad52f9826d4f0d30b6547ef0ee6be8bfd85d970ee9d7573c72f44a7a90f2eb86d59528a8146b811407f1b08c61d5e349bda9aac6a04a785ba66736e5160858e123a2d06fdfe59eef6e7093b54da08219a3f179cd2776e4595bce3c72307dc555f3d9485d1f82b2a46dded685d2e200d93584a49eae81b541d2e7eb0a1c3cf8d13ba75119a15e606decbb2067e8a760bd024a3dc2b2c703fae28db65a0fbca2466aa2bac285200cfd1702a9b47b29541ae4375b23734d0ff26254e855ad912e9260713a1d20561457508149557f27d6b5edf5afd4e9d377dac89cadd8d9dd28a3c90eccfd7738a10c3df64346135de4c57a708a7dfd33c28e5a1875b90fc0ee642a7050f974e8b7dc62eceb098a70d1a99158c4ca1d805fb721e4966688a6a0dbf60753baa8ad5e302f8244325b90d5d04bf72e92846141ea44926b141866ee75cf79d2cb944494afb371dc0d74caac434a758823ff05493b219c3c29031520161c84b5ae3c9e0a1451c1e723d7a9c3737e66a289dc18d102c241b28dc0c03ce5ea67253e3540f21477e969716264a6124247bb59b202359b2a371ea4cdc2bffdec81613d9ffb0b8c4ad3bcaeb8c576ede6d67d5629b32cb01d18b4a420de854b97aae9d4e35b3ab04131704eaea7b30a1edf54a11cf9e27df97779b2a86dd5505762c7461c475dec5da0bb2c9d092c792a371ee929788006af05e10ca69c6";
#elif SFMT_MEXP == 11213
const char* jump_poly = "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";
#elif SFMT_MEXP == 19937
const char* jump_poly = "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";
#elif SFMT_MEXP == 44497
const char* jump_poly = "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";
#elif SFMT_MEXP == 86243
const char* jump_poly = "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";
#elif SFMT_MEXP == 132049
const char* jump_poly = "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";
#elif SFMT_MEXP == 216091
const char* jump_poly = "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";
#endif


#endif // __AE_JUMP_POLYS_H__
