!{\src2tex{textfont=tt}}
!!****f* ABINIT/vtowfk_htor
!! NAME
!! vtowfk_htor
!!
!! FUNCTION
!! This routine compute the partial density at a given k-point,
!! for a given spin-polarization, from a fixed Hamiltonian
!! but might also simply compute eigenvectors and eigenvalues at this k point
!!
!! This routine does only support normal gs calculations and is optimized for
!! this kind ot calculation, basing on wfoptalg=0
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, GMR, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  cgq = array that holds the WF of the nearest neighbours of
!!        the current k-point (electric field, MPI //)
!!  cpus= cpu time limit in seconds
!!  dimffnl=second dimension of ffnl (1+number of derivatives)
!!  dtefield <type(efield_type)> = variables related to Berry phase
!!      calculations (see initberry.f)
!!  dtfil <type(datafiles_type)>=variables related to files
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  ffnl(npw_k,dimffnl,lmnmax,ntypat)=nonlocal form factors on basis sphere.
!!  gs_hamk <type(gs_hamiltonian_type)>=all data for the Hamiltonian at k
!!  icg=shift to be applied on the location of data in the array cg
!!  ikg=shift to be given to the location of the data in the arrays kg
!!      and pwind
!!  ikpt=number of the k-point
!!  iscf=(<= 0  =>non-SCF), >0 => SCF
!!  isppol isppol=1 for unpolarized, 2 for spin-polarized
!!  kg_k(3,npw_k)=reduced planewave coordinates.
!!  kinpw(npw)=(modified) kinetic energy for each plane wave (Hartree)
!!  kpg_k(npw,nkpg)= (k+G) components (only if useylm=1)
!!  lmnmax=if useylm=1, max number of (l,m,n) comp. over all type of psps
!!        =if useylm=0, max number of (l,n)   comp. over all type of psps
!!  matblk=dimension of the array ph3d
!!  mcg=second dimension of the cg array
!!  mcgq = second dimension of the cgq array (electric field, MPI //)
!!  mgfft=maximum size of 1D FFTs
!!  mkgq = second dimension of pwnsfacq
!!  mkmem =number of k points which can fit in memory; set to 0 if use disk
!!  mpi_enreg=informations about MPI parallelization
!!  mpsang= 1+maximum angular momentum for nonlocal pseudopotentials
!!  mpssoang= 1+maximum (spin*angular momentum) for nonlocal pseudopotentials
!!  mpw=maximum dimensioned size of npw
!!  natom=number of atoms in cell.
!!  nband_k=number of bands at this k point for that spin polarization
!!  nkpg=second dimension of kpg_k (0 if useylm=0)
!!  nkpt=number of k points.
!!  nnsclo_now=number of non-self-consistent loops for the current vtrial
!!             (often 1 for SCF calculation, =nstep for non-SCF calculations)
!!  npw_k=number of plane waves at this k point
!!  npwarr(nkpt)=number of planewaves in basis at this k point
!!  nspinor=number of spinorial components of the wavefunctions
!!  ntypat=number of types of atoms in unit cell.
!!  nvloc=final dimension of vlocal (usually 1, but 4 for non-collinear)
!!  n4,n5,n6=integers used for dimensionning of vlocal
!!  occ_k(nband_k)=occupation number for each band (usually 2) for each k.
!!  optforces=option for the computation of forces
!!  ph3d(2,npw,matblk)=3-dim structure factors, for each atom and plane wave.
!!  prtvol=control print volume and debugging output
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!  pwind(pwind_alloc,2,3)= array used to compute
!!           the overlap matrix smat between k-points (see initberry.f)
!!  pwind_alloc= first dimension of pwind
!!  pwnsfac(2,pwind_alloc)= phase factors for non-symmorphic translations
!!                          (see initberry.f)
!!  pwnsfacq(2,mkgq)= phase factors for the nearest neighbours of the
!!                    current k-point (electric field, MPI //)
!!  vlocal(n4,n5,n6,nvloc)= local potential in real space, on the augmented fft grid
!!  wtk=weight assigned to the k point.
!!  zshift(nband_k)=energy shifts for the squared shifted hamiltonian algorithm
!!
!! OUTPUT
!!  dphase_k(3)=change in Zak phase for the current k-point
!!  eig_k(nband_k)=array for holding eigenvalues (hartree)
!!  ek_k(nband_k)=contribution from each band to kinetic energy, at this k-point
!!  resid_k(nband_k)=residuals for each band over all k points,
!!                   BEFORE the band rotation.
!!  ==== if (gs_hamk%usepaw==0) ====
!!    enl_k(nband_k)=contribution from each band to nonlocal pseudopotential part
!!                   of total energy, at this k-point
!!  ==== if (optforces>0) ====
!!    grnl_k(3*natom,nband_k)=nonlocal gradients, at this k-point
!!
!! SIDE EFFECTS
!!  cg(2,mcg)=updated wavefunctions
!!  rhoaug(n4,n5,n6)= density in electrons/bohr**3, on the augmented fft grid.
!!                    (cumulative, so input as well as output). Update only
!!                    for occopt<3 (fixed occupation numbers)
!!
!! PARENTS
!!      vtorho
!!
!! CHILDREN
!!      cgwf_htor,fxphas,leave_new,nonlop,pw_orthon,sg_fftrisc,status
!!      subdiago_htor,timab,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine vtowfk_htor(cg,cgq,cpus,dimffnl,dphase_k,dtefield,dtfil,dtset,&
 &                 eig_k,ek_k,enl_k,ffnl,grnl_k,gs_hamk,icg,ikg,ikpt,iscf,isppol,kg_k,kinpw,kpg_k,&
&                  lmnmax,matblk,mcg,mcgq,mgfft,mkgq,mkmem,mpi_enreg,mpsang,&
&                  mpssoang,mpw,natom,nband_k,nkpg,nkpt,nnsclo_now,npw_k,npwarr,&
&                  nspinor,ntypat,nvloc,n4,n5,n6,occ_k,optforces,ph3d,prtvol,psps,&
&                  pwind,pwind_alloc,pwnsfac,pwnsfacq,resid_k,rhoaug,vlocal,wtk,zshift)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_12ffts
 use interfaces_13nonlocal
 use interfaces_14wfs
 use interfaces_18seqpar, except_this_one => vtowfk_htor
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 type(gs_hamiltonian_type), intent(in) :: gs_hamk
 integer, intent(in) :: dimffnl,icg,ikg,ikpt,iscf,isppol,lmnmax,matblk
 integer, intent(in) :: mcg,mcgq,mgfft,mkgq,mkmem,mpsang,mpssoang,mpw,n4,n5,n6
 integer, intent(in) :: natom,nband_k,nkpg,nkpt,nnsclo_now,npw_k,nspinor,ntypat,nvloc,optforces
 integer, intent(in) :: prtvol,pwind_alloc
 real(dp), intent(in) :: cpus,wtk
 type(datafiles_type), intent(in) :: dtfil
 type(dataset_type), intent(inout) :: dtset
 type(pseudopotential_type), intent(in) :: psps
 type(MPI_type), intent(inout) :: mpi_enreg
 type(efield_type), intent(inout) :: dtefield
 integer, intent(in) :: kg_k(3,npw_k),npwarr(nkpt),pwind(pwind_alloc,2,3)
 real(dp), intent(in) :: cgq(2,mcgq),ffnl(npw_k,dimffnl,lmnmax,ntypat)
 real(dp), intent(in) :: kinpw(npw_k),kpg_k(npw_k,nkpg),occ_k(nband_k)
 real(dp), intent(inout) :: ph3d(2,npw_k,matblk)
 real(dp), intent(in) :: pwnsfac(2,pwind_alloc),pwnsfacq(2,mkgq)
 real(dp), intent(in) :: zshift(nband_k)
 real(dp), intent(inout) :: vlocal(n4,n5,n6,nvloc)
 real(dp), intent(out) :: eig_k(nband_k),ek_k(nband_k),dphase_k(3)
 real(dp), intent(out) :: enl_k(nband_k*(1-gs_hamk%usepaw))
 real(dp), intent(out) :: grnl_k(3*natom,nband_k*optforces)
 real(dp), intent(out) :: resid_k(nband_k)
 real(dp), intent(inout) :: cg(2,mcg),rhoaug(n4,n5,n6)

!Local variables-------------------------------
 integer,parameter :: level=8
 integer,save :: nskip=0
!     Flag use_subovl: 1 if "subovl" array is computed (see below)
!     subovl should be Identity (in that case we should use use_subovl=0)
!     But this is true only if conjugate gradient algo. converges
 integer :: use_subovl=0
 integer :: choice,counter,cpopt,i1,i2,i3,ia,iatom,iband,iband2
 integer :: iblock,ider,idir,ier,ierr,iexit,ifft,ig,igs,igsc,ii,index,inonsc,ipw
 integer :: ispinor,itypat,iwavef,j1,j2,jj,kk,mgsc,n1,n2,n3
 integer :: nblock,nnlout,old_paral_level
 integer :: paw_opt,quit,signs,spaceComm,tim_fourwf,tim_nonlop
 real(dp) :: ar,arg,dum,eshift
 real(dp) :: residk,sumi,sumr,weight
 character(len=500) :: message
 real(dp) :: dummy(2,1),nonlop_dum(1,1),tsec(2)
 real(dp),allocatable :: cwavef(:,:),cwavef1(:,:),cwavef2(:,:),eig_save(:),enlout(:),evec(:,:)
 real(dp),allocatable :: gsc(:,:),mat1(:,:,:),matvnl(:,:,:)
 real(dp),allocatable :: subham(:),subovl(:),subvnl(:),wfraug(:,:,:,:)
 type(cprj_type) :: cprj_dum(1)
!no_abirules
            integer,parameter :: nkpt_max=50

! *********************************************************************

!DEBUG
!write(6,*)' vtowfk_htor : enter '
!ENDDEBUG

!=========================================================================
!============= INITIALIZATIONS AND ALLOCATIONS ===========================
!=========================================================================

 !Keep track of total time spent in vtowfk
 call timab(28,1,tsec)
 call status(0,dtfil%filstat,iexit,level,'enter         ')

 ! check if no time reversal symmetry is used!
 ! this feature should be added in the future
 if(gs_hamk%istwf_k/=1) then
  write(*,*) 'htor: istwfk=', gs_hamk%istwf_k, ' must be set to 1 in the input file'
  stop
 end if

 ! check if nbdblock=1
 if(dtset%nbdblock/=1) then
  write(*,*) 'htor: nbdblock=', dtset%nbdblock, ' must be set to 1 in the input file'
  stop
 end if

 ! check if paw is requested
 if(gs_hamk%usepaw/=0) then
  write(*,*) 'htor: paw_opt=', gs_hamk%usepaw, ' must be set to 0 in the input file'
  stop
 end if

 ! check if paw is requested
 if(nspinor/=1) then
  write(*,*) 'htor: nspinor=', nspinor, ' must be set to 1 in the input file'
  stop
 end if

#ifdef MPI
 ! initialize G distribution
 mpi_enreg%mgblk=npw_k/mpi_enreg%gngroup
 if(mod(npw_k,mpi_enreg%gngroup) /= 0) mpi_enreg%mgblk=mpi_enreg%mgblk+1
 mpi_enreg%gmin=mpi_enreg%mgblk*mpi_enreg%gindex+1
 mpi_enreg%gmax=min(mpi_enreg%mgblk*(mpi_enreg%gindex+1), npw_k)

 write(*,'(a,i4,a,i4,a,i4,a,i2,a,i5,a,i5)') '@@@ rank', mpi_enreg%me, ' enters vtowfk_htor as rank ', &
 &mpi_enreg%gindex, ' of', mpi_enreg%gngroup, ' in group', mpi_enreg%ggroup, ' and has ipw=', &
 & mpi_enreg%gmin, ' ..', mpi_enreg%gmax
#endif

 allocate(evec(2*nband_k,nband_k))
 allocate(subham(nband_k*(nband_k+1)))
 allocate(subvnl(nband_k*(nband_k+1)))
 quit=0
 use_subovl=0
 n1=gs_hamk%ngfft(1) ; n2=gs_hamk%ngfft(2) ; n3=gs_hamk%ngfft(3)
 igsc=0;mgsc=0

 !"nonlop" routine input parameters
 signs=1;idir=0;cpopt=-1
 if (optforces==0) then
  choice=1;tim_nonlop=1
 else
  choice=2;tim_nonlop=2
 end if
 nnlout=max(1,3*natom*optforces)
 paw_opt=0
 allocate(enlout(nnlout))

 if(prtvol>2 .or. ikpt<=nkpt_max)then
  write(message, '(a,a,i5,2x,a,3f9.5,2x,a)' ) ch10,&
  & ' Non-SCF iterations; k pt #',ikpt,'k=',gs_hamk%kpoint(:),'band residuals:'
  call wrtout(06,message,'PERS')
 end if

 !Electric field: initialize dphase_k
 dphase_k(:) = zero

 call status(0,dtfil%filstat,iexit,level,'before loop   ')
 call timab(39,1,tsec)

 !=========================================================================
 !==================== NON-SELF-CONSISTENT LOOP ===========================
 !=========================================================================

 !nnsclo_now=number of non-self-consistent loops for the current vtrial
 !    (often 1 for SCF calculation, =nstep for non-SCF calculations)
 do inonsc=1,nnsclo_now

  ! This initialisation is needed for the MPI-parallelisation (gathering using sum)
  subham(:)=zero
  subvnl(:)=zero
  resid_k(:)=0._dp

  ! Filter the WFs when modified kinetic energy is too large (see routine mkkin.f)
  do iband=1,nband_k
   iwavef=(iband-1)*npw_k
   do ipw=1,npw_k
    if(kinpw(ipw)>huge(0.0_dp)*1.d-11)then
     cg(1,ipw+iwavef)=zero
     cg(2,ipw+iwavef)=zero
    end if
   end do
  end do

  !=========================================================================
  !======== MINIMIZATION OF BANDS: CONJUGATE GRADIENT (Teter et al.) =======
  !=========================================================================
  call cgwf_htor(dtset%berryopt,cg,cgq,dtset%chkexit,cpus,dimffnl,dphase_k,dtefield,&
  &            ffnl,dtfil%filnam_ds(1),dtfil%filstat,&
  &            gsc,gs_hamk,icg,igsc,ikg,ikpt,inonsc,&
  &            isppol,kg_k,kinpw,lmnmax,matblk,dtset%mband,&
  &            mcg,mcgq,mgfft,mgsc,mkgq,mkmem,mpi_enreg,mpsang,&
  &            mpssoang,mpw,natom,nband_k,dtset%nbdblock,nkpt,dtset%nline,npw_k,npwarr,nspinor,&
  &            dtset%nsppol,ntypat,nvloc,n4,n5,n6,dtset%ortalg,&
  &            ph3d,prtvol,pwind,pwind_alloc,pwnsfac,&
  &            pwnsfacq,quit,resid_k,subham,subovl,subvnl,dtset%tolwfr,&
  &            use_subovl,vlocal,dtset%wfoptalg,wtk,zshift)

  !=========================================================================
  !===================== FIND LARGEST RESIDUAL =============================
  !=========================================================================

  ! Find largest resid over bands at this k point
  ! Note that this operation is done BEFORE rotation of bands :
  ! it would be time-consuming to recompute the residuals after.
  residk=maxval(resid_k(1:max(1,nband_k-dtset%nbdbuf)))
  ! Print residuals
  if(prtvol>2 .or. ikpt<=nkpt_max)then
   do ii=0,(nband_k-1)/8
    write(message, '(a,8es10.2)' ) ' res:',(resid_k(iband),iband=1+ii*8,min(nband_k,8+ii*8))
    call wrtout(06,message,'PERS')
   end do
  end if

  !=========================================================================
  !========== DIAGONALIZATION OF HAMILTONIAN IN WFs SUBSPACE ===============
  !=========================================================================

  call subdiago_htor(cg,dtfil%filstat,eig_k,evec,gsc,icg,igsc,ikpt,inonsc,gs_hamk%istwf_k,&
  &               mcg,mgsc,mpi_enreg,nband_k,npw_k,nspinor,prtvol,&
  &               subham,subovl,use_subovl,gs_hamk%usepaw)

  ! Print energies
  if(prtvol>2 .or. ikpt<=nkpt_max)then
    do ii=0,(nband_k-1)/8
     write(message, '(a,8es10.2)' ) ' ene:',(eig_k(iband),iband=1+ii*8,min(nband_k,8+ii*8))
     call wrtout(06,message,'PERS')
    end do
  end if

  !=========================================================================
  !=============== ORTHOGONALIZATION OF WFs (if needed) ====================
  !=========================================================================

  ! Re-orthonormalize the wavefunctions at this k point--
  ! this is redundant but is performed to combat rounding
  ! error in wavefunction orthogonality
  mpi_enreg%num_group_fft=0
  call status(inonsc,dtfil%filstat,iexit,level,'call pw_orthon   ')
  call pw_orthon(icg,igsc,gs_hamk%istwf_k,mcg,mgsc,mpi_enreg,npw_k*nspinor,nband_k,gsc,gs_hamk%usepaw,cg)

  ! Fix phases of all bands
  call status(inonsc,dtfil%filstat,iexit,level,'call fxphas   ')
  call fxphas(cg,gsc,icg,igsc,gs_hamk%istwf_k,mcg,mgsc,mpi_enreg,nband_k,npw_k*nspinor,gs_hamk%usepaw)

  !=========================================================================
  !================= END OF NON SELF-CONSISTENT LOOP =======================
  !=========================================================================

  ! Exit loop over inonsc if converged
  if (residk<dtset%tolwfr) exit

  !End loop over inonsc
 end do

 call timab(39,2,tsec)
 call timab(30,1,tsec)

 call status(0,dtfil%filstat,iexit,level,'after loops   ')


 !###################################################################
 !Compute kinetic energy and non-local energy for each band, and in the SCF
 !case, contribution to forces, and eventually accumulate rhoaug.

 allocate(cwavef(2,npw_k*nspinor))
 if(iscf>0 .and. dtset%occopt<3) allocate(wfraug(2,n4,n5,n6))
 !This loop can also be MPI-parallelized : the partial contributions
 !to ek_k, grnl_k and rhoaug will have to be gathered (a simple summation
 !of all contributions) after the loop
 do iband=1,nband_k
  cwavef(:,:)=cg(:,1+(iband-1)*npw_k*nspinor+icg:iband*npw_k*nspinor+icg)

  ! Compute kinetic energy of each band
  !!!!! call meanvalue_g(ar,kinpw,0,istwf_k,mpi_enreg,npw_k,nspinor,cwavef)
  ar=0
  do ipw=1,npw_k
   if(kinpw(ipw)<huge(0.0_dp)*1.d-11)then ! this is redundant - cg has been filtered
    ar=ar+kinpw(ipw)*(cwavef(1,ipw)**2+cwavef(2,ipw)**2)
   end if
  end do
  ek_k(iband)=ar

  if(iscf>0)then
   ! In case of fixed occupation numbers, accumulates the partial density
   if (dtset%occopt<3 ) then
    if (abs(occ_k(iband))>=tol8) then
     weight=occ_k(iband)*wtk/gs_hamk%ucvol
     ! Accumulate charge density in real space in array rhoaug
!     !tim_fourwf=2
!     !call fourwf(1,rhoaug,cwavef,dummy,wfraug, gs_hamk%gbound,gs_hamk%gbound,&
!     !&    istwf_k,kg_k,kg_k,mgfft,mpi_enreg,1,gs_hamk%ngfft,npw_k,1,n4,n5,n6,1,tim_fourwf,weight)
     call sg_fftrisc(1,rhoaug,cwavef,dummy,wfraug,gs_hamk%gbound,gs_hamk%gbound,&
     &  gs_hamk%istwf_k,kg_k,kg_k,mgfft,gs_hamk%ngfft,npw_k,1,n4,n5,n6,1,weight)
    else
     nskip=nskip+1
    end if
   end if

   ! Call to nonlocal operator:
   ! - Compute nonlocal forces from most recent wfs
   ! Treat all wavefunctions in case of varying occupation numbers
   ! Only treat occupied bands in case of fixed occupation numbers
   if( (3<=dtset%occopt.and.dtset%occopt<=7) .or. abs(occ_k(iband))>tol8 ) then
    call nonlop(gs_hamk%atindx1,choice,cpopt,cprj_dum,&
    &     gs_hamk%dimekb1,gs_hamk%dimekb2,dimffnl,dimffnl,gs_hamk%ekb,&
    &     enlout,ffnl,ffnl,gs_hamk%gmet,gs_hamk%gprimd,idir,&
    &     gs_hamk%indlmn,gs_hamk%istwf_k,kg_k,kg_k,kpg_k,kpg_k,gs_hamk%kpoint,gs_hamk%kpoint,&
    &     dum,lmnmax,matblk,mgfft,mpi_enreg,mpsang,&
    &     mpssoang,natom,gs_hamk%nattyp,&
    &     gs_hamk%ngfft,nkpg,nkpg,gs_hamk%nloalg,nnlout,npw_k,npw_k,nspinor,ntypat,paw_opt,&
    &     gs_hamk%phkxred,gs_hamk%phkxred,gs_hamk%ph1d,ph3d,ph3d,&
    &     gs_hamk%pspso,signs,nonlop_dum,nonlop_dum,&
    &     tim_nonlop,gs_hamk%ucvol,gs_hamk%useylm,cwavef,cwavef)
    if (optforces>0) grnl_k(:,iband)=enlout(:)
   end if

   ! End of SCF calculation
  end if
  ! End of loop on bands
 end do

 deallocate(cwavef)
 if (iscf>0 .and. dtset%occopt<3) deallocate(wfraug)

 ! Write the number of one-way 3D ffts skipped until now (in case of fixed
 ! occupation numbers
 if(iscf>0 .and. dtset%occopt<3 .and. (prtvol>2 .or. ikpt<=nkpt_max) )then
  write(message, '(a,i8)' ) ' vtowfk : number of one-way 3D ffts skipped in vtowfk until now =',nskip
  call wrtout(06,message,'PERS')
 end if

 !Norm-conserving only: Compute nonlocal part of total energy : rotate subvnl
 allocate(matvnl(2,nband_k,nband_k),mat1(2,nband_k,nband_k))

 ! (1) Write subvnl in full storage mode
 ii=0
 do iband=1,nband_k
  do jj=1,iband
   ii=ii+1
   matvnl(1,jj,iband)=subvnl(2*ii-1)
   matvnl(2,jj,iband)=subvnl(2*ii  )
  end do
 end do
 if (nband_k>1) then
  do iband=1,nband_k-1
   do jj=iband+1,nband_k
    matvnl(1,jj,iband)= matvnl(1,iband,jj)
    matvnl(2,jj,iband)=-matvnl(2,iband,jj)
   end do
  end do
 end if

 ! Product of matvnl by evec : mat1(ii,jj)=Sum(kk) evec(kk,jj) matvnl(ii,kk)
 ! Second product with evec, so that matvnl has been rotated
 ! (new)matvnl(ii,jj)=Sum(kk) evec*(kk,ii) mat1(kk,jj)
 ! However, only the diagonal, real, part is needed later
 ! This loop can be MPI-parallelized, with transfer of enl_k(iband) to all
 ! processors belonging to this k-point.
 do iband=1,nband_k
  do ii=1,nband_k
   mat1(1,ii,iband)=zero
   mat1(2,ii,iband)=zero
   do kk=1,nband_k
    mat1(1,ii,iband)=mat1(1,ii,iband)+evec(2*kk-1,iband)*matvnl(1,ii,kk) &
    &                                -evec(2*kk  ,iband)*matvnl(2,ii,kk)
    mat1(2,ii,iband)=mat1(2,ii,iband)+evec(2*kk-1,iband)*matvnl(2,ii,kk) &
    &                                +evec(2*kk  ,iband)*matvnl(1,ii,kk)
   end do
  end do

  enl_k(iband)=zero
  do kk=1,nband_k
   enl_k(iband)=enl_k(iband)+evec(2*kk-1,iband)*mat1(1,kk,iband) &
   &                        +evec(2*kk  ,iband)*mat1(2,kk,iband)
  end do

 end do

 deallocate(matvnl,mat1)

!###################################################################

 if (residk>dtset%tolwfr .and. iscf<=0) then
  write(message, '(a,a,a,a,2i5,a,es13.5)' ) ch10,&
&   ' vtowfk: WARNING -',ch10,&
&   '  Wavefunctions not converged for nnsclo,ikpt=',nnsclo_now,ikpt,&
&        ' max resid=',residk
  call wrtout(06,message,'PERS')
 end if

!Print out eigenvalues (hartree)
 if(prtvol>2 .or. ikpt<=nkpt_max) then
  write(message, '(5x,a,i5,2x,a,a,a,i4,a,i4,a)' ) &
&  'eigenvalues (hartree) for',nband_k,'bands',ch10,&
&  '              after ',inonsc,' non-SCF iterations with ',&
&  dtset%nline,' CG line minimizations'
  call wrtout(06,message,'PERS')
  do ii=0,(nband_k-1)/6
   write(message, '(1p,6e12.4)' ) (eig_k(iband),&
&                        iband=1+6*ii,min(6+6*ii,nband_k))
   call wrtout(06,message,'PERS')
  end do

 else if(ikpt==nkpt_max+1)then
  write(message, '(a)' ) &
&  ' vtowfk : prtvol=0 or 1, do not print more k-points.'
  call wrtout(06,message,'PERS')
 end if

!Print out decomposition of eigenvalues in the non-selfconsistent case
!or if prtvol>=10
 if( (iscf<0 .and. (prtvol>2 .or. ikpt<=nkpt_max)) .or. prtvol>=10)then

  write(message, '(5x,a,i5,2x,a,a,a,i4,a,i4,a)' ) &
&  ' mean kinetic energy (hartree) for',nband_k,'bands',ch10,&
&  '              after ',inonsc,' non-SCF iterations with ',&
&  dtset%nline,' CG line minimizations'
  call wrtout(06,message,'PERS')
  do ii=0,(nband_k-1)/6
   write(message, '(1p,6e12.4)' ) (ek_k(iband),&
&                         iband=1+6*ii,min(6+6*ii,nband_k))
   call wrtout(06,message,'PERS')
  end do

  write(message, '(5x,a,i5,2x,a,a,a,i4,a,i4,a)' ) &
&  ' mean non-local energy (hartree) for',nband_k,'bands',ch10,&
&  '              after ',inonsc,' non-SCF iterations with ',&
&  dtset%nline,' CG line minimizations'
  call wrtout(06,message,'PERS')

   do ii=0,(nband_k-1)/6
    write(message, '(1p,6e12.4)' ) (enl_k(iband),&
&                        iband=1+6*ii,min(6+6*ii,nband_k))
    call wrtout(06,message,'PERS')
   end do
 end if

 call status(0,dtfil%filstat,iexit,level,'deallocate    ')

 deallocate(enlout,evec,subham)
 deallocate(subvnl)

!Structured debugging : if prtvol=-level, stop here.
 if(prtvol==-level)then
  write(message,'(a1,a,a1,a,i1,a)') ch10,&
&   ' vtowfk : exit ',&
&   ch10,'  prtvol=-',level,', debugging mode => stop '
  call wrtout(06,message,'PERS')
  call leave_new('PERS')
 end if

 call status(0,dtfil%filstat,iexit,level,'exit          ')

 call timab(30,2,tsec)
 call timab(28,2,tsec)

end subroutine vtowfk_htor
!!***
