!{\src2tex{textfont=tt}}
!!****f* ABINIT/printcm
!! NAME
!! printcm
!!
!! FUNCTION
!! Print aa (complex matrix)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  aa(nn,mm)=matrix to be printed
!!  nn=first dimension of matrix
!!  mm=second dimension of matrix
!!
!! OUTPUT
!!  (only printing)
!!
!! PARENTS
!!      ccgradvnl,matcginv,screening
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine printcm(aa,nn,mm)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: mm,nn
!arrays
 complex,intent(in) :: aa(nn,mm)

!Local variables-------------------------------
!scalars
 integer :: ii,jj

! *************************************************************************

 write(6,'(5x,9(i2,6x))') (jj,jj=1,9)
 do ii=1,9
   write(6,'(1x,i1,1x,9f8.3)') ii,(real(aa(ii,jj)),jj=1,9)
   write(6,'(3x,9f8.3)') (aimag(aa(ii,jj)),jj=1,9)
   write(6,*)
 end do

 write(6,*)

end subroutine printcm
!!***
