#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dr Livingstone, I Presume?
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240927.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='dr-livingstone-i-presume'
GAME_NAME='Dr Livingstone, I Presume?'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

ARCHIVE_BASE_0_NAME='setup_dr_livingstone_i_presume_220419_0803_(55205).exe'
ARCHIVE_BASE_0_MD5='d6fdb1ce7ee00f5068b1d93f4592dad0'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_dr_livingstone_i_presume_220419_0803_(55205)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='36b0f92cde1b8ccbd42f339fbc752ada'
ARCHIVE_BASE_0_SIZE='5300000'
ARCHIVE_BASE_0_VERSION='2022.04.19-gog55205'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/dr_livingstone_i_presume'

## This installer is no longer available from gog.com
ARCHIVE_BASE_DEMO_0_NAME='setup_dr_livingstone_i_presume_demo_210726_1631_(48828).exe'
ARCHIVE_BASE_DEMO_0_MD5='57f69d1473e4c24706fe2cc70c56d62b'
ARCHIVE_BASE_DEMO_0_TYPE='innosetup'
ARCHIVE_BASE_DEMO_0_PART1_NAME='setup_dr_livingstone_i_presume_demo_210726_1631_(48828)-1.bin'
ARCHIVE_BASE_DEMO_0_PART1_MD5='4adc9914d1629ff3849f9d1d1f139b5c'
ARCHIVE_BASE_DEMO_0_SIZE='3800000'
ARCHIVE_BASE_DEMO_0_VERSION='2021.07.26-gog48828'


UNREALENGINE4_NAME='drlivingstone'

CONTENT_PATH_DEFAULT='.'

APP_MAIN_EXE="${UNREALENGINE4_NAME}.exe"

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
