#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# When The Past Was Around
# send your bug reports to contact@dotslashplay.it
###

script_version=20221206.2

GAME_ID='when-the-past-was-around'
GAME_NAME='When The Past Was Around'

UNITY3D_NAME='when past was around'

ARCHIVE_BASE_1='setup_when_the_past_was_around_0.64_(57966).exe'
ARCHIVE_BASE_1_MD5='d534934e5d9e5f7ebb1e871250124421'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='1900000'
ARCHIVE_BASE_1_VERSION='1.0.3-gog57966'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/when_the_past_was_around'

ARCHIVE_BASE_0='setup_when_the_past_was_around_0.5_(64bit)_(42277).exe'
ARCHIVE_BASE_0_MD5='b6c6fb5d16fd6c3841e852e5304f1aca'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1900000'
ARCHIVE_BASE_0_VERSION='1.0.3-gog42277'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
monobleedingedge
galaxy64.dll
galaxycsharpglue.dll
unityplayer.dll
unitycrashhandler64.exe
${UNITY3D_NAME}_data/plugins
${UNITY3D_NAME}.exe"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_data"

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Use persistent storage for saved games

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/Mojiken Studio/When Past Was Around'
USER_PERSISTENT_DIRECTORIES='
userdata'

# Load common functions

target_version='2.18'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
