#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# This War of Mine: The Little Ones
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220302.2

# Set game-specific variables

GAME_ID='this-war-of-mine'
GAME_NAME='Thie War of Mine'

EXPANSION_ID='the-little-ones'
EXPANSION_NAME='The Little Ones'

ARCHIVE_BASE_0='this_war_of_mine_the_little_ones_6_0_8_a_34693.sh'
ARCHIVE_BASE_0_MD5='7e2a1b8e0cc51d7a3f56f6591a0f6f21'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='18000'
ARCHIVE_BASE_0_VERSION='6.0.8a-gog34693'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/this_war_of_mine_the_little_ones'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_DATA_GOG_FILES='
gog.idx
gog.dat'

PACKAGES_LIST='PKG_DATA_GOG'

PKG_DATA_GOG_ID="${GAME_ID}-data-gog-${EXPANSION_ID}"
PKG_DATA_GOG_PROVIDE="${GAME_ID}-data-gog"
PKG_DATA_GOG_DESCRIPTION="$PKG_DATA_DESCRIPTION - GOG-specific files ($EXPANSION_NAME)"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

game_name=$(game_name)
GAME_NAME="$game_name - $EXPANSION_NAME"
print_instructions

exit 0
