#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Dark Eye: Memoria
# send your bug reports to contact@dotslashplay.it
###

script_version=20231017.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='the-dark-eye-memoria'
GAME_NAME='The Dark Eye: Memoria'

ARCHIVE_BASE_1_NAME='setup_memoria_1.2.3.0341_(18923).exe'
ARCHIVE_BASE_1_MD5='b939d4aa2aabf2bac1d527609e76ed0f'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_memoria_1.2.3.0341_(18923)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='3067662d212dfb297106a24ffd474cbd'
ARCHIVE_BASE_1_PART2_NAME='setup_memoria_1.2.3.0341_(18923)-2.bin'
ARCHIVE_BASE_1_PART2_MD5='24ff575f72e8b05b529aaaef99372090'
ARCHIVE_BASE_1_PART3_NAME='setup_memoria_1.2.3.0341_(18923)-3.bin'
ARCHIVE_BASE_1_PART3_MD5='88a98736110a7a59633a5bec12411f22'
ARCHIVE_BASE_1_SIZE='9100000'
ARCHIVE_BASE_1_VERSION='1.2.3.0341-gog18923'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/memoria'

ARCHIVE_BASE_0_NAME='setup_memoria_2.0.0.3.exe'
ARCHIVE_BASE_0_MD5='847c7b5e27a287d6e0e17e63bfb14fff'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_memoria_2.0.0.3-1.bin'
ARCHIVE_BASE_0_PART1_MD5='e656464607e4d8599d599ed5b6b29fca'
ARCHIVE_BASE_0_PART2_NAME='setup_memoria_2.0.0.3-2.bin'
ARCHIVE_BASE_0_PART2_MD5='593d57e8022c65660394c5bc5a333fe8'
ARCHIVE_BASE_0_PART3_NAME='setup_memoria_2.0.0.3-3.bin'
ARCHIVE_BASE_0_PART3_MD5='0f8ef0abab77f3885aa4f8f9e58611eb'
ARCHIVE_BASE_0_PART4_NAME='setup_memoria_2.0.0.3-4.bin'
ARCHIVE_BASE_0_PART4_MD5='0935149a66284bdc13659beafed2575f'
ARCHIVE_BASE_0_PART5_NAME='setup_memoria_2.0.0.3-5.bin'
ARCHIVE_BASE_0_PART5_MD5='5b85fb7fcb51599ee89b5d7371b87ee2'
ARCHIVE_BASE_0_PART6_NAME='setup_memoria_2.0.0.3-6.bin'
ARCHIVE_BASE_0_PART6_MD5='c8712354bbd093b706f551e75b549061'
ARCHIVE_BASE_0_SIZE='9100000'
ARCHIVE_BASE_0_VERSION='1.1.3.0336-gog2.0.0.3'

VISIONAIRE_NAME='memoria'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME0_BIN_PATH='app/__support/app'
CONTENT_GAME0_BIN_FILES='
config.ini'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Local Settings/Application Data/Daedalic Entertainment/Memoria'

PKG_BIN_ARCH='32'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
