#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 mortalius
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Pixel Piracy
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220706.1

GAME_ID='pixel-piracy'
GAME_NAME='Pixel Piracy'

ARCHIVE_BASE_GOG_0='gog_pixel_piracy_2.5.0.9.sh'
ARCHIVE_BASE_GOG_0_MD5='b689db9e42afa0a83d364f95cfb4d6bf'
ARCHIVE_BASE_GOG_0_TYPE='mojosetup'
ARCHIVE_BASE_GOG_0_SIZE='290000'
ARCHIVE_BASE_GOG_0_VERSION='1.1.21-gog2.5.0.9'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/pixel_piracy'

# This DRM-free archive is no longer sold by Humble Bundle
ARCHIVE_BASE_HUMBLE_0='pixelpiracy_Linux1.1.21.zip'
ARCHIVE_BASE_HUMBLE_0_MD5='18fb2d3f8adf6f320d507653298dc504'
ARCHIVE_BASE_HUMBLE_0_SIZE='290000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.1.21-humble150612'

UNITY3D_NAME='linux'

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE='Linux'
ARCHIVE_GAME_BIN_FILES="
${UNITY3D_NAME}.x86
${UNITY3D_NAME}_Data/Mono
${UNITY3D_NAME}_Data/Plugins"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_Data"

APP_MAIN_TYPE='native'
APP_MAIN_EXE="${UNITY3D_NAME}.x86"
APP_MAIN_ICON="${UNITY3D_NAME}_Data/Resources/UnityPlayer.png"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libGLU.so.1 libSDL2-2.0.so.0 xcursor libxrandr"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
content_path=$(content_path_default)
set_standard_permissions "${PLAYIT_WORKDIR}/gamedata/${content_path}"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
