#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Inspector Waffles
# send your bug reports to contact@dotslashplay.it
###

script_version=20230409.1

GAME_ID='inspector-waffles'
GAME_NAME='Inspector Waffles'

ARCHIVE_BASE_0='setup_inspector_waffles_1.0.2.11_(50460).exe'
ARCHIVE_BASE_0_MD5='ecdc6df3bc37b28c05f1bf7b24c3192f'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='740000'
ARCHIVE_BASE_0_VERSION='1.0.2.11-gog50460'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/inspector_waffles'

UNITY3D_NAME='inspector waffles'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
${UNITY3D_NAME}_data/plugins
${UNITY3D_NAME}.exe
monobleedingedge
unitycrashhandler32.exe
galaxy.dll
galaxycsharpglue.dll
unityplayer.dll"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_data"

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/Goloso Games/Inspector Waffles'
USER_PERSISTENT_DIRECTORIES='
userdata'

APP_MAIN_EXE="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_ARCH='lib32-gst-plugins-good lib32-gst-libav'
PKG_BIN_DEPS_DEB='gstreamer1.0-plugins-good, gstreamer1.0-libav'
PKG_BIN_DEPS_GENTOO='media-libs/gst-plugins-good[abi_x86_32] media-plugins/gst-plugins-libav[abi_x86_32]'

# Load common functions

target_version='2.22'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
