#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The First Tree
# send your bug reports to contact@dotslashplay.it
###

script_version=20240915.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-first-tree'
GAME_NAME='The First Tree'

ARCHIVE_BASE_GOG_0_NAME='the_first_tree_gog_1_25523.sh'
ARCHIVE_BASE_GOG_0_MD5='592127bcff79704927e9f3f5180ba044'
ARCHIVE_BASE_GOG_0_SIZE='2400000'
ARCHIVE_BASE_GOG_0_VERSION='1.0-gog25523'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/the_first_tree'

## This DRM-free archive is no longer available for sale from humblebundle.com.
ARCHIVE_BASE_HUMBLE_0_NAME='thefirsttree_linux.zip'
ARCHIVE_BASE_HUMBLE_0_MD5='987d328cb77670a4a43d7ea25f38cd99'
ARCHIVE_BASE_HUMBLE_0_SIZE='2400000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.0-humble1'

UNITY3D_NAME='TheFirstTree'
UNITY3D_PLUGINS='
ScreenSelector.so'
## The game does not start if the CSteamworks library is not provided.
UNITY3D_PLUGINS="${UNITY3D_PLUGINS:-}
libCSteamworks.so
libsteam_api.so"

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE='The First Tree'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
