/* martian_ids.c
 *	pci ids table for device
 *	included into martian.c
 */

#define PCI_SUBVENDOR(_subvendor) 			\
	.vendor = PCI_ANY_ID, .device = PCI_ANY_ID, 	\
	.subvendor = (_subvendor), 			\
	.subdevice = PCI_ANY_ID

__devinitdata static struct pci_device_id martian_ids[] = {
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x440) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x441) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x442) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x443) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x444) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x445) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x446) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x447) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x448) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x449) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x44a) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x44b) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x44c) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x44d) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x44e) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x44f) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x450) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x451) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x452) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x453) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x454) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x455) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x456) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x457) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x458) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x459) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x45a) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x45b) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x45c) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x45d) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x45e) },
	{ PCI_DEVICE (PCI_VENDOR_ID_ATT, 0x45f) },

	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x440) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x441) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x442) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x443) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x444) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x445) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x446) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x447) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x448) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x449) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x44a) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x44b) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x44c) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x44d) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x44e) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x44f) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x450) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x451) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x452) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x453) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x454) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x455) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x456) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x457) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x458) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x459) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x45a) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x45b) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x45c) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x45d) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x45e) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, 0x45f) },
	{ PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, PCI_ANY_ID) },

	/*** alternatively
	{ 
		PCI_DEVICE (PCI_VENDOR_ID_XIRCOM, PCI_ANY_ID),
		.class = PCI_CLASS_COMMUNICATION_SERIAL << 8,
		.class_mask = 0xffff00
	},
	and for MULTISERIAL/MODEM classes
	*/

	/*********** Toshibas **********/
	{ PCI_SUBVENDOR (PCI_VENDOR_ID_XIRCOM) },
	
	/*** fin ***/
	{ 0, }
};
