/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;

public class GlobalParametersIFD
extends IFD {
    private int _profileType = -1;
    private int _faxProfile = -1;
    private int _codingMethods = -1;
    private String _versionYear = null;
    private int _modeNumber = -1;
    public static final int PROFILETYPE = 401;
    public static final int FAXPROFILE = 402;
    public static final int CODINGMETHODS = 403;
    public static final int VERSIONYEAR = 404;
    public static final int MODENUMBER = 405;
    private static final String[] PROFILETYPE_L = new String[]{"Unspecified", "Group 3 Fax"};
    private static final String[] FAXPROFILE_L = new String[]{"does not conform to a profile defined for TIFF for facsimile", "Minimal black & white lossless, Profile S", "Extended black & white lossless, Profile F", "Lossless JBIG black & white, Profile J", "Lossy color and grayscale, Profile C", "Lossless color and grayscale, Profile L", "Mixed Raster Content, Profile M"};
    private static final String[] CODINGMETHODS_L = new String[]{"unspecified compression", "1-dimensional coding, ITU-T Rec. T.4 (MH - Modified Huffman)", "2-dimensional coding, ITU-T Rec. T.4 (MR - Modified Read)", "2-dimensional coding, ITU-T Rec. T.6 (MMR - Modified MR)", "ITU-T Rec. T.82 coding, using ITU-T Rec. T.85 (JBIG)", "ITU-T Rec. T.81 (Baseline JPEG)", "ITU-T Rec. T.82 coding, using ITU-T Rec. T.43 (JBIG color)"};

    public GlobalParametersIFD(long l, RepInfo repInfo, RandomAccessFile randomAccessFile, boolean bl) {
        super(l, repInfo, randomAccessFile, bl);
    }

    @Override
    public Property getProperty(boolean bl) throws TiffException {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        if (this._profileType != -1) {
            linkedList.add(this.addIntegerProperty("ProfileType", this._profileType, PROFILETYPE_L, bl));
        }
        if (this._faxProfile != -1) {
            linkedList.add(this.addIntegerProperty("FaxProfile", this._faxProfile, FAXPROFILE_L, bl));
        }
        if (this._codingMethods != -1) {
            linkedList.add(this.addBitmaskProperty("CodingMethods", this._codingMethods, CODINGMETHODS_L, bl));
        }
        if (this._versionYear != null) {
            linkedList.add(new Property("VersionYear", PropertyType.STRING, this._versionYear));
        }
        if (this._modeNumber != -1) {
            linkedList.add(new Property("ModeNumber", PropertyType.INTEGER, new Integer(this._modeNumber)));
        }
        return this.propertyHeader("GlobalParameterIFD", linkedList);
    }

    @Override
    public void lookupTag(int n, int n2, long l, long l2) throws TiffException {
        try {
            if (n == 401) {
                GlobalParametersIFD.checkType(n, n2, 4);
                GlobalParametersIFD.checkCount(n, l, 1);
                this._profileType = (int)this.readLong(n2, l, l2);
            } else if (n == 402) {
                GlobalParametersIFD.checkType(n, n2, 1);
                GlobalParametersIFD.checkCount(n, l, 1);
                this._faxProfile = this.readByte(n2, l, l2);
            } else if (n == 403) {
                GlobalParametersIFD.checkType(n, n2, 4);
                GlobalParametersIFD.checkCount(n, l, 1);
                this._codingMethods = (int)this.readLong(n2, l, l2);
            } else if (n == 404) {
                GlobalParametersIFD.checkType(n, n2, 1);
                GlobalParametersIFD.checkCount(n, l, 4);
                this._versionYear = this.readASCII(l, l2);
            } else if (n == 405) {
                GlobalParametersIFD.checkType(n, n2, 1);
                GlobalParametersIFD.checkCount(n, l, 1);
                this._modeNumber = this.readByte(n2, l, l2);
            }
        }
        catch (IOException iOException) {
            throw new TiffException("Read error for tag " + n, l2);
        }
    }
}

