/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BPCCBox
extends JP2Box {
    public BPCCBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof JP2HeaderBox) && !(this._parentBox instanceof CodestreamHeaderBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int n = (int)this._boxHeader.getDataLength();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        }
        NisoImageMetadata nisoImageMetadata = this._module.getCurrentNiso();
        nisoImageMetadata.setBitsPerSample(nArray);
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Bits Per Component Box";
    }
}

