/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigHandler
extends DefaultHandler {
    private String _class;
    protected StringBuffer _content;
    private Map _extension;
    private static final String configSchemaName = "jhoveConfig.xsd";
    private List _handler;
    protected List _handlerParams;
    private String _init;
    private List _param;
    private String _tempDir = null;
    private String _mixVsn = null;
    private String _encoding = null;
    private String _logLevel = null;
    private int _bufferSize = -1;
    private String _jhoveHome;
    private int _sigBytes = 1024;
    protected boolean _isHandler = false;
    protected boolean _isModule = false;
    private boolean _isTempDir = false;
    private boolean _isMixVsn;
    private boolean _isEncoding = false;
    private boolean _isBufferSize = false;
    private boolean _isJhoveHome = false;
    private boolean _isLogLevel = false;
    private boolean _isSigBytes;
    protected List _module = new ArrayList();
    protected List _modParams;

    public ConfigHandler() {
        this._handler = new ArrayList();
        this._modParams = new ArrayList();
        this._handlerParams = new ArrayList();
        this._extension = new Hashtable();
    }

    public List getModule() {
        return this._module;
    }

    public List getModuleParams() {
        return this._modParams;
    }

    public List getHandlerParams() {
        return this._handlerParams;
    }

    public List getHandler() {
        return this._handler;
    }

    public String getTempDir() {
        return this._tempDir;
    }

    public String getMixVsn() {
        return this._mixVsn;
    }

    public int getSigBytes() {
        return this._sigBytes;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public Map getExtensions() {
        return this._extension;
    }

    public String getJhoveHome() {
        return this._jhoveHome;
    }

    public String getLogLevel() {
        return this._logLevel;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._content = new StringBuffer();
        if (string3.equals("module")) {
            this._isModule = true;
            this._init = null;
            this._param = new ArrayList(1);
            this._class = null;
        } else if (string3.equals("outputHandler")) {
            this._isHandler = true;
            this._init = null;
            this._param = new ArrayList(1);
            this._class = null;
        } else if (string3.equals("tempDirectory")) {
            this._isTempDir = true;
        } else if (string3.equals("mixVersion")) {
            this._isMixVsn = true;
        } else if (string3.equals("defaultEncoding")) {
            this._isEncoding = true;
        } else if (string3.equals("bufferSize")) {
            this._isBufferSize = true;
        } else if (string3.equals("jhoveHome")) {
            this._isJhoveHome = true;
        } else if (string3.equals("logLevel")) {
            this._isLogLevel = true;
        } else if (string3.equals("sigBytes")) {
            this._isSigBytes = true;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this._content.append(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this._isModule) {
            if (string3.equals("class")) {
                this._class = this._content.toString();
            } else if (string3.equals("init")) {
                this._init = this._content.toString();
            } else if (string3.equals("param")) {
                this._param.add(this._content.toString());
            } else if (string3.equals("module")) {
                String[] stringArray = new String[]{this._class, this._init};
                this._module.add(stringArray);
                this._modParams.add(this._param);
                this._isModule = false;
            }
        } else if (this._isHandler) {
            if (string3.equals("class")) {
                this._class = this._content.toString();
            } else if (string3.equals("init")) {
                this._init = this._content.toString();
            } else if (string3.equals("param")) {
                this._param.add(this._content.toString());
            } else if (string3.equals("outputHandler")) {
                String[] stringArray = new String[]{this._class, this._init};
                this._handler.add(stringArray);
                this._handlerParams.add(this._param);
                this._isHandler = false;
            }
        } else if (this._isTempDir) {
            this._tempDir = this._content.toString().trim();
            this._isTempDir = false;
        } else if (this._isMixVsn) {
            this._mixVsn = this._content.toString().trim();
            this._isMixVsn = false;
        } else if (this._isSigBytes) {
            try {
                this._sigBytes = Integer.parseInt(this._content.toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this._isSigBytes = false;
        } else if (this._isEncoding) {
            this._encoding = this._content.toString().trim();
            this._isEncoding = false;
        } else if (this._isJhoveHome) {
            this._jhoveHome = this._content.toString().trim();
            this._isJhoveHome = false;
        } else if (this._isLogLevel) {
            this._logLevel = this._content.toString().trim();
            this._isLogLevel = false;
        } else if (this._isBufferSize) {
            try {
                this._bufferSize = Integer.parseInt(this._content.toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this._isBufferSize = false;
        } else if (!string3.equals("jhoveConfig")) {
            this._extension.put(string3, this._content.toString().trim());
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        if (string2.endsWith(configSchemaName)) {
            try {
                URL uRL = this.getClass().getResource(configSchemaName);
                InputStream inputStream = uRL.openStream();
                return new InputSource(inputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.resolveEntity(string, string2);
    }
}

