/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.viewer.InfoWindow;
import edu.harvard.hul.ois.jhove.viewer.JhoveWindow;
import edu.harvard.hul.ois.jhove.viewer.RepTreeRoot;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;

public class ViewWindow
extends InfoWindow {
    private List _info;
    private JMenuItem _closeAllItem;
    private ActionListener _closeAllListener;
    private DefaultMutableTreeNode _rootNode;
    private JTree tree;

    public ViewWindow(App app, JhoveBase jhoveBase, JhoveWindow jhoveWindow) {
        super("RepInfo", app, jhoveBase);
        JComponent jComponent;
        DefaultMutableTreeNode defaultMutableTreeNode;
        this.setSaveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewWindow.this.saveInfo();
            }
        });
        this._info = new LinkedList();
        this._rootNode = defaultMutableTreeNode = new DefaultMutableTreeNode("Documents");
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.tree = new JTree();
        this.tree.setModel(defaultTreeModel);
        this.tree.setShowsRootHandles(true);
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            jComponent = (DefaultTreeCellRenderer)treeCellRenderer;
            ((DefaultTreeCellRenderer)jComponent).setOpenIcon(null);
            ((DefaultTreeCellRenderer)jComponent).setClosedIcon(null);
            ((DefaultTreeCellRenderer)jComponent).setLeafIcon(null);
        }
        jComponent = new JScrollPane(this.tree);
        this.getContentPane().add((Component)jComponent, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize(new Dimension(8, 8));
        this.getContentPane().add((Component)jPanel, "South");
        this.setDefaultCloseOperation(2);
        this.setSize(400, 600);
        if (jhoveWindow != null) {
            this._closeAllItem = jhoveWindow.getCloseAllItem();
            this._closeAllListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ViewWindow.this.closeFromMenu();
                }
            };
            this._closeAllItem.addActionListener(this._closeAllListener);
        }
    }

    public void addRepInfo(RepInfo repInfo, App app, JhoveBase jhoveBase) {
        this._info.add(repInfo);
        RepTreeRoot repTreeRoot = new RepTreeRoot(repInfo, app, jhoveBase);
        this._rootNode.add(repTreeRoot);
    }

    public void expandRows() {
        this.tree.expandRow(0);
        if (this.tree.getRowCount() == 2) {
            this.tree.expandRow(1);
        }
    }

    private void saveInfo() {
        PrintWriter printWriter = this.doSaveDialog();
        if (printWriter == null) {
            return;
        }
        try {
            OutputHandler outputHandler = this.selectHandler();
            outputHandler.reset();
            outputHandler.setWriter(printWriter);
            outputHandler.showHeader();
            for (RepInfo repInfo : this._info) {
                outputHandler.show(repInfo);
            }
            outputHandler.showFooter();
            printWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Error writing file", 0);
        }
    }

    @Override
    protected void closeFromMenu() {
        super.closeFromMenu();
        if (this._closeAllItem != null) {
            this._closeAllItem.removeActionListener(this._closeAllListener);
        }
        this.dispose();
    }
}

