/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamUtils {
    public static byte[] readFully(InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copyStream(input, output);
        return output.toByteArray();
    }

    public static byte[] readFully(InputStream inputStream, int length) throws IOException {
        byte[] b = new byte[length];
        InputStreamUtils.readFully(inputStream, b, 0, length);
        return b;
    }

    public static void readFully(InputStream inputStream, byte[] b, int off, int length) throws IOException {
        int count;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < length; n += count) {
            count = inputStream.read(b, off + n, length - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }
}

