/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Iterator;
import picard.PicardException;
import picard.illumina.parser.readers.BinaryFileIterator;
import picard.illumina.parser.readers.MMapBackedIteratorFactory;
import picard.util.UnsignedTypeUtil;

public class FilterFileReader
implements Iterator<Boolean> {
    private static final int HEADER_SIZE = 12;
    public final int EXPECTED_VERSION = 3;
    private final BinaryFileIterator<Byte> bbIterator;
    public final int version;
    public final long numClusters;
    private static final byte FailedFilter = 0;
    private static final byte PassedFilter = 1;
    private int currentCluster;

    public FilterFileReader(File file) {
        this.bbIterator = MMapBackedIteratorFactory.getByteIterator(12, file);
        ByteBuffer headerBuf = this.bbIterator.getHeaderBytes();
        for (int i = 0; i < 4; ++i) {
            byte b = headerBuf.get();
            if (b == 0) continue;
            throw new PicardException("The first four bytes of a Filter File should be 0 but byte " + i + " was " + b + " in file " + file.getAbsolutePath());
        }
        this.version = headerBuf.getInt();
        if (this.version != 3) {
            throw new PicardException("Expected version is 3 but version found was " + this.version + " in file " + file.getAbsolutePath());
        }
        this.numClusters = UnsignedTypeUtil.uIntToLong(headerBuf.getInt());
        this.bbIterator.assertTotalElementsEqual(this.numClusters);
        this.currentCluster = 0;
    }

    @Override
    public boolean hasNext() {
        return (long)this.currentCluster < this.numClusters;
    }

    @Override
    public Boolean next() {
        byte value = this.bbIterator.next();
        ++this.currentCluster;
        if (value == 1) {
            return true;
        }
        if (value == 0) {
            return false;
        }
        String hexVal = Integer.toHexString(value);
        hexVal = (hexVal.length() < 2 ? "0x0" : "0x") + hexVal;
        throw new PicardException("Didn't recognized PF Byte (" + hexVal + ")" + " for element (" + this.currentCluster + ") in file(" + this.bbIterator.getFile().getAbsolutePath() + ")");
    }

    public void skipRecords(int numToSkip) {
        this.bbIterator.skipElements(numToSkip);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

