/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int rmid = -1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    public OracleXAHeteroResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        this.connection = connection;
        this.xaconnection = oracleXAConnection;
        if (this.connection == null) {
            throw new XAException(-7);
        }
    }

    @Override
    public void start(Xid xid, int n2) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n3 = n2 & 0xFF00;
        if (((n2 &= 0xFFFF00FF) & 0x8200002) != n2) {
            throw new XAException(-5);
        }
        if ((n3 & 0xFF00) != 0 && n3 != 256 && n3 != 512 && n3 != 1024) {
            throw new XAException(-5);
        }
        if ((n3 & 0xFF00) != 0 && (n2 & 0x8200000) != 0) {
            throw new XAException(-5);
        }
        try {
            this.saveAndAlterAutoCommitModeForGlobalTransaction();
            int n4 = xid.getFormatId();
            byte[] byArray = xid.getGlobalTransactionId();
            byte[] byArray2 = xid.getBranchQualifier();
            int n5 = this.t2cDoXaStart(n4, byArray, byArray2, this.rmid, n2 |= n3, 0);
            this.checkStatus(n5);
            this.enterGlobalTxnMode();
        }
        catch (XAException xAException) {
            this.restoreAutoCommitModeForGlobalTransaction();
            throw xAException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int n2) throws XAException {
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            int n3 = 638582786;
            if ((n2 & n3) != n2) {
                throw new XAException(-5);
            }
            int n4 = xid.getFormatId();
            byte[] byArray = xid.getGlobalTransactionId();
            byte[] byArray2 = xid.getBranchQualifier();
            this.exitGlobalTxnMode();
            int n5 = this.t2cDoXaEnd(n4, byArray, byArray2, this.rmid, n2, 0);
            this.checkStatus(n5);
        }
        finally {
            this.restoreAutoCommitModeForGlobalTransaction();
        }
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n2 = bl ? 0x40000000 : 0;
        int n3 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n4 = this.t2cDoXaCommit(n3, byArray, byArray2, this.rmid, n2, 0);
        this.checkStatus(n4);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        byte[] byArray;
        byte[] byArray2;
        if (xid == null) {
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        int n3 = this.t2cDoXaPrepare(n2, byArray2 = xid.getGlobalTransactionId(), byArray = xid.getBranchQualifier(), this.rmid, 0, 0);
        if (n3 != 0 && n3 != 3) {
            this.checkStatus(n3);
        }
        return n3;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.t2cDoXaForget(n2, byArray, byArray2, this.rmid, 0, 0);
        this.checkStatus(n3);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.t2cDoXaRollback(n2, byArray, byArray2, this.rmid, 0, 0);
        this.checkStatus(n3);
    }

    private native int t2cDoXaStart(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaEnd(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaCommit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaPrepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaForget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaRollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    synchronized void setRmid(int n2) {
        this.rmid = n2;
    }

    synchronized int getRmid() {
        return this.rmid;
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private void checkStatus(int n2) throws XAException {
        if (n2 != 0) {
            throw new XAException(n2);
        }
    }
}

