/*
 * easy_spice - a spice front end
 * Copyright (C) 2001 Routoure Jean-Marc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "easyspice.h"


/************* insert the results into a temporary schematic **********/

void 
visu_result_gschem(EasySpice *es)
{
  FILE *f_gschem, *f_gschem_tmp;
  gchar line[FICHIER_MAX_LINE], *vbranch;
  gchar *buf, **tokens;
  GList *item;
  int n_tokens, i;
  int x,y,color,size,visibility,show_name_value,angle,alignment,multiline;
 
  /* parse the gschem file to put the result in it */
  f_gschem=fopen(es->file_schematic,"rt");
  f_gschem_tmp=fopen(es->file_schematic_tmp,"wt");

  while (fgets(line, FICHIER_MAX_LINE, f_gschem) != NULL) {
    fprintf(f_gschem_tmp,"%s",line);
 
    /*read the text attributes and convert them into numbers */
    n_tokens = sscanf(line, "T %d %d %d %d %d %d %d %d %d", &x, &y,
                      &color, &size, &visibility, &show_name_value,
                      &angle, &alignment, &multiline);
    if (n_tokens != 9)
      continue;

    fgets(line, FICHIER_MAX_LINE, f_gschem);
    fprintf(f_gschem_tmp, "%s", line);
    if (multiline > 1) {
      /* copy multiline text to outfile */
      for (i = 1; i < multiline; i++) {       
	fgets(line, FICHIER_MAX_LINE, f_gschem);
	fprintf(f_gschem_tmp, "%s", line);
      }
      /* a multiline will never contain a netname, lets go on */
      continue;               
    }
        
    /* find the netnames that correspond with the results */
    g_strdelimit(line,"\n",'=');
    tokens=g_strsplit(line,"=",-1);
    if (strcmp(tokens[0],"netname")==0) {
      item=g_list_find_custom(es->netlist->op_result, tokens[1],
			      (GCompareFunc) keyvalue_compare_key);
      if (item != NULL) {
	fprintf(f_gschem_tmp,"T %d %d %d %d %d %d %d %d %d\n",
		x-200*(angle==90)+200*(angle==270),
		y-200*(angle==0)-200*(angle==180),
		color+1,size+1,visibility,show_name_value,
		angle,alignment,multiline);
	fprintf(f_gschem_tmp,"%sV\n",
		val2txt(atof(((KeyValue*)(item->data))->value),0));
      }
    }

    /* look for voltage sources and the coresponding results */
    if (strcmp(tokens[0],"refdes")==0) {
      vbranch=g_strdup_printf("%s#branch",tokens[1]);
      item=g_list_find_custom(es->netlist->op_result, vbranch,
			      (GCompareFunc) keyvalue_compare_key);
      g_free(vbranch);
      if (item != NULL) {
	fprintf(f_gschem_tmp,"T %d %d %d %d %d %d %d %d %d\n",
		x-200*(angle==90)+200*(angle==270),
		y-200*(angle==0)-200*(angle==180),
		color+1,size+1,visibility,show_name_value,angle,
		alignment, multiline);
	fprintf(f_gschem_tmp,"%sA\n",
		val2txt(atof(((KeyValue*)(item->data))->value),0));
      }
    }
    g_strfreev(tokens);
  }
  
  fclose(f_gschem);
  fclose(f_gschem_tmp);
  
  buf=g_strdup_printf(_("open the %s file in gschem to see the result\n"
			" but do not modify it!!\n"), es->file_schematic_tmp);
  write_log(buf);
  g_free(buf);
}


void
geda_create_config (GedaSettings *geda)
{
  FILE *file;
  gchar **attr_tokens;
  gint i;

  /* create gafrc file (gEDA and friends) */
  if ((file=fopen("gafrc","w"))==NULL) {
    create_quickmessage(_("Error"),_("Error!\nUnable to load file \"gafrc\""));
  }
  else {
    /* add a new directory */
    if (strlen(geda->include_dir)!=0) {
      fprintf(file,"(component-library \"%s\")\n",geda->include_dir);
      fprintf(file,"(source-library \"%s\")\n",geda->include_dir);
    }
    if (geda->include_cwd == TRUE) {
      fprintf(file,"(define current-working-directory (getenv \"PWD\"))\n");
      fprintf(file,"(component-library  current-working-directory)\n");
      fprintf(file,"(source-library  current-working-directory)\n");
    }
    /* add new attributes */
    if (geda->pinlabel_attr==TRUE) {
      fprintf(file,"(attribute-name \"pinlabel\")\n");
    }
    attr_tokens=g_strsplit(geda->attr," ",-1);
    for(i=0; attr_tokens[i]!=NULL; i++) {
      if (strlen(attr_tokens[i])!=0) /*no multiple spaces between the labels*/
	fprintf(file,"(attribute-name \"%s\")\n",attr_tokens[i]);
    }
    g_strfreev(attr_tokens);
    fclose(file);
  }

  /* create gschemrc file */
  if ((file=fopen("gschemrc","w"))==NULL)
    create_quickmessage(_("Error"),_("Error!\nUnable to load file \"gschemrc\""));
  else {
    if (strlen(geda->gschem_gridsize)!=0) 
      fprintf(file,"(snap-size %s)\n",geda->gschem_gridsize);
    if (strlen(geda->gschem_textsize)!=0) 
      fprintf(file,"(text-size %s)\n",geda->gschem_textsize);
    fclose(file);
  }

  /* create gnetlistrc file */
  if ((file=fopen("gnetlistrc","w"))==NULL)
    create_quickmessage(_("Error"),_("Error!\nUnable to load file \"gnetlistrc\""));
  else { 
    if (geda->gnetlist_priority_node==TRUE)
      fprintf(file,"(net-naming-priority \"net\")\n");
    else 
      fprintf(file,"(net-naming-priority \"label\")\n");
    if (geda->gnetlist_hierarchy_allow==TRUE) {
      fprintf(file,"(hierarchy-netattrib-mangle \"disabled\")\n");
      fprintf(file,"(hierarchy-uref-order \"prepend\")\n");
      fprintf(file,"(hierarchy-uref-separator \"_\")\n");
      fprintf(file,"(hierarchy-netname-separator \"_\")\n");
    }
    fclose(file);
  }
}
