/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.DOMImpl;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends Node {
    public static Element as(JavaScriptObject o) {
        assert (Element.is(o));
        return (Element)o;
    }

    public static Element as(Node node) {
        assert (Element.is(node));
        return (Element)node;
    }

    public static boolean is(JavaScriptObject o) {
        if (Node.is(o)) {
            return Element.is((Node)o);
        }
        return false;
    }

    public static boolean is(Node node) {
        return node != null && node.getNodeType() == 1;
    }

    protected Element() {
    }

    public final void addClassName(String className) {
        int lastPos;
        int last;
        assert (className != null) : "Unexpectedly null class name";
        className = className.trim();
        assert (className.length() != 0) : "Unexpectedly empty class name";
        String oldClassName = this.getClassName();
        int idx = oldClassName.indexOf(className);
        while (idx != -1 && (idx != 0 && oldClassName.charAt(idx - 1) != ' ' || (last = idx + className.length()) != (lastPos = oldClassName.length()) && (last >= lastPos || oldClassName.charAt(last) != ' '))) {
            idx = oldClassName.indexOf(className, idx + 1);
        }
        if (idx == -1) {
            if (oldClassName.length() > 0) {
                oldClassName = oldClassName + " ";
            }
            this.setClassName(oldClassName + className);
        }
    }

    public final native void blur();

    public final void dispatchEvent(NativeEvent evt) {
        DOMImpl.impl.dispatchEvent(this, evt);
    }

    public final native void focus();

    public final int getAbsoluteBottom() {
        return this.getAbsoluteTop() + this.getOffsetHeight();
    }

    public final int getAbsoluteLeft() {
        return DOMImpl.impl.getAbsoluteLeft(this);
    }

    public final int getAbsoluteRight() {
        return this.getAbsoluteLeft() + this.getOffsetWidth();
    }

    public final int getAbsoluteTop() {
        return DOMImpl.impl.getAbsoluteTop(this);
    }

    public final String getAttribute(String name) {
        return DOMImpl.impl.getAttribute(this, name);
    }

    public final native String getClassName();

    public final native int getClientHeight();

    public final native int getClientWidth();

    public final native String getDir();

    public final native NodeList<Element> getElementsByTagName(String var1);

    public final Element getFirstChildElement() {
        return DOMImpl.impl.getFirstChildElement(this);
    }

    public final native String getId();

    public final String getInnerHTML() {
        return DOMImpl.impl.getInnerHTML(this);
    }

    public final String getInnerText() {
        return DOMImpl.impl.getInnerText(this);
    }

    public final native String getLang();

    public final Element getNextSiblingElement() {
        return DOMImpl.impl.getNextSiblingElement(this);
    }

    public final native int getOffsetHeight();

    public final native int getOffsetLeft();

    public final native Element getOffsetParent();

    public final native int getOffsetTop();

    public final native int getOffsetWidth();

    public final native boolean getPropertyBoolean(String var1);

    public final native double getPropertyDouble(String var1);

    public final native int getPropertyInt(String var1);

    public final native JavaScriptObject getPropertyJSO(String var1);

    public final native Object getPropertyObject(String var1);

    public final native String getPropertyString(String var1);

    public final native int getScrollHeight();

    public final int getScrollLeft() {
        return DOMImpl.impl.getScrollLeft(this);
    }

    public final native int getScrollTop();

    public final native int getScrollWidth();

    public final String getString() {
        return DOMImpl.impl.toString(this);
    }

    public final native Style getStyle();

    public final int getTabIndex() {
        return DOMImpl.impl.getTabIndex(this);
    }

    public final String getTagName() {
        return DOMImpl.impl.getTagName(this);
    }

    public final native String getTitle();

    public final boolean hasAttribute(String name) {
        return DOMImpl.impl.hasAttribute(this, name);
    }

    public final boolean hasTagName(String tagName) {
        assert (tagName != null) : "tagName must not be null";
        return tagName.equals(this.getTagName());
    }

    public final native void removeAttribute(String var1);

    public final void removeClassName(String className) {
        int lastPos;
        int last;
        assert (className != null) : "Unexpectedly null class name";
        className = className.trim();
        assert (className.length() != 0) : "Unexpectedly empty class name";
        String oldStyle = this.getClassName();
        int idx = oldStyle.indexOf(className);
        while (idx != -1 && (idx != 0 && oldStyle.charAt(idx - 1) != ' ' || (last = idx + className.length()) != (lastPos = oldStyle.length()) && (last >= lastPos || oldStyle.charAt(last) != ' '))) {
            idx = oldStyle.indexOf(className, idx + 1);
        }
        if (idx != -1) {
            String begin = oldStyle.substring(0, idx).trim();
            String end = oldStyle.substring(idx + className.length()).trim();
            String newClassName = begin.length() == 0 ? end : (end.length() == 0 ? begin : begin + " " + end);
            this.setClassName(newClassName);
        }
    }

    public final void replaceClassName(String oldClassName, String newClassName) {
        this.removeClassName(oldClassName);
        this.addClassName(newClassName);
    }

    public final void scrollIntoView() {
        DOMImpl.impl.scrollIntoView(this);
    }

    public final native void setAttribute(String var1, String var2);

    public final native void setClassName(String var1);

    public final native void setDir(String var1);

    public final native void setId(String var1);

    public final native void setInnerHTML(String var1);

    public final void setInnerText(String text) {
        DOMImpl.impl.setInnerText(this, text);
    }

    public final native void setLang(String var1);

    public final native void setPropertyBoolean(String var1, boolean var2);

    public final native void setPropertyDouble(String var1, double var2);

    public final native void setPropertyInt(String var1, int var2);

    public final native void setPropertyJSO(String var1, JavaScriptObject var2);

    public final native void setPropertyObject(String var1, Object var2);

    public final native void setPropertyString(String var1, String var2);

    public final void setScrollLeft(int scrollLeft) {
        DOMImpl.impl.setScrollLeft(this, scrollLeft);
    }

    public final native void setScrollTop(int var1);

    public final native void setTabIndex(int var1);

    public final native void setTitle(String var1);
}

