// Generated from Unicode script tables

#ifndef SCRIPT_PROPERTIES_H_
#define SCRIPT_PROPERTIES_H_

#include <stdint.h>
#include "harfbuzz-shaper.h"

struct script_property {
  uint32_t range_start;
  uint32_t range_end;
  HB_Script script;
};

static const struct script_property script_properties[] = {
  {0x300, 0x36f, HB_Script_Inherited},
  {0x370, 0x373, HB_Script_Greek},
  {0x375, 0x377, HB_Script_Greek},
  {0x37a, 0x37d, HB_Script_Greek},
  {0x384, 0x384, HB_Script_Greek},
  {0x386, 0x386, HB_Script_Greek},
  {0x388, 0x38a, HB_Script_Greek},
  {0x38c, 0x38c, HB_Script_Greek},
  {0x38e, 0x3a1, HB_Script_Greek},
  {0x3a3, 0x3e1, HB_Script_Greek},
  {0x3f0, 0x3ff, HB_Script_Greek},
  {0x400, 0x523, HB_Script_Cyrillic},
  {0x531, 0x556, HB_Script_Armenian},
  {0x559, 0x55f, HB_Script_Armenian},
  {0x561, 0x587, HB_Script_Armenian},
  {0x58a, 0x58a, HB_Script_Armenian},
  {0x591, 0x5c7, HB_Script_Hebrew},
  {0x5d0, 0x5ea, HB_Script_Hebrew},
  {0x5f0, 0x5f4, HB_Script_Hebrew},
  /* BEGIN android-changed
     Some Arabic glyphs were just detected as HB_Script_Common when trying to get the script
     from their Unicode Point.
     The most relevant case is concerning the Android IME / Keyboard for Arabic as he is trying
     to shape diacritical marks (as single code point) for showing them on Keys.
     Also, putting uni0640, uni064B-uni0655 and uni0670 as Arabic can break Syriac script
  */
  {0x600, 0x603, HB_Script_Arabic},
  {0x606, 0x60f, HB_Script_Arabic},
  {0x610, 0x61b, HB_Script_Arabic},
  {0x61e, 0x61f, HB_Script_Arabic},
  {0x620, 0x63f, HB_Script_Arabic},
  {0x640, 0x64a, HB_Script_Arabic},
  {0x64b, 0x655, HB_Script_Arabic}, // was: HB_Script_Inherited
  {0x656, 0x65f, HB_Script_Arabic},
  {0x660, 0x669, HB_Script_Arabic},
  {0x66a, 0x66f, HB_Script_Arabic},
  {0x670, 0x670, HB_Script_Arabic}, // was: HB_Script_Inherited
  /* END android-changed */
  {0x671, 0x6dc, HB_Script_Arabic},
  {0x6de, 0x6ff, HB_Script_Arabic},
  {0x700, 0x70d, HB_Script_Syriac},
  {0x70f, 0x74a, HB_Script_Syriac},
  {0x74d, 0x74f, HB_Script_Syriac},
  {0x750, 0x77f, HB_Script_Arabic},
  {0x780, 0x7b1, HB_Script_Thaana},
  {0x901, 0x939, HB_Script_Devanagari},
  {0x93c, 0x94d, HB_Script_Devanagari},
  {0x950, 0x950, HB_Script_Devanagari},
  {0x951, 0x952, HB_Script_Inherited},
  {0x953, 0x954, HB_Script_Devanagari},
  {0x958, 0x963, HB_Script_Devanagari},
  {0x966, 0x96f, HB_Script_Devanagari},
  {0x971, 0x972, HB_Script_Devanagari},
  {0x97b, 0x97f, HB_Script_Devanagari},
  {0x981, 0x983, HB_Script_Bengali},
  {0x985, 0x98c, HB_Script_Bengali},
  {0x98f, 0x990, HB_Script_Bengali},
  {0x993, 0x9a8, HB_Script_Bengali},
  {0x9aa, 0x9b0, HB_Script_Bengali},
  {0x9b2, 0x9b2, HB_Script_Bengali},
  {0x9b6, 0x9b9, HB_Script_Bengali},
  {0x9bc, 0x9c4, HB_Script_Bengali},
  {0x9c7, 0x9c8, HB_Script_Bengali},
  {0x9cb, 0x9ce, HB_Script_Bengali},
  {0x9d7, 0x9d7, HB_Script_Bengali},
  {0x9dc, 0x9dd, HB_Script_Bengali},
  {0x9df, 0x9e3, HB_Script_Bengali},
  {0x9e6, 0x9fa, HB_Script_Bengali},
  {0xa01, 0xa03, HB_Script_Gurmukhi},
  {0xa05, 0xa0a, HB_Script_Gurmukhi},
  {0xa0f, 0xa10, HB_Script_Gurmukhi},
  {0xa13, 0xa28, HB_Script_Gurmukhi},
  {0xa2a, 0xa30, HB_Script_Gurmukhi},
  {0xa32, 0xa33, HB_Script_Gurmukhi},
  {0xa35, 0xa36, HB_Script_Gurmukhi},
  {0xa38, 0xa39, HB_Script_Gurmukhi},
  {0xa3c, 0xa3c, HB_Script_Gurmukhi},
  {0xa3e, 0xa42, HB_Script_Gurmukhi},
  {0xa47, 0xa48, HB_Script_Gurmukhi},
  {0xa4b, 0xa4d, HB_Script_Gurmukhi},
  {0xa51, 0xa51, HB_Script_Gurmukhi},
  {0xa59, 0xa5c, HB_Script_Gurmukhi},
  {0xa5e, 0xa5e, HB_Script_Gurmukhi},
  {0xa66, 0xa75, HB_Script_Gurmukhi},
  {0xa81, 0xa83, HB_Script_Gujarati},
  {0xa85, 0xa8d, HB_Script_Gujarati},
  {0xa8f, 0xa91, HB_Script_Gujarati},
  {0xa93, 0xaa8, HB_Script_Gujarati},
  {0xaaa, 0xab0, HB_Script_Gujarati},
  {0xab2, 0xab3, HB_Script_Gujarati},
  {0xab5, 0xab9, HB_Script_Gujarati},
  {0xabc, 0xac5, HB_Script_Gujarati},
  {0xac7, 0xac9, HB_Script_Gujarati},
  {0xacb, 0xacd, HB_Script_Gujarati},
  {0xad0, 0xad0, HB_Script_Gujarati},
  {0xae0, 0xae3, HB_Script_Gujarati},
  {0xae6, 0xaef, HB_Script_Gujarati},
  {0xaf1, 0xaf1, HB_Script_Gujarati},
  {0xb01, 0xb03, HB_Script_Oriya},
  {0xb05, 0xb0c, HB_Script_Oriya},
  {0xb0f, 0xb10, HB_Script_Oriya},
  {0xb13, 0xb28, HB_Script_Oriya},
  {0xb2a, 0xb30, HB_Script_Oriya},
  {0xb32, 0xb33, HB_Script_Oriya},
  {0xb35, 0xb39, HB_Script_Oriya},
  {0xb3c, 0xb44, HB_Script_Oriya},
  {0xb47, 0xb48, HB_Script_Oriya},
  {0xb4b, 0xb4d, HB_Script_Oriya},
  {0xb56, 0xb57, HB_Script_Oriya},
  {0xb5c, 0xb5d, HB_Script_Oriya},
  {0xb5f, 0xb63, HB_Script_Oriya},
  {0xb66, 0xb71, HB_Script_Oriya},
  {0xb82, 0xb83, HB_Script_Tamil},
  {0xb85, 0xb8a, HB_Script_Tamil},
  {0xb8e, 0xb90, HB_Script_Tamil},
  {0xb92, 0xb95, HB_Script_Tamil},
  {0xb99, 0xb9a, HB_Script_Tamil},
  {0xb9c, 0xb9c, HB_Script_Tamil},
  {0xb9e, 0xb9f, HB_Script_Tamil},
  {0xba3, 0xba4, HB_Script_Tamil},
  {0xba8, 0xbaa, HB_Script_Tamil},
  {0xbae, 0xbb9, HB_Script_Tamil},
  {0xbbe, 0xbc2, HB_Script_Tamil},
  {0xbc6, 0xbc8, HB_Script_Tamil},
  {0xbca, 0xbcd, HB_Script_Tamil},
  {0xbd0, 0xbd0, HB_Script_Tamil},
  {0xbd7, 0xbd7, HB_Script_Tamil},
  {0xbe6, 0xbfa, HB_Script_Tamil},
  {0xc01, 0xc03, HB_Script_Telugu},
  {0xc05, 0xc0c, HB_Script_Telugu},
  {0xc0e, 0xc10, HB_Script_Telugu},
  {0xc12, 0xc28, HB_Script_Telugu},
  {0xc2a, 0xc33, HB_Script_Telugu},
  {0xc35, 0xc39, HB_Script_Telugu},
  {0xc3d, 0xc44, HB_Script_Telugu},
  {0xc46, 0xc48, HB_Script_Telugu},
  {0xc4a, 0xc4d, HB_Script_Telugu},
  {0xc55, 0xc56, HB_Script_Telugu},
  {0xc58, 0xc59, HB_Script_Telugu},
  {0xc60, 0xc63, HB_Script_Telugu},
  {0xc66, 0xc6f, HB_Script_Telugu},
  {0xc78, 0xc7f, HB_Script_Telugu},
  {0xc82, 0xc83, HB_Script_Kannada},
  {0xc85, 0xc8c, HB_Script_Kannada},
  {0xc8e, 0xc90, HB_Script_Kannada},
  {0xc92, 0xca8, HB_Script_Kannada},
  {0xcaa, 0xcb3, HB_Script_Kannada},
  {0xcb5, 0xcb9, HB_Script_Kannada},
  {0xcbc, 0xcc4, HB_Script_Kannada},
  {0xcc6, 0xcc8, HB_Script_Kannada},
  {0xcca, 0xccd, HB_Script_Kannada},
  {0xcd5, 0xcd6, HB_Script_Kannada},
  {0xcde, 0xcde, HB_Script_Kannada},
  {0xce0, 0xce3, HB_Script_Kannada},
  {0xce6, 0xcef, HB_Script_Kannada},
  {0xd02, 0xd03, HB_Script_Malayalam},
  {0xd05, 0xd0c, HB_Script_Malayalam},
  {0xd0e, 0xd10, HB_Script_Malayalam},
  {0xd12, 0xd28, HB_Script_Malayalam},
  {0xd2a, 0xd39, HB_Script_Malayalam},
  {0xd3d, 0xd44, HB_Script_Malayalam},
  {0xd46, 0xd48, HB_Script_Malayalam},
  {0xd4a, 0xd4d, HB_Script_Malayalam},
  {0xd57, 0xd57, HB_Script_Malayalam},
  {0xd60, 0xd63, HB_Script_Malayalam},
  {0xd66, 0xd75, HB_Script_Malayalam},
  {0xd79, 0xd7f, HB_Script_Malayalam},
  {0xd82, 0xd83, HB_Script_Sinhala},
  {0xd85, 0xd96, HB_Script_Sinhala},
  {0xd9a, 0xdb1, HB_Script_Sinhala},
  {0xdb3, 0xdbb, HB_Script_Sinhala},
  {0xdbd, 0xdbd, HB_Script_Sinhala},
  {0xdc0, 0xdc6, HB_Script_Sinhala},
  {0xdca, 0xdca, HB_Script_Sinhala},
  {0xdcf, 0xdd4, HB_Script_Sinhala},
  {0xdd6, 0xdd6, HB_Script_Sinhala},
  {0xdd8, 0xddf, HB_Script_Sinhala},
  {0xdf2, 0xdf4, HB_Script_Sinhala},
  {0xe01, 0xe3a, HB_Script_Thai},
  {0xe40, 0xe5b, HB_Script_Thai},
  {0xe81, 0xe82, HB_Script_Lao},
  {0xe84, 0xe84, HB_Script_Lao},
  {0xe87, 0xe88, HB_Script_Lao},
  {0xe8a, 0xe8a, HB_Script_Lao},
  {0xe8d, 0xe8d, HB_Script_Lao},
  {0xe94, 0xe97, HB_Script_Lao},
  {0xe99, 0xe9f, HB_Script_Lao},
  {0xea1, 0xea3, HB_Script_Lao},
  {0xea5, 0xea5, HB_Script_Lao},
  {0xea7, 0xea7, HB_Script_Lao},
  {0xeaa, 0xeab, HB_Script_Lao},
  {0xead, 0xeb9, HB_Script_Lao},
  {0xebb, 0xebd, HB_Script_Lao},
  {0xec0, 0xec4, HB_Script_Lao},
  {0xec6, 0xec6, HB_Script_Lao},
  {0xec8, 0xecd, HB_Script_Lao},
  {0xed0, 0xed9, HB_Script_Lao},
  {0xedc, 0xedd, HB_Script_Lao},
  {0xf00, 0xf47, HB_Script_Tibetan},
  {0xf49, 0xf6c, HB_Script_Tibetan},
  {0xf71, 0xf8b, HB_Script_Tibetan},
  {0xf90, 0xf97, HB_Script_Tibetan},
  {0xf99, 0xfbc, HB_Script_Tibetan},
  {0xfbe, 0xfcc, HB_Script_Tibetan},
  {0xfce, 0xfd4, HB_Script_Tibetan},
  {0x1000, 0x1099, HB_Script_Myanmar},
  {0x109e, 0x109f, HB_Script_Myanmar},
  {0x10a0, 0x10c5, HB_Script_Georgian},
  {0x10d0, 0x10fa, HB_Script_Georgian},
  {0x10fc, 0x10fc, HB_Script_Georgian},
  {0x1100, 0x1159, HB_Script_Hangul},
  {0x115f, 0x11a2, HB_Script_Hangul},
  {0x11a8, 0x11f9, HB_Script_Hangul},
  {0x1680, 0x169c, HB_Script_Ogham},
  {0x16a0, 0x16ea, HB_Script_Runic},
  {0x16ee, 0x16f0, HB_Script_Runic},
  {0x1780, 0x17dd, HB_Script_Khmer},
  {0x17e0, 0x17e9, HB_Script_Khmer},
  {0x17f0, 0x17f9, HB_Script_Khmer},
  {0x19e0, 0x19ff, HB_Script_Khmer},
  {0x1d26, 0x1d2a, HB_Script_Greek},
  {0x1d2b, 0x1d2b, HB_Script_Cyrillic},
  {0x1d5d, 0x1d61, HB_Script_Greek},
  {0x1d66, 0x1d6a, HB_Script_Greek},
  {0x1d78, 0x1d78, HB_Script_Cyrillic},
  {0x1dbf, 0x1dbf, HB_Script_Greek},
  {0x1dc0, 0x1de6, HB_Script_Inherited},
  {0x1dfe, 0x1dff, HB_Script_Inherited},
  {0x1f00, 0x1f15, HB_Script_Greek},
  {0x1f18, 0x1f1d, HB_Script_Greek},
  {0x1f20, 0x1f45, HB_Script_Greek},
  {0x1f48, 0x1f4d, HB_Script_Greek},
  {0x1f50, 0x1f57, HB_Script_Greek},
  {0x1f59, 0x1f59, HB_Script_Greek},
  {0x1f5b, 0x1f5b, HB_Script_Greek},
  {0x1f5d, 0x1f5d, HB_Script_Greek},
  {0x1f5f, 0x1f7d, HB_Script_Greek},
  {0x1f80, 0x1fb4, HB_Script_Greek},
  {0x1fb6, 0x1fc4, HB_Script_Greek},
  {0x1fc6, 0x1fd3, HB_Script_Greek},
  {0x1fd6, 0x1fdb, HB_Script_Greek},
  {0x1fdd, 0x1fef, HB_Script_Greek},
  {0x1ff2, 0x1ff4, HB_Script_Greek},
  {0x1ff6, 0x1ffe, HB_Script_Greek},
  {0x200c, 0x200d, HB_Script_Inherited},
  {0x20d0, 0x20f0, HB_Script_Inherited},
  {0x2126, 0x2126, HB_Script_Greek},
  {0x2d00, 0x2d25, HB_Script_Georgian},
  {0x2de0, 0x2dff, HB_Script_Cyrillic},
  {0x302a, 0x302f, HB_Script_Inherited},
  {0x3099, 0x309a, HB_Script_Inherited},
  {0x3131, 0x318e, HB_Script_Hangul},
  {0x3200, 0x321e, HB_Script_Hangul},
  {0x3260, 0x327e, HB_Script_Hangul},
  {0xa640, 0xa65f, HB_Script_Cyrillic},
  {0xa662, 0xa673, HB_Script_Cyrillic},
  {0xa67c, 0xa697, HB_Script_Cyrillic},
  {0xac00, 0xd7a3, HB_Script_Hangul},
  {0xfb13, 0xfb17, HB_Script_Armenian},
  {0xfb1d, 0xfb36, HB_Script_Hebrew},
  {0xfb38, 0xfb3c, HB_Script_Hebrew},
  {0xfb3e, 0xfb3e, HB_Script_Hebrew},
  {0xfb40, 0xfb41, HB_Script_Hebrew},
  {0xfb43, 0xfb44, HB_Script_Hebrew},
  {0xfb46, 0xfb4f, HB_Script_Hebrew},
  {0xfb50, 0xfbb1, HB_Script_Arabic},
  {0xfbd3, 0xfd3d, HB_Script_Arabic},
  {0xfd50, 0xfd8f, HB_Script_Arabic},
  {0xfd92, 0xfdc7, HB_Script_Arabic},
  {0xfdf0, 0xfdfc, HB_Script_Arabic},
  {0xfe00, 0xfe0f, HB_Script_Inherited},
  {0xfe20, 0xfe26, HB_Script_Inherited},
  {0xfe70, 0xfe74, HB_Script_Arabic},
  {0xfe76, 0xfefc, HB_Script_Arabic},
  {0xffa0, 0xffbe, HB_Script_Hangul},
  {0xffc2, 0xffc7, HB_Script_Hangul},
  {0xffca, 0xffcf, HB_Script_Hangul},
  {0xffd2, 0xffd7, HB_Script_Hangul},
  {0xffda, 0xffdc, HB_Script_Hangul},
  {0x10140, 0x1018a, HB_Script_Greek},
  {0x101fd, 0x101fd, HB_Script_Inherited},
  {0x1d167, 0x1d169, HB_Script_Inherited},
  {0x1d17b, 0x1d182, HB_Script_Inherited},
  {0x1d185, 0x1d18b, HB_Script_Inherited},
  {0x1d1aa, 0x1d1ad, HB_Script_Inherited},
  {0x1d200, 0x1d245, HB_Script_Greek},
  {0xe0100, 0xe01ef, HB_Script_Inherited},
};

static const unsigned script_properties_count = 277;

#endif  // SCRIPT_PROPERTIES_H_
