// For documentation of the format, see README in this directory.
var browserTests = [
["foo[bar]baz",
    [["inserttext","a"]],
    "fooa[]baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[bar]baz",
    [["inserttext",""]],
    "foo[]baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","\t"]],
    "foo\t[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","&"]],
    "foo&amp;[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["defaultparagraphseparator","div"],["inserttext","\n"]],
    "<div>foo</div><div>{}bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["defaultparagraphseparator","p"],["inserttext","\n"]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["defaultparagraphseparator","div"],["inserttext","abc\ndef"]],
    "<div>fooabc</div><div>def[]bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["defaultparagraphseparator","p"],["inserttext","abc\ndef"]],
    "<p>fooabc</p><p>def[]bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","\u0007"]],
    "foo\u0007[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","<b>hi</b>"]],
    "foo&lt;b&gt;hi&lt;/b&gt;[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","<"]],
    "foo&lt;[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","&amp;"]],
    "foo&amp;amp;[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext"," "]],
    "foo []bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo []bar",
    [["inserttext"," "]],
    "foo&nbsp; []bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[] bar",
    [["inserttext"," "]],
    "foo&nbsp;[] bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo &nbsp;[]bar",
    [["inserttext"," "]],
    "foo &nbsp; []bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo []&nbsp;bar",
    [["inserttext"," "]],
    "foo &nbsp;[] bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[] &nbsp;bar",
    [["inserttext"," "]],
    "foo []&nbsp; bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp; []bar",
    [["inserttext"," "]],
    "foo &nbsp; []bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[] bar",
    [["inserttext"," "]],
    "foo &nbsp;[] bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]&nbsp; bar",
    [["inserttext"," "]],
    "foo []&nbsp; bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;&nbsp;[]bar",
    [["inserttext"," "]],
    "foo &nbsp; []bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[]&nbsp;bar",
    [["inserttext"," "]],
    "foo &nbsp;[] bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]&nbsp;&nbsp;bar",
    [["inserttext"," "]],
    "foo []&nbsp; bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo []&nbsp;        bar",
    [["inserttext"," "]],
    "foo &nbsp;[]&nbsp; bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo  []bar",
    [["inserttext"," "]],
    "foo&nbsp; []bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo []&nbsp;&nbsp; &nbsp; bar",
    [["inserttext"," "]],
    "foo &nbsp;[] &nbsp; &nbsp; bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["[]foo",
    [["inserttext"," "]],
    "&nbsp;[]foo",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["{}foo",
    [["inserttext"," "]],
    "&nbsp;[]foo",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]",
    [["inserttext"," "]],
    "foo&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo{}",
    [["inserttext"," "]],
    "foo&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[]",
    [["inserttext"," "]],
    "foo &nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;{}",
    [["inserttext"," "]],
    "foo &nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;&nbsp;[]",
    [["inserttext"," "]],
    "foo &nbsp;&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;&nbsp;{}",
    [["inserttext"," "]],
    "foo &nbsp;&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<b>foo[]</b>bar",
    [["inserttext"," "]],
    "<b>foo []</b>bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]<b>bar</b>",
    [["inserttext"," "]],
    "foo []<b>bar</b>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[] ",
    [["inserttext"," "]],
    "foo&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
[" foo   []   ",
    [["inserttext"," "]],
    " foo&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]<span> </span>",
    [["inserttext"," "]],
    "foo&nbsp;[]<span> </span>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]<span> </span> ",
    [["inserttext"," "]],
    "foo&nbsp;[]<span> </span> ",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
[" []foo",
    [["inserttext"," "]],
    "&nbsp;[]foo",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["   []   foo ",
    [["inserttext"," "]],
    "&nbsp;[]foo ",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<span> </span>[]foo",
    [["inserttext"," "]],
    "<span> </span>&nbsp;[]foo",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
[" <span> </span>[]foo",
    [["inserttext"," "]],
    " <span> </span>&nbsp;[]foo",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["{}<br>",
    [["inserttext"," "]],
    "&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>{}<br>",
    [["inserttext"," "]],
    "<p>&nbsp;[]</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo[]<p>bar",
    [["inserttext"," "]],
    "<p>foo&nbsp;[]</p><p>bar</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo&nbsp;[]<p>bar",
    [["inserttext"," "]],
    "<p>foo &nbsp;[]</p><p>bar</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo[]<p>&nbsp;bar",
    [["inserttext"," "]],
    "<p>foo&nbsp;[]</p><p>&nbsp;bar</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo[]bar</pre>",
    [["inserttext"," "]],
    "<pre>foo []bar</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo []bar</pre>",
    [["inserttext"," "]],
    "<pre>foo  []bar</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo[] bar</pre>",
    [["inserttext"," "]],
    "<pre>foo [] bar</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo &nbsp;[]bar</pre>",
    [["inserttext"," "]],
    "<pre>foo &nbsp; []bar</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>[]foo</pre>",
    [["inserttext"," "]],
    "<pre> []foo</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo[]</pre>",
    [["inserttext"," "]],
    "<pre>foo []</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo&nbsp;[]</pre>",
    [["inserttext"," "]],
    "<pre>foo&nbsp; []</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre> foo   []   </pre>",
    [["inserttext"," "]],
    "<pre> foo    []   </pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\">foo []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo []bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\">foo  []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[] bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\">foo [] bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo &nbsp;[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\">foo &nbsp; []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>[]foo</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\"> []foo</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\">foo []</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo&nbsp;[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\">foo&nbsp; []</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre> foo   []   </div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\"> foo    []   </div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo []bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo  []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[] bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo [] bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo &nbsp;[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo &nbsp; []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>[]foo</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\"> []foo</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo []</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo&nbsp;[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo&nbsp; []</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap> foo   []   </div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\"> foo    []   </div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\">foo []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo []bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\">foo&nbsp; []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[] bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\">foo&nbsp;[] bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo &nbsp;[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\">foo &nbsp; []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>[]foo</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\">&nbsp;[]foo</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\">foo&nbsp;[]</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo&nbsp;[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\">foo &nbsp;[]</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line> foo   []   </div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\"> foo&nbsp;[]</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\">foo []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo []bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\">foo&nbsp; []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[] bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\">foo&nbsp;[] bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo &nbsp;[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\">foo &nbsp; []bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>[]foo</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\">&nbsp;[]foo</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\">foo&nbsp;[]</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo&nbsp;[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\">foo &nbsp;[]</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap> foo   []   </div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\"> foo&nbsp;[]</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
    [["inserttext"," "]],
    "<a href=\"http://a\">http://a</a>&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["ftp://a[]",
    [["inserttext"," "]],
    "<a href=\"ftp://a\">ftp://a</a>&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["quasit://a[]",
    [["inserttext"," "]],
    "<a href=\"quasit://a\">quasit://a</a>&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
[".x-++-.://a[]",
    [["inserttext"," "]],
    ".<a href=\"x-++-.://a\">x-++-.://a</a>&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["(http://a)[]",
    [["inserttext"," "]],
    "(<a href=\"http://a\">http://a</a>)&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["&lt;http://a>[]",
    [["inserttext"," "]],
    "&lt;<a href=\"http://a\">http://a</a>&gt;&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a![]",
    [["inserttext"," "]],
    "<a href=\"http://a\">http://a</a>!&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~http://a!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~[]",
    [["inserttext"," "]],
    "!\"#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~<a href=\"http://a!&quot;#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~\">http://a!\"#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~</a>&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a!\"'(),-.:;&lt;>`[]",
    [["inserttext"," "]],
    "<a href=\"http://a\">http://a</a>!\"'(),-.:;&lt;&gt;`&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a#$%&amp;*+/=?^_|~[]",
    [["inserttext"," "]],
    "<a href=\"http://a#$%&amp;*+/=?^_|~\">http://a#$%&amp;*+/=?^_|~</a>&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["mailto:a[]",
    [["inserttext"," "]],
    "<a href=\"mailto:a\">mailto:a</a>&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["a@b[]",
    [["inserttext"," "]],
    "<a href=\"mailto:a@b\">a@b</a>&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["a@[]",
    [["inserttext"," "]],
    "a@&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["@b[]",
    [["inserttext"," "]],
    "@b&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["#@x[]",
    [["inserttext"," "]],
    "<a href=\"mailto:#@x\">#@x</a>&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["a@.[]",
    [["inserttext"," "]],
    "a@.&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~a@b!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~[]",
    [["inserttext"," "]],
    "!\"#$%&amp;'()*+,-./:;&lt;=&gt;<a href=\"mailto:?^_`|~a@b\">?^_`|~a@b</a>!\"#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<b>a@b</b>{}",
    [["inserttext"," "]],
    "<a href=\"mailto:a@b\"><b>a@b</b></a> []",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<b>a</b><i>@</i><u>b</u>{}",
    [["inserttext"," "]],
    "<b>a</b><i>@</i><u>b</u> []",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["a@b<b>[]c</b>",
    [["inserttext"," "]],
    "<a href=\"mailto:a@b\">a@b</a><b> []c</b>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>a@b</p><p>[]c</p>",
    [["inserttext"," "]],
    "<p>a@b</p><p>&nbsp;[]c</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
    [["inserttext","a"]],
    "http://aa[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
    [["inserttext","\t"]],
    "<a href=\"http://a\">http://a</a>\t[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
    [["inserttext","\f"]],
    "<a href=\"http://a\">http://a</a>\f[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
    [["inserttext"," "]],
    "http://a&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]",
    [["inserttext","   "]],
    "foo &nbsp;&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","a"]],
    "fooa[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[]",
    [["inserttext","a"]],
    "foo a[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo []",
    [["inserttext","a"]],
    "foo a[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo[]",
    [["inserttext","a"]],
    "<p>fooa[]</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo</p>{}",
    [["inserttext","a"]],
    "<p>foo</p>a[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>[]foo",
    [["inserttext","a"]],
    "<p>a[]foo</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>{}foo",
    [["inserttext","a"]],
    "<p>a[]foo</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["{}<p>foo",
    [["inserttext","a"]],
    "a[]<p>foo</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo</p>{}<p>bar</p>",
    [["inserttext","a"]],
    "<p>foo</p>a[]<p>bar</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<b>foo[]</b>bar",
    [["inserttext","a"]],
    "<b>fooa[]</b>bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<b>foo</b>[]bar",
    [["inserttext","a"]],
    "<b>foo</b>a[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<b>{}</b>bar",
    [["inserttext","a"]],
    "foo<b>a[]</b>bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<a>foo[]</a>bar",
    [["inserttext","a"]],
    "<a>fooa[]</a>bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<a>foo</a>[]bar",
    [["inserttext","a"]],
    "<a>foo</a>a[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<a href=/>foo[]</a>bar",
    [["inserttext","a"]],
    "<a href=\"/\">fooa[]</a>bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<a href=/>foo</a>[]bar",
    [["inserttext","a"]],
    "<a href=\"/\">foo</a>a[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>b]ar",
    [["defaultparagraphseparator","div"],["inserttext","a"]],
    "<p>foa[]ar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>b]ar",
    [["defaultparagraphseparator","p"],["inserttext","a"]],
    "<p>foa[]ar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>bar<p>b]az",
    [["defaultparagraphseparator","div"],["inserttext","a"]],
    "<p>foa[]az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>bar<p>b]az",
    [["defaultparagraphseparator","p"],["inserttext","a"]],
    "<p>foa[]az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["{}<br>",
    [["inserttext","a"]],
    "a[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>{}<br>",
    [["inserttext","a"]],
    "<p>a[]</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p><span>{}<br></span>",
    [["inserttext","a"]],
    "<p><span>a[]</span></p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
    [["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>baz</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
    [["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>baz</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
    [["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>baz</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "<p>a[]baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "<p>a[]baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "<p>a[]baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "<p>a[]baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
    [["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span></p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
    [["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span></p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","true"],["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>quz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","false"],["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>quz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
    [["inserttext","a"]],
    "foo<b>a[]</b>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<i>[bar]</i>baz",
    [["inserttext","a"]],
    "foo<i>a[]</i>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<s>[bar]</s>baz",
    [["inserttext","a"]],
    "foo<s>a[]</s>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub>[bar]</sub>baz",
    [["inserttext","a"]],
    "foo<sub>a[]</sub>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sup>[bar]</sup>baz",
    [["inserttext","a"]],
    "foo<sup>a[]</sup>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<u>[bar]</u>baz",
    [["inserttext","a"]],
    "foo<u>a[]</u>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com>[bar]</a>baz",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font face=sans-serif>[bar]</font>baz",
    [["inserttext","a"]],
    "foo<font face=\"sans-serif\">a[]</font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=4>[bar]</font>baz",
    [["inserttext","a"]],
    "foo<font size=\"4\">a[]</font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=#0000FF>[bar]</font>baz",
    [["inserttext","a"]],
    "foo<font color=\"#0000FF\">a[]</font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<span style=background-color:#00FFFF>[bar]</span>baz",
    [["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=blue>[bar]</font></a>baz",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"blue\">a[]</font></a>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=blue><a href=http://www.google.com>[bar]</a></font>baz",
    [["inserttext","a"]],
    "foo<font color=\"blue\"><a href=\"http://www.google.com\">a[]</a></font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=brown>[bar]</font></a>baz",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"brown\">a[]</font></a>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=brown><a href=http://www.google.com>[bar]</a></font>baz",
    [["inserttext","a"]],
    "foo<font color=\"brown\"><a href=\"http://www.google.com\">a[]</a></font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=black>[bar]</font></a>baz",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"black\">a[]</font></a>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><u>[bar]</u></a>baz",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><u>a[]</u></a>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<u><a href=http://www.google.com>[bar]</a></u>baz",
    [["inserttext","a"]],
    "foo<u><a href=\"http://www.google.com\">a[]</a></u>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=2>[bar]</font></sub>baz",
    [["inserttext","a"]],
    "foo<sub><font size=\"2\">a[]</font></sub>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=2><sub>[bar]</sub></font>baz",
    [["inserttext","a"]],
    "foo<font size=\"2\"><sub>a[]</sub></font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=3>[bar]</font></sub>baz",
    [["inserttext","a"]],
    "foo<sub><font size=\"3\">a[]</font></sub>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=3><sub>[bar]</sub></font>baz",
    [["inserttext","a"]],
    "foo<font size=\"3\"><sub>a[]</sub></font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["[foo<b>bar]</b>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<b>bar]</b>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<i>bar]</i>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<i>bar]</i>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<s>bar]</s>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<s>bar]</s>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub>bar]</sub>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub>bar]</sub>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sup>bar]</sup>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sup>bar]</sup>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u>bar]</u>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u>bar]</u>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com>bar]</a>baz",
    [["inserttext","a"]],
    "a[]baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["[foo<font face=sans-serif>bar]</font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font face=sans-serif>bar]</font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=4>bar]</font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=4>bar]</font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=#0000FF>bar]</font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=#0000FF>bar]</font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<span style=background-color:#00FFFF>bar]</span>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<span style=background-color:#00FFFF>bar]</span>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=blue>bar]</font></a>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=blue>bar]</font></a>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=blue><a href=http://www.google.com>bar]</a></font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=blue><a href=http://www.google.com>bar]</a></font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=brown>bar]</font></a>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=brown>bar]</font></a>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=brown><a href=http://www.google.com>bar]</a></font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=brown><a href=http://www.google.com>bar]</a></font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=black>bar]</font></a>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=black>bar]</font></a>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><u>bar]</u></a>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><u>bar]</u></a>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u><a href=http://www.google.com>bar]</a></u>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u><a href=http://www.google.com>bar]</a></u>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=2>bar]</font></sub>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=2>bar]</font></sub>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=2><sub>bar]</sub></font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=2><sub>bar]</sub></font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=3>bar]</font></sub>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=3>bar]</font></sub>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=3><sub>bar]</sub></font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=3><sub>bar]</sub></font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<b>[bar</b>baz]",
    [["inserttext","a"]],
    "foo<b>a[]</b>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<i>[bar</i>baz]",
    [["inserttext","a"]],
    "foo<i>a[]</i>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<s>[bar</s>baz]",
    [["inserttext","a"]],
    "foo<s>a[]</s>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub>[bar</sub>baz]",
    [["inserttext","a"]],
    "foo<sub>a[]</sub>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sup>[bar</sup>baz]",
    [["inserttext","a"]],
    "foo<sup>a[]</sup>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<u>[bar</u>baz]",
    [["inserttext","a"]],
    "foo<u>a[]</u>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com>[bar</a>baz]",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font face=sans-serif>[bar</font>baz]",
    [["inserttext","a"]],
    "foo<font face=\"sans-serif\">a[]</font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=4>[bar</font>baz]",
    [["inserttext","a"]],
    "foo<font size=\"4\">a[]</font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=#0000FF>[bar</font>baz]",
    [["inserttext","a"]],
    "foo<font color=\"#0000FF\">a[]</font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<span style=background-color:#00FFFF>[bar</span>baz]",
    [["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=blue>[bar</font></a>baz]",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"blue\">a[]</font></a>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=blue><a href=http://www.google.com>[bar</a></font>baz]",
    [["inserttext","a"]],
    "foo<font color=\"blue\"><a href=\"http://www.google.com\">a[]</a></font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=brown>[bar</font></a>baz]",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"brown\">a[]</font></a>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=brown><a href=http://www.google.com>[bar</a></font>baz]",
    [["inserttext","a"]],
    "foo<font color=\"brown\"><a href=\"http://www.google.com\">a[]</a></font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=black>[bar</font></a>baz]",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"black\">a[]</font></a>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><u>[bar</u></a>baz]",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><u>a[]</u></a>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<u><a href=http://www.google.com>[bar</a></u>baz]",
    [["inserttext","a"]],
    "foo<u><a href=\"http://www.google.com\">a[]</a></u>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=2>[bar</font></sub>baz]",
    [["inserttext","a"]],
    "foo<sub><font size=\"2\">a[]</font></sub>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=2><sub>[bar</sub></font>baz]",
    [["inserttext","a"]],
    "foo<font size=\"2\"><sub>a[]</sub></font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=3>[bar</font></sub>baz]",
    [["inserttext","a"]],
    "foo<sub><font size=\"3\">a[]</font></sub>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=3><sub>[bar</sub></font>baz]",
    [["inserttext","a"]],
    "foo<font size=\"3\"><sub>a[]</sub></font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<blockquote><font color=blue>[foo]</font></blockquote>",
    [["inserttext","a"]],
    "<blockquote><font color=\"blue\">a[]</font></blockquote>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}]
]
