/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Polygon;
import java.io.IOException;
import org.jhotdraw.figures.AbstractLineDecoration;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class ArrowTip
extends AbstractLineDecoration {
    private double fAngle;
    private double fOuterRadius;
    private double fInnerRadius;
    private static final long serialVersionUID = -3459171428373823638L;
    private int arrowTipSerializedDataVersion = 1;

    public ArrowTip() {
        this(0.4, 8.0, 8.0);
    }

    public ArrowTip(double d, double d2, double d3) {
        this.setAngle(d);
        this.setOuterRadius(d2);
        this.setInnerRadius(d3);
    }

    public Polygon outline(int n, int n2, int n3, int n4) {
        double d = 1.5707963267948966 - Math.atan2(n3 - n, n4 - n2);
        return this.outline(n, n2, d);
    }

    private Polygon outline(int n, int n2, double d) {
        Polygon polygon = new Polygon();
        polygon.addPoint(n, n2);
        this.addPointRelative(polygon, n, n2, this.getOuterRadius(), d - this.getAngle());
        this.addPointRelative(polygon, n, n2, this.getInnerRadius(), d);
        this.addPointRelative(polygon, n, n2, this.getOuterRadius(), d + this.getAngle());
        polygon.addPoint(n, n2);
        return polygon;
    }

    private void addPointRelative(Polygon polygon, int n, int n2, double d, double d2) {
        polygon.addPoint(n + (int)(d * Math.cos(d2)), n2 + (int)(d * Math.sin(d2)));
    }

    public void write(StorableOutput storableOutput) {
        storableOutput.writeDouble(this.getAngle());
        storableOutput.writeDouble(this.getOuterRadius());
        storableOutput.writeDouble(this.getInnerRadius());
        super.write(storableOutput);
    }

    public void read(StorableInput storableInput) throws IOException {
        this.setAngle(storableInput.readDouble());
        this.setOuterRadius(storableInput.readDouble());
        this.setInnerRadius(storableInput.readDouble());
        super.read(storableInput);
    }

    protected void setAngle(double d) {
        this.fAngle = d;
    }

    protected double getAngle() {
        return this.fAngle;
    }

    protected void setInnerRadius(double d) {
        this.fInnerRadius = d;
    }

    protected double getInnerRadius() {
        return this.fInnerRadius;
    }

    protected void setOuterRadius(double d) {
        this.fOuterRadius = d;
    }

    protected double getOuterRadius() {
        return this.fOuterRadius;
    }

    public String getMap() {
        return "";
    }
}

