// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

package language

import "golang.org/x/text/internal/tag"

// CLDRVersion is the CLDR version from which the tables in this package are derived.
const CLDRVersion = "30"

const numLanguages = 8654

const numScripts = 230

const numRegions = 356

type fromTo struct {
	from uint16
	to   uint16
}

const nonCanonicalUnd = 1191
const (
	_af  = 21
	_am  = 38
	_ar  = 57
	_az  = 87
	_bg  = 125
	_bn  = 163
	_ca  = 213
	_cs  = 246
	_da  = 253
	_de  = 265
	_el  = 305
	_en  = 308
	_es  = 313
	_et  = 315
	_fa  = 323
	_fi  = 332
	_fil = 334
	_fr  = 345
	_gu  = 413
	_he  = 437
	_hi  = 439
	_hr  = 458
	_hu  = 462
	_hy  = 464
	_id  = 474
	_is  = 496
	_it  = 497
	_ja  = 504
	_ka  = 520
	_kk  = 570
	_km  = 578
	_kn  = 585
	_ko  = 587
	_ky  = 641
	_lo  = 687
	_lt  = 695
	_lv  = 702
	_mk  = 758
	_ml  = 763
	_mn  = 770
	_mo  = 775
	_mr  = 786
	_ms  = 790
	_mul = 797
	_my  = 808
	_nb  = 830
	_ne  = 840
	_nl  = 862
	_no  = 870
	_pa  = 916
	_pl  = 938
	_pt  = 951
	_ro  = 979
	_ru  = 985
	_sh  = 1021
	_si  = 1026
	_sk  = 1032
	_sl  = 1036
	_sq  = 1063
	_sr  = 1064
	_sv  = 1082
	_sw  = 1083
	_ta  = 1094
	_te  = 1111
	_th  = 1121
	_tl  = 1136
	_tn  = 1142
	_tr  = 1152
	_uk  = 1188
	_ur  = 1194
	_uz  = 1202
	_vi  = 1209
	_zh  = 1311
	_zu  = 1316
	_jbo = 507
	_ami = 1639
	_bnn = 2346
	_hak = 431
	_tlh = 14456
	_lb  = 652
	_nv  = 890
	_pwn = 12044
	_tao = 14177
	_tay = 14187
	_tsu = 14651
	_nn  = 865
	_sfb = 13618
	_vgt = 15690
	_sgg = 13649
	_cmn = 2996
	_nan = 826
	_hsn = 460
)

const langPrivateStart = 0x2f67

const langPrivateEnd = 0x316e

// lang holds an alphabetically sorted list of ISO-639 language identifiers.
// All entries are 4 bytes. The index of the identifier (divided by 4) is the language tag.
// For 2-byte language identifiers, the two successive bytes have the following meaning:
//     - if the first letter of the 2- and 3-letter ISO codes are the same:
//       the second and third letter of the 3-letter ISO code.
//     - otherwise: a 0 and a by 2 bits right-shifted index into altLangISO3.
// For 3-byte language identifiers the 4th byte is 0.
const lang tag.Index = "" + // Size: 5280 bytes
	"---\x00aaaraai\x00aak\x00aau\x00abbkabi\x00abr\x00abt\x00aby\x00acd\x00a" +
	"ce\x00ach\x00ada\x00ade\x00adj\x00ady\x00adz\x00aeveaeb\x00aey\x00affrag" +
	"c\x00agd\x00agg\x00agm\x00ago\x00agq\x00aha\x00ahl\x00aho\x00ajg\x00akka" +
	"akk\x00ala\x00ali\x00aln\x00alt\x00ammhamm\x00amn\x00amo\x00amp\x00anrga" +
	"nc\x00ank\x00ann\x00any\x00aoj\x00aom\x00aoz\x00apc\x00apd\x00ape\x00apr" +
	"\x00aps\x00apz\x00arraarc\x00arh\x00arn\x00aro\x00arq\x00ars\x00ary\x00a" +
	"rz\x00assmasa\x00ase\x00asg\x00aso\x00ast\x00ata\x00atg\x00atj\x00auy" +
	"\x00avvaavl\x00avn\x00avt\x00avu\x00awa\x00awb\x00awo\x00awx\x00ayymayb" +
	"\x00azzebaakbal\x00ban\x00bap\x00bar\x00bas\x00bav\x00bax\x00bba\x00bbb" +
	"\x00bbc\x00bbd\x00bbj\x00bbp\x00bbr\x00bcf\x00bch\x00bci\x00bcm\x00bcn" +
	"\x00bco\x00bcq\x00bcu\x00bdd\x00beelbef\x00beh\x00bej\x00bem\x00bet\x00b" +
	"ew\x00bex\x00bez\x00bfd\x00bfq\x00bft\x00bfy\x00bgulbgc\x00bgn\x00bgx" +
	"\x00bhihbhb\x00bhg\x00bhi\x00bhk\x00bhl\x00bho\x00bhy\x00biisbib\x00big" +
	"\x00bik\x00bim\x00bin\x00bio\x00biq\x00bjh\x00bji\x00bjj\x00bjn\x00bjo" +
	"\x00bjr\x00bjz\x00bkc\x00bkm\x00bkq\x00bku\x00bkv\x00blt\x00bmambmh\x00b" +
	"mk\x00bmq\x00bmu\x00bnenbng\x00bnm\x00bnp\x00boodboj\x00bom\x00bon\x00bp" +
	"y\x00bqc\x00bqi\x00bqp\x00bqv\x00brrebra\x00brh\x00brx\x00brz\x00bsosbsj" +
	"\x00bsq\x00bss\x00bst\x00bto\x00btt\x00btv\x00bua\x00buc\x00bud\x00bug" +
	"\x00buk\x00bum\x00buo\x00bus\x00buu\x00bvb\x00bwd\x00bwr\x00bxh\x00bye" +
	"\x00byn\x00byr\x00bys\x00byv\x00byx\x00bza\x00bze\x00bzf\x00bzh\x00bzw" +
	"\x00caatcan\x00cbj\x00cch\x00ccp\x00ceheceb\x00cfa\x00cgg\x00chhachk\x00" +
	"chm\x00cho\x00chp\x00chr\x00cja\x00cjm\x00cjv\x00ckb\x00ckl\x00cko\x00ck" +
	"y\x00cla\x00cme\x00cooscop\x00cps\x00crrecrj\x00crk\x00crl\x00crm\x00crs" +
	"\x00csescsb\x00csw\x00ctd\x00cuhucvhvcyymdaandad\x00daf\x00dag\x00dah" +
	"\x00dak\x00dar\x00dav\x00dbd\x00dbq\x00dcc\x00ddn\x00deeuded\x00den\x00d" +
	"ga\x00dgh\x00dgi\x00dgl\x00dgr\x00dgz\x00dia\x00dje\x00dnj\x00dob\x00doi" +
	"\x00dop\x00dow\x00dri\x00drs\x00dsb\x00dtm\x00dtp\x00dts\x00dty\x00dua" +
	"\x00duc\x00dud\x00dug\x00dvivdva\x00dww\x00dyo\x00dyu\x00dzzodzg\x00ebu" +
	"\x00eeweefi\x00egl\x00egy\x00eky\x00elllema\x00emi\x00enngenn\x00enq\x00" +
	"eopoeri\x00es\x00\x05esu\x00etstetr\x00ett\x00etu\x00etx\x00euusewo\x00e" +
	"xt\x00faasfaa\x00fab\x00fag\x00fai\x00fan\x00ffulffi\x00ffm\x00fiinfia" +
	"\x00fil\x00fit\x00fjijflr\x00fmp\x00foaofod\x00fon\x00for\x00fpe\x00fqs" +
	"\x00frrafrc\x00frp\x00frr\x00frs\x00fub\x00fud\x00fue\x00fuf\x00fuh\x00f" +
	"uq\x00fur\x00fuv\x00fuy\x00fvr\x00fyrygalegaa\x00gaf\x00gag\x00gah\x00ga" +
	"j\x00gam\x00gan\x00gaw\x00gay\x00gbf\x00gbm\x00gby\x00gbz\x00gcr\x00gdla" +
	"gde\x00gdn\x00gdr\x00geb\x00gej\x00gel\x00gez\x00gfk\x00ggn\x00ghs\x00gi" +
	"l\x00gim\x00gjk\x00gjn\x00gju\x00gkn\x00gkp\x00gllgglk\x00gmm\x00gmv\x00" +
	"gnrngnd\x00gng\x00god\x00gof\x00goi\x00gom\x00gon\x00gor\x00gos\x00got" +
	"\x00grc\x00grt\x00grw\x00gsw\x00guujgub\x00guc\x00gud\x00gur\x00guw\x00g" +
	"ux\x00guz\x00gvlvgvf\x00gvr\x00gvs\x00gwc\x00gwi\x00gwt\x00gyi\x00haauha" +
	"g\x00hak\x00ham\x00haw\x00haz\x00hbb\x00hdy\x00heebhhy\x00hiinhia\x00hif" +
	"\x00hig\x00hih\x00hil\x00hla\x00hlu\x00hmd\x00hmt\x00hnd\x00hne\x00hnj" +
	"\x00hnn\x00hno\x00homohoc\x00hoj\x00hot\x00hrrvhsb\x00hsn\x00htathuunhui" +
	"\x00hyyehzerianaian\x00iar\x00iba\x00ibb\x00iby\x00ica\x00ich\x00idndidd" +
	"\x00idi\x00idu\x00ieleigboigb\x00ige\x00iiiiijj\x00ikpkikk\x00ikt\x00ikw" +
	"\x00ikx\x00ilo\x00imo\x00inndinh\x00iodoiou\x00iri\x00isslittaiukuiw\x00" +
	"\x03iwm\x00iws\x00izh\x00izi\x00japnjab\x00jam\x00jbo\x00jbu\x00jen\x00j" +
	"gk\x00jgo\x00ji\x00\x06jib\x00jmc\x00jml\x00jra\x00jut\x00jvavjwavkaatka" +
	"a\x00kab\x00kac\x00kad\x00kai\x00kaj\x00kam\x00kao\x00kbd\x00kbm\x00kbp" +
	"\x00kbq\x00kbx\x00kby\x00kcg\x00kck\x00kcl\x00kct\x00kde\x00kdh\x00kdl" +
	"\x00kdt\x00kea\x00ken\x00kez\x00kfo\x00kfr\x00kfy\x00kgonkge\x00kgf\x00k" +
	"gp\x00kha\x00khb\x00khn\x00khq\x00khs\x00kht\x00khw\x00khz\x00kiikkij" +
	"\x00kiu\x00kiw\x00kjuakjd\x00kjg\x00kjs\x00kjy\x00kkazkkc\x00kkj\x00klal" +
	"kln\x00klq\x00klt\x00klx\x00kmhmkmb\x00kmh\x00kmo\x00kms\x00kmu\x00kmw" +
	"\x00knanknp\x00koorkoi\x00kok\x00kol\x00kos\x00koz\x00kpe\x00kpf\x00kpo" +
	"\x00kpr\x00kpx\x00kqb\x00kqf\x00kqs\x00kqy\x00kraukrc\x00kri\x00krj\x00k" +
	"rl\x00krs\x00kru\x00ksasksb\x00ksd\x00ksf\x00ksh\x00ksj\x00ksr\x00ktb" +
	"\x00ktm\x00kto\x00kuurkub\x00kud\x00kue\x00kuj\x00kum\x00kun\x00kup\x00k" +
	"us\x00kvomkvg\x00kvr\x00kvx\x00kw\x00\x01kwj\x00kwo\x00kxa\x00kxc\x00kxm" +
	"\x00kxp\x00kxw\x00kxz\x00kyirkye\x00kyx\x00kzr\x00laatlab\x00lad\x00lag" +
	"\x00lah\x00laj\x00las\x00lbtzlbe\x00lbu\x00lbw\x00lcm\x00lcp\x00ldb\x00l" +
	"ed\x00lee\x00lem\x00lep\x00leq\x00leu\x00lez\x00lguglgg\x00liimlia\x00li" +
	"d\x00lif\x00lig\x00lih\x00lij\x00lis\x00ljp\x00lki\x00lkt\x00lle\x00lln" +
	"\x00lmn\x00lmo\x00lmp\x00lninlns\x00lnu\x00loaoloj\x00lok\x00lol\x00lor" +
	"\x00los\x00loz\x00lrc\x00ltitltg\x00luublua\x00luo\x00luy\x00luz\x00lvav" +
	"lwl\x00lzh\x00lzz\x00mad\x00maf\x00mag\x00mai\x00mak\x00man\x00mas\x00ma" +
	"w\x00maz\x00mbh\x00mbo\x00mbq\x00mbu\x00mbw\x00mci\x00mcp\x00mcq\x00mcr" +
	"\x00mcu\x00mda\x00mde\x00mdf\x00mdh\x00mdj\x00mdr\x00mdx\x00med\x00mee" +
	"\x00mek\x00men\x00mer\x00met\x00meu\x00mfa\x00mfe\x00mfn\x00mfo\x00mfq" +
	"\x00mglgmgh\x00mgl\x00mgo\x00mgp\x00mgy\x00mhahmhi\x00mhl\x00mirimif\x00" +
	"min\x00mis\x00miw\x00mkkdmki\x00mkl\x00mkp\x00mkw\x00mlalmle\x00mlp\x00m" +
	"ls\x00mmo\x00mmu\x00mmx\x00mnonmna\x00mnf\x00mni\x00mnw\x00moolmoa\x00mo" +
	"e\x00moh\x00mos\x00mox\x00mpp\x00mps\x00mpt\x00mpx\x00mql\x00mrarmrd\x00" +
	"mrj\x00mro\x00mssamtltmtc\x00mtf\x00mti\x00mtr\x00mua\x00mul\x00mur\x00m" +
	"us\x00mva\x00mvn\x00mvy\x00mwk\x00mwr\x00mwv\x00mxc\x00mxm\x00myyamyk" +
	"\x00mym\x00myv\x00myw\x00myx\x00myz\x00mzk\x00mzm\x00mzn\x00mzp\x00mzw" +
	"\x00mzz\x00naaunac\x00naf\x00nah\x00nak\x00nan\x00nap\x00naq\x00nas\x00n" +
	"bobnca\x00nce\x00ncf\x00nch\x00nco\x00ncu\x00nddendc\x00nds\x00neepneb" +
	"\x00new\x00nex\x00nfr\x00ngdonga\x00ngb\x00ngl\x00nhb\x00nhe\x00nhw\x00n" +
	"if\x00nii\x00nij\x00nin\x00niu\x00niy\x00niz\x00njo\x00nkg\x00nko\x00nll" +
	"dnmg\x00nmz\x00nnnonnf\x00nnh\x00nnk\x00nnm\x00noornod\x00noe\x00non\x00" +
	"nop\x00nou\x00nqo\x00nrblnrb\x00nsk\x00nsn\x00nso\x00nss\x00ntm\x00ntr" +
	"\x00nui\x00nup\x00nus\x00nuv\x00nux\x00nvavnwb\x00nxq\x00nxr\x00nyyanym" +
	"\x00nyn\x00nzi\x00occiogc\x00ojjiokr\x00okv\x00omrmong\x00onn\x00ons\x00" +
	"opm\x00orrioro\x00oru\x00osssosa\x00ota\x00otk\x00ozm\x00paanpag\x00pal" +
	"\x00pam\x00pap\x00pau\x00pbi\x00pcd\x00pcm\x00pdc\x00pdt\x00ped\x00peo" +
	"\x00pex\x00pfl\x00phl\x00phn\x00pilipil\x00pip\x00pka\x00pko\x00plolpla" +
	"\x00pms\x00png\x00pnn\x00pnt\x00pon\x00ppo\x00pra\x00prd\x00prg\x00psusp" +
	"ss\x00ptorptp\x00puu\x00pwa\x00quuequc\x00qug\x00rai\x00raj\x00rao\x00rc" +
	"f\x00rej\x00rel\x00res\x00rgn\x00rhg\x00ria\x00rif\x00rjs\x00rkt\x00rmoh" +
	"rmf\x00rmo\x00rmt\x00rmu\x00rnunrna\x00rng\x00roonrob\x00rof\x00roo\x00r" +
	"ro\x00rtm\x00ruusrue\x00rug\x00rw\x00\x04rwk\x00rwo\x00ryu\x00saansaf" +
	"\x00sah\x00saq\x00sas\x00sat\x00saz\x00sba\x00sbe\x00sbp\x00scrdsck\x00s" +
	"cl\x00scn\x00sco\x00scs\x00sdndsdc\x00sdh\x00semesef\x00seh\x00sei\x00se" +
	"s\x00sgagsga\x00sgs\x00sgw\x00sgz\x00sh\x00\x02shi\x00shk\x00shn\x00shu" +
	"\x00siinsid\x00sig\x00sil\x00sim\x00sjr\x00sklkskc\x00skr\x00sks\x00sllv" +
	"sld\x00sli\x00sll\x00sly\x00smmosma\x00smi\x00smj\x00smn\x00smp\x00smq" +
	"\x00sms\x00snnasnc\x00snk\x00snp\x00snx\x00sny\x00soomsok\x00soq\x00sou" +
	"\x00soy\x00spd\x00spl\x00sps\x00sqqisrrpsrb\x00srn\x00srr\x00srx\x00sssw" +
	"ssd\x00ssg\x00ssy\x00stotstk\x00stq\x00suunsua\x00sue\x00suk\x00sur\x00s" +
	"us\x00svweswwaswb\x00swc\x00swg\x00swp\x00swv\x00sxn\x00sxw\x00syl\x00sy" +
	"r\x00szl\x00taamtaj\x00tal\x00tan\x00taq\x00tbc\x00tbd\x00tbf\x00tbg\x00" +
	"tbo\x00tbw\x00tbz\x00tci\x00tcy\x00tdd\x00tdg\x00tdh\x00teelted\x00tem" +
	"\x00teo\x00tet\x00tfi\x00tggktgc\x00tgo\x00tgu\x00thhathl\x00thq\x00thr" +
	"\x00tiirtif\x00tig\x00tik\x00tim\x00tio\x00tiv\x00tkuktkl\x00tkr\x00tkt" +
	"\x00tlgltlf\x00tlx\x00tly\x00tmh\x00tmy\x00tnsntnh\x00toontof\x00tog\x00" +
	"toq\x00tpi\x00tpm\x00tpz\x00tqo\x00trurtru\x00trv\x00trw\x00tssotsd\x00t" +
	"sf\x00tsg\x00tsj\x00tsw\x00ttatttd\x00tte\x00ttj\x00ttr\x00tts\x00ttt" +
	"\x00tuh\x00tul\x00tum\x00tuq\x00tvd\x00tvl\x00tvu\x00twwitwh\x00twq\x00t" +
	"xg\x00tyahtya\x00tyv\x00tzm\x00ubu\x00udm\x00ugiguga\x00ukkruli\x00umb" +
	"\x00und\x00unr\x00unx\x00urrduri\x00urt\x00urw\x00usa\x00utr\x00uvh\x00u" +
	"vl\x00uzzbvag\x00vai\x00van\x00veenvec\x00vep\x00viievic\x00viv\x00vls" +
	"\x00vmf\x00vmw\x00voolvot\x00vro\x00vun\x00vut\x00walnwae\x00waj\x00wal" +
	"\x00wan\x00war\x00wbp\x00wbq\x00wbr\x00wci\x00wer\x00wgi\x00whg\x00wib" +
	"\x00wiu\x00wiv\x00wja\x00wji\x00wls\x00wmo\x00wnc\x00wni\x00wnu\x00woolw" +
	"ob\x00wos\x00wrs\x00wsk\x00wtm\x00wuu\x00wuv\x00wwa\x00xav\x00xbi\x00xcr" +
	"\x00xes\x00xhhoxla\x00xlc\x00xld\x00xmf\x00xmn\x00xmr\x00xna\x00xnr\x00x" +
	"og\x00xon\x00xpr\x00xrb\x00xsa\x00xsi\x00xsm\x00xsr\x00xwe\x00yam\x00yao" +
	"\x00yap\x00yas\x00yat\x00yav\x00yay\x00yaz\x00yba\x00ybb\x00yby\x00yer" +
	"\x00ygr\x00ygw\x00yiidyko\x00yle\x00ylg\x00yll\x00yml\x00yooryon\x00yrb" +
	"\x00yre\x00yrl\x00yss\x00yua\x00yue\x00yuj\x00yut\x00yuw\x00zahazag\x00z" +
	"bl\x00zdj\x00zea\x00zgh\x00zhhozia\x00zlm\x00zmi\x00zne\x00zuulzxx\x00zz" +
	"a\x00\xff\xff\xff\xff"

const langNoIndexOffset = 1319

// langNoIndex is a bit vector of all 3-letter language codes that are not used as an index
// in lookup tables. The language ids for these language codes are derived directly
// from the letters and are not consecutive.
// Size: 2197 bytes, 2197 elements
var langNoIndex = [2197]uint8{
	// Entry 0 - 3F
	0xff, 0xf8, 0xed, 0xfe, 0xeb, 0xd7, 0x3b, 0xd2,
	0xfb, 0xbf, 0x7a, 0xfa, 0x37, 0x1d, 0x3c, 0x57,
	0x6e, 0x97, 0x73, 0x38, 0xfb, 0xea, 0xbf, 0x70,
	0xad, 0x03, 0xff, 0xff, 0xcf, 0x05, 0x84, 0x62,
	0xe9, 0xbf, 0xfd, 0xbf, 0xbf, 0xf7, 0xfd, 0x77,
	0x0f, 0xff, 0xef, 0x6f, 0xff, 0xfb, 0xdf, 0xe2,
	0xc9, 0xf8, 0x7f, 0x7e, 0x4d, 0xb8, 0x0a, 0x6a,
	0x7c, 0xea, 0xe3, 0xfa, 0x7a, 0xbf, 0x67, 0xff,
	// Entry 40 - 7F
	0xff, 0xff, 0xff, 0xdf, 0x2a, 0x54, 0x91, 0xc0,
	0x5d, 0xe3, 0x97, 0x14, 0x07, 0x20, 0xdd, 0xed,
	0x9f, 0x3f, 0xc9, 0x21, 0xf8, 0x3f, 0x94, 0x35,
	0x7c, 0x5f, 0xff, 0x5f, 0x8e, 0x6e, 0xdf, 0xff,
	0xff, 0xff, 0x55, 0x7c, 0xd3, 0xfd, 0xbf, 0xb5,
	0x7b, 0xdf, 0x7f, 0xf7, 0xca, 0xfe, 0xdb, 0xa3,
	0xa8, 0xff, 0x1f, 0x67, 0x7f, 0xeb, 0xef, 0xce,
	0xff, 0xff, 0x9f, 0xff, 0xb7, 0xef, 0xfe, 0xcf,
	// Entry 80 - BF
	0xdb, 0xff, 0xf3, 0xcd, 0xfb, 0x2f, 0xff, 0xff,
	0xbb, 0xee, 0xf7, 0xbd, 0xdb, 0xff, 0x5f, 0xf7,
	0xfd, 0xf2, 0xfd, 0xff, 0x5e, 0x2f, 0x3b, 0xba,
	0x7e, 0xff, 0xff, 0xfe, 0xf7, 0xff, 0xdd, 0xff,
	0xfd, 0xdf, 0xfb, 0xfe, 0x9d, 0xb4, 0xd3, 0xff,
	0xef, 0xff, 0xdf, 0xf7, 0x7f, 0xb7, 0xfd, 0xd5,
	0xa5, 0x77, 0x40, 0xff, 0x9c, 0xc1, 0x41, 0x2c,
	0x08, 0x20, 0x41, 0x00, 0x50, 0x40, 0x00, 0x80,
	// Entry C0 - FF
	0xfb, 0x4a, 0xf2, 0x9f, 0xb4, 0x42, 0x41, 0x96,
	0x1b, 0x14, 0x08, 0xf2, 0x2b, 0xe7, 0x17, 0x56,
	0x45, 0x7d, 0x0e, 0x1c, 0x37, 0x71, 0xf3, 0xef,
	0x97, 0xff, 0x5d, 0x38, 0x64, 0x08, 0x00, 0x10,
	0xbc, 0x87, 0xaf, 0xdf, 0xff, 0xf7, 0x73, 0x35,
	0x3e, 0x87, 0xc7, 0xdf, 0xff, 0x00, 0x81, 0x00,
	0xb0, 0x05, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x40, 0x00, 0x40, 0x92, 0x21, 0x50, 0xb1, 0x5d,
	// Entry 100 - 13F
	0xfd, 0xdc, 0xbe, 0x5e, 0x00, 0x00, 0x02, 0x64,
	0x0d, 0x19, 0x41, 0xdf, 0x79, 0x22, 0x00, 0x00,
	0x00, 0x5e, 0x64, 0xdc, 0x24, 0xe5, 0xd9, 0xe3,
	0xfe, 0xff, 0xfd, 0xcb, 0x9f, 0x14, 0x01, 0x0c,
	0x86, 0x00, 0xd1, 0x00, 0xf0, 0xc5, 0x67, 0x5f,
	0x56, 0x89, 0x5e, 0xb5, 0x6c, 0xaf, 0x03, 0x00,
	0x02, 0x00, 0x00, 0x00, 0xc0, 0x37, 0xda, 0x56,
	0x90, 0x69, 0x01, 0x2c, 0x96, 0x69, 0x20, 0xfb,
	// Entry 140 - 17F
	0xff, 0x3f, 0x00, 0x00, 0x00, 0x01, 0x08, 0x16,
	0x01, 0x00, 0x00, 0xb0, 0x14, 0x03, 0x50, 0x06,
	0x0a, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11, 0x09,
	0x00, 0x00, 0x60, 0x10, 0x00, 0x00, 0x00, 0x10,
	0x00, 0x00, 0x44, 0x00, 0x00, 0x10, 0x00, 0x04,
	0x08, 0x00, 0x00, 0x04, 0x00, 0x80, 0x28, 0x04,
	0x00, 0x00, 0x50, 0xd5, 0x2d, 0x00, 0x64, 0x35,
	0x24, 0x52, 0xf4, 0xd4, 0xbd, 0x62, 0xc9, 0x03,
	// Entry 180 - 1BF
	0x00, 0x80, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x13, 0x39, 0x01, 0xdd, 0x57, 0x98,
	0x21, 0x18, 0x81, 0x00, 0x00, 0x01, 0x40, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x40, 0x00, 0x44, 0x00, 0x00, 0x80, 0xea,
	0xa9, 0x39, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	// Entry 1C0 - 1FF
	0x00, 0x01, 0x28, 0x05, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x20, 0x04, 0xa6, 0x00, 0x04, 0x00, 0x00,
	0x81, 0x50, 0x00, 0x00, 0x00, 0x11, 0x84, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x55,
	0x02, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x40,
	0x30, 0x83, 0x01, 0x00, 0x00, 0x00, 0x11, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1e, 0xcd, 0xbf, 0x7e, 0xbf,
	// Entry 200 - 23F
	0xdf, 0xc3, 0x83, 0x82, 0xc0, 0xfb, 0x57, 0x27,
	0xcd, 0x55, 0xe7, 0x01, 0x00, 0x20, 0xb2, 0xc5,
	0xa4, 0x45, 0x25, 0x9b, 0x02, 0xcf, 0xe0, 0xdf,
	0x03, 0x44, 0x08, 0x10, 0x01, 0x04, 0x01, 0xe3,
	0x92, 0x54, 0xdb, 0x28, 0xd1, 0x5f, 0xf6, 0x6d,
	0x79, 0xed, 0x1c, 0x7d, 0x04, 0x08, 0x00, 0x01,
	0x21, 0x12, 0x6c, 0x5f, 0xdd, 0x0e, 0x85, 0x4f,
	0x40, 0x40, 0x00, 0x04, 0xf1, 0xfd, 0x3d, 0x54,
	// Entry 240 - 27F
	0xe8, 0x03, 0xb4, 0x27, 0x23, 0x0d, 0x00, 0x00,
	0x20, 0x7b, 0x38, 0x02, 0x05, 0x84, 0x00, 0xf0,
	0xbb, 0x7e, 0x5a, 0x00, 0x18, 0x04, 0x81, 0x00,
	0x00, 0x00, 0x80, 0x10, 0x90, 0x1c, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x40, 0x00, 0x04,
	0x08, 0xa0, 0x70, 0xa5, 0x0c, 0x40, 0x00, 0x00,
	0x11, 0x04, 0x04, 0x68, 0x00, 0x20, 0x70, 0xff,
	0x7b, 0x7f, 0x60, 0x00, 0x05, 0x9b, 0xdd, 0x66,
	// Entry 280 - 2BF
	0x03, 0x00, 0x11, 0x00, 0x00, 0x00, 0x40, 0x05,
	0xb5, 0xb6, 0x80, 0x08, 0x04, 0x00, 0x04, 0x51,
	0xe2, 0xef, 0xfd, 0x3f, 0x05, 0x09, 0x08, 0x05,
	0x40, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x00, 0x81, 0x00, 0x60,
	0xe5, 0x48, 0x00, 0x81, 0x20, 0xc0, 0x05, 0x80,
	0x03, 0x00, 0x00, 0x00, 0xcc, 0x50, 0x40, 0x04,
	0x84, 0x47, 0x84, 0x40, 0x20, 0x10, 0x00, 0x20,
	// Entry 2C0 - 2FF
	0x02, 0x50, 0x80, 0x11, 0x00, 0x91, 0x6c, 0xe2,
	0x50, 0x27, 0x1d, 0x11, 0x29, 0x06, 0x59, 0xe9,
	0x33, 0x08, 0x00, 0x20, 0x04, 0x40, 0x10, 0x00,
	0x00, 0x00, 0x50, 0x44, 0x92, 0x49, 0xd6, 0x5d,
	0xa7, 0x81, 0x47, 0x97, 0xfb, 0x00, 0x10, 0x00,
	0x08, 0x00, 0x80, 0x00, 0x40, 0x04, 0x00, 0x01,
	0x02, 0x00, 0x01, 0x40, 0x80, 0x00, 0x00, 0x08,
	0xd8, 0xeb, 0xf6, 0x39, 0xc4, 0x89, 0x12, 0x00,
	// Entry 300 - 33F
	0x00, 0x0c, 0x04, 0x01, 0x20, 0x20, 0xdd, 0xa0,
	0x01, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
	0x04, 0x10, 0xd0, 0x9d, 0x95, 0x13, 0x04, 0x80,
	0x00, 0x01, 0xd0, 0x12, 0x40, 0x00, 0x10, 0xb0,
	0x10, 0x62, 0x4c, 0xd2, 0x02, 0x01, 0x4a, 0x00,
	0x46, 0x04, 0x00, 0x08, 0x02, 0x00, 0x20, 0x80,
	0x00, 0x80, 0x06, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x00, 0xf0, 0xd8, 0x6f, 0x15, 0x02, 0x08, 0x00,
	// Entry 340 - 37F
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01,
	0x00, 0x10, 0x00, 0x00, 0x00, 0xf0, 0x84, 0xe3,
	0xdd, 0xbf, 0xf9, 0xf9, 0x3b, 0x7f, 0x7f, 0xdb,
	0xfd, 0xfc, 0xfe, 0xdf, 0xff, 0xfd, 0xff, 0xf6,
	0xfb, 0xfc, 0xf7, 0x1f, 0xff, 0xb3, 0x6c, 0xff,
	0xd9, 0xad, 0xdf, 0xfe, 0xef, 0xba, 0xdf, 0xff,
	0xff, 0xff, 0xb7, 0xdd, 0x7d, 0xbf, 0xab, 0xff,
	0xfd, 0xfd, 0xdf, 0x2f, 0x9c, 0xdf, 0xf3, 0x6f,
	// Entry 380 - 3BF
	0xdf, 0xdd, 0xff, 0xfb, 0xee, 0xd2, 0xab, 0x5f,
	0xd5, 0xdf, 0x7f, 0xff, 0xeb, 0xff, 0xe4, 0x4d,
	0xf9, 0xff, 0xfe, 0xf7, 0xfd, 0xdf, 0xfb, 0xbf,
	0xee, 0xdb, 0x6f, 0xef, 0xff, 0x7f, 0xff, 0xff,
	0xf7, 0x5f, 0xd3, 0x3b, 0xfd, 0xd9, 0xdf, 0xeb,
	0xbc, 0x08, 0x05, 0x24, 0xff, 0x07, 0x70, 0xfe,
	0xe6, 0x5e, 0x00, 0x08, 0x00, 0x83, 0x3d, 0x1b,
	0x06, 0xe6, 0x72, 0x60, 0xd1, 0x3c, 0x7f, 0x44,
	// Entry 3C0 - 3FF
	0x02, 0x30, 0x9f, 0x7a, 0x16, 0xbd, 0x7f, 0x57,
	0xf2, 0xff, 0x31, 0xff, 0xf2, 0x1e, 0x90, 0xf7,
	0xf1, 0xf9, 0x45, 0x80, 0x01, 0x02, 0x00, 0x00,
	0x40, 0x54, 0x9f, 0x8a, 0xd9, 0xd9, 0x0e, 0x11,
	0x84, 0x51, 0xc0, 0xf3, 0xfb, 0x47, 0x00, 0x01,
	0x05, 0xd1, 0x50, 0x58, 0x00, 0x00, 0x00, 0x10,
	0x04, 0x02, 0x00, 0x00, 0x0a, 0x00, 0x17, 0xd2,
	0xb9, 0xfd, 0xfc, 0xba, 0xfe, 0xef, 0xc7, 0xbe,
	// Entry 400 - 43F
	0x53, 0x6f, 0xdf, 0xe7, 0xdb, 0x65, 0xbb, 0x7f,
	0xfa, 0xff, 0x77, 0xf3, 0xef, 0xbf, 0xfd, 0xf7,
	0xdf, 0xdf, 0x9b, 0x7f, 0xff, 0xff, 0x7f, 0x6f,
	0xf7, 0xfb, 0xeb, 0xdf, 0xbc, 0xff, 0xbf, 0x6b,
	0x7b, 0xfb, 0xff, 0xce, 0x76, 0xbd, 0xf7, 0xf7,
	0xdf, 0xdc, 0xf7, 0xf7, 0xff, 0xdf, 0xf3, 0xfe,
	0xef, 0xff, 0xff, 0xff, 0xb6, 0x7f, 0x7f, 0xde,
	0xf7, 0xb9, 0xeb, 0x77, 0xff, 0xfb, 0xbf, 0xdf,
	// Entry 440 - 47F
	0xfd, 0xfe, 0xfb, 0xff, 0xfe, 0xeb, 0x1f, 0x7d,
	0x2f, 0xfd, 0xb6, 0xb5, 0xa5, 0xfc, 0xff, 0xfd,
	0x7f, 0x4e, 0xbf, 0x8e, 0xae, 0xff, 0xee, 0xdf,
	0x7f, 0xf7, 0x73, 0x02, 0x02, 0x04, 0xfc, 0xf7,
	0xff, 0xb7, 0xd7, 0xef, 0xfe, 0xcd, 0xf5, 0xce,
	0xe2, 0x8e, 0xe7, 0xbf, 0xb7, 0xff, 0x56, 0xbd,
	0xcd, 0xff, 0xfb, 0xff, 0xdf, 0xd7, 0xea, 0xff,
	0xe5, 0x5f, 0x6d, 0x0f, 0xa7, 0x51, 0x04, 0x44,
	// Entry 480 - 4BF
	0x13, 0x50, 0x5d, 0xaf, 0xa6, 0xfd, 0x99, 0xfb,
	0x63, 0x1d, 0x53, 0xff, 0xef, 0xb7, 0x35, 0x20,
	0x14, 0x00, 0x55, 0x51, 0x82, 0x65, 0xf5, 0x41,
	0xe2, 0xff, 0xfc, 0xdf, 0x00, 0x05, 0xc5, 0x05,
	0x00, 0x22, 0x00, 0x74, 0x69, 0x10, 0x08, 0x04,
	0x41, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x51, 0x20, 0x05, 0x04, 0x01, 0x00, 0x00,
	0x06, 0x01, 0x20, 0x00, 0x18, 0x01, 0x92, 0xb1,
	// Entry 4C0 - 4FF
	0xfd, 0x47, 0x49, 0x06, 0x95, 0x06, 0x57, 0xed,
	0xfb, 0x4c, 0x1c, 0x6b, 0x83, 0x04, 0x62, 0x40,
	0x00, 0x11, 0x42, 0x00, 0x00, 0x00, 0x54, 0x83,
	0xb8, 0x4f, 0x10, 0x8c, 0x89, 0x46, 0xde, 0xf7,
	0x13, 0x31, 0x00, 0x20, 0x00, 0x00, 0x00, 0x90,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x10, 0x00,
	0x01, 0x00, 0x00, 0xf0, 0x5b, 0xf4, 0xbe, 0x3d,
	0xba, 0xcf, 0xf7, 0xaf, 0x42, 0x04, 0x84, 0x41,
	// Entry 500 - 53F
	0x30, 0xff, 0x79, 0x72, 0x04, 0x00, 0x00, 0x49,
	0x2d, 0x14, 0x27, 0x57, 0xed, 0xf1, 0x3f, 0xe7,
	0x3f, 0x00, 0x00, 0x02, 0xc6, 0xa0, 0x1e, 0xf8,
	0xbb, 0xff, 0xfd, 0xfb, 0xb7, 0xfd, 0xe5, 0xf7,
	0xfd, 0xfc, 0xd5, 0xed, 0x47, 0xf4, 0x7e, 0x10,
	0x01, 0x01, 0x84, 0x6d, 0xff, 0xf7, 0xdd, 0xf9,
	0x5b, 0x05, 0x86, 0xed, 0xf5, 0x77, 0xbd, 0x3c,
	0x00, 0x00, 0x00, 0x42, 0x71, 0x42, 0x00, 0x40,
	// Entry 540 - 57F
	0x00, 0x00, 0x01, 0x43, 0x19, 0x00, 0x08, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	// Entry 580 - 5BF
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xab, 0xbd, 0xe7, 0x57, 0xee, 0x13, 0x5d,
	0x09, 0xc1, 0x40, 0x21, 0xfa, 0x17, 0x01, 0x80,
	0x00, 0x00, 0x00, 0x00, 0xf0, 0xce, 0xfb, 0xbf,
	0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
	0x00, 0x30, 0x15, 0xa3, 0x10, 0x00, 0x00, 0x00,
	0x11, 0x04, 0x16, 0x00, 0x00, 0x02, 0x00, 0x81,
	0xa3, 0x01, 0x50, 0x00, 0x00, 0x83, 0x11, 0x40,
	// Entry 5C0 - 5FF
	0x00, 0x00, 0x00, 0xf0, 0xdd, 0x7b, 0x3e, 0x02,
	0xaa, 0x10, 0x5d, 0x98, 0x52, 0x00, 0x80, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x02, 0x02,
	0x19, 0x00, 0x10, 0x02, 0x10, 0x61, 0x5a, 0x9d,
	0x31, 0x00, 0x00, 0x00, 0x01, 0x10, 0x02, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x42, 0x00, 0x20, 0x00,
	0x00, 0x1f, 0xdf, 0xf2, 0xb9, 0xff, 0xfd, 0x3f,
	0x1f, 0x18, 0xcf, 0x9c, 0xbf, 0xaf, 0x5f, 0xfe,
	// Entry 600 - 63F
	0x7b, 0x4b, 0x40, 0x10, 0xe1, 0xfd, 0xaf, 0xd9,
	0xb7, 0xf6, 0xfb, 0xb3, 0xc7, 0xff, 0x6f, 0xf1,
	0x73, 0xb1, 0x7f, 0x9f, 0x7f, 0xbd, 0xfc, 0xb7,
	0xee, 0x1c, 0xfa, 0xcb, 0xef, 0xdd, 0xf9, 0xbd,
	0x6e, 0xae, 0x55, 0xfd, 0x6e, 0x81, 0x76, 0x1f,
	0xd4, 0x77, 0xf5, 0x7d, 0xfb, 0xff, 0xeb, 0xfe,
	0xbe, 0x5f, 0x46, 0x1b, 0xe9, 0x5f, 0x50, 0x18,
	0x02, 0xfa, 0xf7, 0x9d, 0x15, 0x97, 0x05, 0x0f,
	// Entry 640 - 67F
	0x75, 0xc4, 0x7d, 0x81, 0x82, 0xf1, 0x57, 0x6c,
	0xff, 0xe4, 0xef, 0x6f, 0xff, 0xfc, 0xdd, 0xde,
	0xfc, 0xfd, 0x76, 0x5f, 0x7a, 0x1f, 0x00, 0x98,
	0x02, 0xfb, 0xa3, 0xef, 0xf3, 0xd6, 0xf2, 0xff,
	0xb9, 0xda, 0x7d, 0x50, 0x1e, 0x15, 0x7b, 0xb4,
	0xf5, 0x3e, 0xff, 0xff, 0xf1, 0xf7, 0xff, 0xe7,
	0x5f, 0xff, 0xff, 0x9e, 0xdb, 0xf6, 0xd7, 0xb9,
	0xef, 0x27, 0x80, 0xbb, 0xc5, 0xff, 0xff, 0xe3,
	// Entry 680 - 6BF
	0x97, 0x9d, 0xbf, 0x9f, 0xf7, 0xc7, 0xfd, 0x37,
	0xce, 0x7f, 0x04, 0x1d, 0x53, 0x7f, 0xf8, 0xda,
	0x5d, 0xce, 0x7d, 0x06, 0xb9, 0xea, 0x69, 0xa0,
	0x1a, 0x20, 0x00, 0x30, 0x02, 0x04, 0x24, 0x08,
	0x04, 0x00, 0x00, 0x40, 0xd4, 0x02, 0x04, 0x00,
	0x00, 0x04, 0x00, 0x04, 0x00, 0x20, 0x01, 0x06,
	0x50, 0x00, 0x08, 0x00, 0x00, 0x00, 0x24, 0x00,
	0x04, 0x00, 0x10, 0x8c, 0x58, 0xd5, 0x0d, 0x0f,
	// Entry 6C0 - 6FF
	0x14, 0x4d, 0xf1, 0x16, 0x44, 0xd1, 0x42, 0x08,
	0x40, 0x00, 0x00, 0x40, 0x00, 0x08, 0x00, 0x00,
	0x00, 0xdc, 0xfb, 0xcb, 0x0e, 0x58, 0x08, 0x41,
	0x04, 0x20, 0x04, 0x00, 0x30, 0x12, 0x40, 0x00,
	0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x80, 0x10, 0x10, 0xab,
	0x6d, 0x93, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x80, 0x80, 0x25, 0x00, 0x00,
	// Entry 700 - 73F
	0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
	0x80, 0x86, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x01,
	0xdf, 0x18, 0x00, 0x00, 0x02, 0xf0, 0xfd, 0x79,
	0x3b, 0x00, 0x25, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
	0x03, 0x00, 0x09, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 740 - 77F
	0x00, 0x00, 0x00, 0xef, 0xd5, 0xfd, 0xcf, 0x7e,
	0xa0, 0x11, 0x00, 0x00, 0x00, 0x92, 0x01, 0x44,
	0xcd, 0xf9, 0x5c, 0x00, 0x01, 0x00, 0x30, 0x04,
	0x04, 0x55, 0x00, 0x01, 0x04, 0xf4, 0x3f, 0x4a,
	0x01, 0x00, 0x00, 0xb0, 0x80, 0x00, 0x55, 0x55,
	0x97, 0x7c, 0x9f, 0x31, 0xcc, 0x68, 0xd1, 0x03,
	0xd5, 0x57, 0x27, 0x14, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x2c, 0xf7, 0xcb, 0x1f, 0x14, 0x60,
	// Entry 780 - 7BF
	0x03, 0x68, 0x01, 0x10, 0x8b, 0x38, 0x8a, 0x01,
	0x00, 0x00, 0x20, 0x00, 0x24, 0x44, 0x00, 0x00,
	0x10, 0x03, 0x11, 0x02, 0x01, 0x00, 0x00, 0xf0,
	0xf5, 0xff, 0xd5, 0x97, 0xbc, 0x70, 0xd6, 0x78,
	0x78, 0x15, 0x50, 0x00, 0xa4, 0x84, 0xa9, 0x41,
	0x00, 0x00, 0x00, 0x6b, 0x39, 0x52, 0x74, 0x00,
	0xe8, 0x30, 0x90, 0x6a, 0x92, 0x00, 0x00, 0x02,
	0xff, 0xef, 0xff, 0x4b, 0x85, 0x53, 0xf4, 0xed,
	// Entry 7C0 - 7FF
	0xdd, 0xbf, 0x72, 0x19, 0xc7, 0x0c, 0xd5, 0x42,
	0x54, 0xdd, 0x77, 0x14, 0x00, 0x80, 0x40, 0x56,
	0xcc, 0x16, 0x9e, 0xea, 0x35, 0x7d, 0xef, 0xff,
	0xbd, 0xa4, 0xaf, 0x01, 0x44, 0x18, 0x01, 0x4d,
	0x4e, 0x4a, 0x08, 0x50, 0x28, 0x30, 0xe0, 0x80,
	0x10, 0x20, 0x24, 0x00, 0xff, 0x2f, 0xd3, 0x60,
	0xfe, 0x01, 0x02, 0x88, 0x0a, 0x40, 0x16, 0x01,
	0x01, 0x15, 0x2b, 0x3c, 0x01, 0x00, 0x00, 0x10,
	// Entry 800 - 83F
	0x90, 0x49, 0x41, 0x02, 0x02, 0x01, 0xe1, 0xbf,
	0xbf, 0x03, 0x00, 0x00, 0x10, 0xd4, 0xa3, 0xd1,
	0x40, 0x9c, 0x44, 0xdf, 0xf5, 0x8f, 0x66, 0xb3,
	0x55, 0x20, 0xd4, 0xc1, 0xd8, 0x30, 0x3d, 0x80,
	0x00, 0x00, 0x00, 0x04, 0xd4, 0x11, 0xc5, 0x84,
	0x2e, 0x50, 0x00, 0x22, 0x50, 0x6e, 0xbd, 0x93,
	0x07, 0x00, 0x20, 0x10, 0x84, 0xb2, 0x45, 0x10,
	0x06, 0x44, 0x00, 0x00, 0x12, 0x02, 0x11, 0x00,
	// Entry 840 - 87F
	0xf0, 0xfb, 0xfd, 0x3f, 0x05, 0x00, 0x12, 0x81,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x02, 0x28,
	0x84, 0x00, 0x23, 0xc0, 0x23, 0x24, 0x00, 0x00,
	0x00, 0xcb, 0xe4, 0x3a, 0x42, 0x88, 0x14, 0xf1,
	0xef, 0xff, 0x7f, 0x12, 0x01, 0x01, 0x84, 0x50,
	0x07, 0xfc, 0xff, 0xff, 0x0f, 0x01, 0x00, 0x40,
	0x10, 0x38, 0x01, 0x01, 0x1c, 0x12, 0x40, 0xe1,
	// Entry 880 - 8BF
	0x76, 0x16, 0x08, 0x03, 0x10, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x24,
	0x0a, 0x00, 0x80, 0x00, 0x00,
}

// altLangISO3 holds an alphabetically sorted list of 3-letter language code alternatives
// to 2-letter language codes that cannot be derived using the method described above.
// Each 3-letter code is followed by its 1-byte langID.
const altLangISO3 tag.Index = "---\x00cor\x00hbs\x01heb\x02kin\x03spa\x04yid\x05\xff\xff\xff\xff"

// altLangIndex is used to convert indexes in altLangISO3 to langIDs.
// Size: 12 bytes, 6 elements
var altLangIndex = [6]uint16{
	0x0278, 0x03fd, 0x01f3, 0x03dc, 0x0139, 0x0200,
}

// langAliasMap maps langIDs to their suggested replacements.
// Size: 644 bytes, 161 elements
var langAliasMap = [161]fromTo{
	0:   {from: 0x81, to: 0x87},
	1:   {from: 0x181, to: 0x1a7},
	2:   {from: 0x1eb, to: 0x1da},
	3:   {from: 0x1f3, to: 0x1b5},
	4:   {from: 0x200, to: 0x508},
	5:   {from: 0x207, to: 0x206},
	6:   {from: 0x307, to: 0x3d3},
	7:   {from: 0x33e, to: 0x366},
	8:   {from: 0x3fd, to: 0x428},
	9:   {from: 0x470, to: 0x14e},
	10:  {from: 0x486, to: 0x447},
	11:  {from: 0x498, to: 0x20},
	12:  {from: 0x533, to: 0x539},
	13:  {from: 0x584, to: 0x129},
	14:  {from: 0x625, to: 0x1ea6},
	15:  {from: 0x646, to: 0x427},
	16:  {from: 0x657, to: 0x427},
	17:  {from: 0x6e2, to: 0x39},
	18:  {from: 0x6ed, to: 0x1d0},
	19:  {from: 0x733, to: 0x2196},
	20:  {from: 0x7a8, to: 0x55},
	21:  {from: 0x7ae, to: 0x2990},
	22:  {from: 0x7ba, to: 0x57},
	23:  {from: 0x7db, to: 0x140},
	24:  {from: 0x801, to: 0x59},
	25:  {from: 0x80a, to: 0x8c},
	26:  {from: 0x873, to: 0x805},
	27:  {from: 0x8b8, to: 0xed8},
	28:  {from: 0x9e4, to: 0x328},
	29:  {from: 0xa2b, to: 0x2bc},
	30:  {from: 0xa32, to: 0xbd},
	31:  {from: 0xab3, to: 0x3317},
	32:  {from: 0xb2d, to: 0x51f},
	33:  {from: 0xb6a, to: 0x264f},
	34:  {from: 0xb73, to: 0xbb8},
	35:  {from: 0xb90, to: 0x444},
	36:  {from: 0xbb1, to: 0x421e},
	37:  {from: 0xbb4, to: 0x51f},
	38:  {from: 0xbf3, to: 0x2d9c},
	39:  {from: 0xc23, to: 0x3176},
	40:  {from: 0xcae, to: 0xf0},
	41:  {from: 0xcfd, to: 0xf6},
	42:  {from: 0xdbd, to: 0x116},
	43:  {from: 0xdcc, to: 0x324},
	44:  {from: 0xded, to: 0xdf0},
	45:  {from: 0xdf3, to: 0x526},
	46:  {from: 0xed4, to: 0x204f},
	47:  {from: 0xee3, to: 0x2e8f},
	48:  {from: 0xf2e, to: 0x35e},
	49:  {from: 0x10c5, to: 0x13b},
	50:  {from: 0x10f9, to: 0x2c7},
	51:  {from: 0x1195, to: 0x1e4},
	52:  {from: 0x126e, to: 0x20},
	53:  {from: 0x1419, to: 0x159},
	54:  {from: 0x1465, to: 0x149},
	55:  {from: 0x1514, to: 0xd90},
	56:  {from: 0x1518, to: 0x387},
	57:  {from: 0x1527, to: 0x16ba},
	58:  {from: 0x1575, to: 0x208},
	59:  {from: 0x1578, to: 0x109},
	60:  {from: 0x1598, to: 0x3ca4},
	61:  {from: 0x165f, to: 0x195},
	62:  {from: 0x16bd, to: 0x131},
	63:  {from: 0x16f5, to: 0x29ed},
	64:  {from: 0x170d, to: 0x18e},
	65:  {from: 0x171c, to: 0xf34},
	66:  {from: 0x176f, to: 0x1519},
	67:  {from: 0x17fe, to: 0x17ab},
	68:  {from: 0x180b, to: 0x18e8},
	69:  {from: 0x187f, to: 0x42c},
	70:  {from: 0x196e, to: 0x1cf6},
	71:  {from: 0x1a69, to: 0x2ba5},
	72:  {from: 0x1a7f, to: 0x1f0},
	73:  {from: 0x1b4f, to: 0x1f2},
	74:  {from: 0x1b7b, to: 0x150a},
	75:  {from: 0x202d, to: 0x37a6},
	76:  {from: 0x2032, to: 0x20d2},
	77:  {from: 0x204f, to: 0x302},
	78:  {from: 0x20d8, to: 0x26b},
	79:  {from: 0x20e3, to: 0x25a},
	80:  {from: 0x20e7, to: 0x225},
	81:  {from: 0x20ee, to: 0x24d},
	82:  {from: 0x2104, to: 0x21e0},
	83:  {from: 0x212a, to: 0x274},
	84:  {from: 0x218e, to: 0x11d},
	85:  {from: 0x21c3, to: 0x1556},
	86:  {from: 0x21db, to: 0x4fa},
	87:  {from: 0x21e9, to: 0x495},
	88:  {from: 0x2222, to: 0x11d},
	89:  {from: 0x222c, to: 0x11d},
	90:  {from: 0x2257, to: 0x91f},
	91:  {from: 0x230b, to: 0x321b},
	92:  {from: 0x2377, to: 0x335a},
	93:  {from: 0x2467, to: 0x2be},
	94:  {from: 0x24d9, to: 0x2f6},
	95:  {from: 0x24e5, to: 0x2f1},
	96:  {from: 0x24ef, to: 0x316},
	97:  {from: 0x2545, to: 0xb50},
	98:  {from: 0x259e, to: 0xe0},
	99:  {from: 0x2633, to: 0x2c7},
	100: {from: 0x26be, to: 0x26a9},
	101: {from: 0x26ee, to: 0x3bf},
	102: {from: 0x271c, to: 0x3ca4},
	103: {from: 0x275a, to: 0x26a9},
	104: {from: 0x277e, to: 0x434d},
	105: {from: 0x28e4, to: 0x282c},
	106: {from: 0x2909, to: 0x348},
	107: {from: 0x297b, to: 0x2d9c},
	108: {from: 0x2b0f, to: 0x384},
	109: {from: 0x2bf1, to: 0x38c},
	110: {from: 0x2c34, to: 0x3ca4},
	111: {from: 0x2cf1, to: 0x3b5},
	112: {from: 0x2d08, to: 0x58c},
	113: {from: 0x2d3c, to: 0x143},
	114: {from: 0x2d3d, to: 0x143},
	115: {from: 0x2df4, to: 0x2e8},
	116: {from: 0x2dfd, to: 0x19c1},
	117: {from: 0x2e0f, to: 0x2d8a},
	118: {from: 0x2e16, to: 0x289},
	119: {from: 0x2e49, to: 0x7c},
	120: {from: 0x2e5a, to: 0x2277},
	121: {from: 0x2e95, to: 0x2e90},
	122: {from: 0x2ee4, to: 0x2ecc},
	123: {from: 0x3188, to: 0x3bb},
	124: {from: 0x335b, to: 0x3383},
	125: {from: 0x341f, to: 0x3d3},
	126: {from: 0x34e3, to: 0x18c5},
	127: {from: 0x35db, to: 0x408},
	128: {from: 0x364d, to: 0x23e},
	129: {from: 0x366b, to: 0x3ea},
	130: {from: 0x36f2, to: 0x43b},
	131: {from: 0x37b5, to: 0x11d},
	132: {from: 0x380b, to: 0x38e7},
	133: {from: 0x3820, to: 0x2c90},
	134: {from: 0x3824, to: 0xa7},
	135: {from: 0x3827, to: 0x321d},
	136: {from: 0x3861, to: 0x399b},
	137: {from: 0x3887, to: 0x3fb5},
	138: {from: 0x389a, to: 0x39cc},
	139: {from: 0x38a9, to: 0x1f99},
	140: {from: 0x38aa, to: 0x2e8f},
	141: {from: 0x3951, to: 0x474},
	142: {from: 0x3b43, to: 0xd86},
	143: {from: 0x3b6d, to: 0x132},
	144: {from: 0x3c8e, to: 0x4b2},
	145: {from: 0x3fb2, to: 0xfc},
	146: {from: 0x41fd, to: 0xa86},
	147: {from: 0x42b3, to: 0x568},
	148: {from: 0x42ee, to: 0x3f55},
	149: {from: 0x436d, to: 0x251},
	150: {from: 0x43c0, to: 0x36c0},
	151: {from: 0x43c2, to: 0x10b},
	152: {from: 0x44a4, to: 0x3317},
	153: {from: 0x44d8, to: 0x508},
	154: {from: 0x45bf, to: 0x23fe},
	155: {from: 0x45d2, to: 0x26d1},
	156: {from: 0x4605, to: 0x48a3},
	157: {from: 0x46a3, to: 0x4695},
	158: {from: 0x4733, to: 0x473a},
	159: {from: 0x490b, to: 0x316},
	160: {from: 0x499c, to: 0x519},
}

// Size: 161 bytes, 161 elements
var langAliasTypes = [161]langAliasType{
	// Entry 0 - 3F
	1, 0, 0, 0, 0, 0, 0, 1, 2, 2, 0, 1, 0, 0, 1, 2,
	1, 1, 2, 0, 1, 0, 1, 2, 1, 1, 0, 0, 2, 1, 1, 0,
	2, 0, 0, 1, 0, 1, 0, 0, 1, 2, 1, 1, 1, 1, 0, 0,
	2, 1, 1, 1, 1, 2, 1, 0, 1, 1, 2, 2, 0, 1, 2, 0,
	// Entry 40 - 7F
	1, 0, 1, 1, 1, 1, 0, 0, 2, 1, 0, 0, 0, 1, 1, 1,
	1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 2, 2,
	2, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1,
	0, 2, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 2, 0, 2,
	// Entry 80 - BF
	1, 1, 1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 1, 1, 0,
	1, 2, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1,
	1,
}

const (
	_Latn = 82
	_Hani = 50
	_Hans = 52
	_Hant = 53
	_Qaaa = 131
	_Qaai = 139
	_Qabx = 180
	_Zinh = 224
	_Zyyy = 229
	_Zzzz = 230
)

// script is an alphabetically sorted list of ISO 15924 codes. The index
// of the script in the string, divided by 4, is the internal scriptID.
const script tag.Index = "" + // Size: 928 bytes
	"----AdlmAfakAghbAhomArabAranArmiArmnAvstBaliBamuBassBatkBengBhksBlisBopo" +
	"BrahBraiBugiBuhdCakmCansCariChamCherCirtCoptCprtCyrlCyrsDevaDsrtDuplEgyd" +
	"EgyhEgypElbaEthiGeokGeorGlagGothGranGrekGujrGuruHanbHangHaniHanoHansHant" +
	"HatrHebrHiraHluwHmngHrktHungIndsItalJamoJavaJpanJurcKaliKanaKharKhmrKhoj" +
	"KitlKitsKndaKoreKpelKthiLanaLaooLatfLatgLatnLekeLepcLimbLinaLinbLisuLoma" +
	"LyciLydiMahjMandManiMarcMayaMendMercMeroMlymModiMongMoonMrooMteiMultMymr" +
	"NarbNbatNewaNkgbNkooNshuOgamOlckOrkhOryaOsgeOsmaPalmPaucPermPhagPhliPhlp" +
	"PhlvPhnxPiqdPlrdPrtiQaaaQaabQaacQaadQaaeQaafQaagQaahQaaiQaajQaakQaalQaam" +
	"QaanQaaoQaapQaaqQaarQaasQaatQaauQaavQaawQaaxQaayQaazQabaQabbQabcQabdQabe" +
	"QabfQabgQabhQabiQabjQabkQablQabmQabnQaboQabpQabqQabrQabsQabtQabuQabvQabw" +
	"QabxRjngRoroRunrSamrSaraSarbSaurSgnwShawShrdSiddSindSinhSoraSundSyloSyrc" +
	"SyreSyrjSyrnTagbTakrTaleTaluTamlTangTavtTeluTengTfngTglgThaaThaiTibtTirh" +
	"UgarVaiiVispWaraWoleXpeoXsuxYiiiZinhZmthZsyeZsymZxxxZyyyZzzz\xff\xff\xff" +
	"\xff"

// suppressScript is an index from langID to the dominant script for that language,
// if it exists.  If a script is given, it should be suppressed from the language tag.
// Size: 1319 bytes, 1319 elements
var suppressScript = [1319]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 40 - 7F
	0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00,
	// Entry 80 - BF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry C0 - FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00,
	// Entry 100 - 13F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00, 0x00,
	0x00, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x2d, 0x00, 0x00, 0x52, 0x00, 0x00, 0x52,
	0x00, 0x52, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
	// Entry 140 - 17F
	0x52, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 180 - 1BF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x52, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x2e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 1C0 - 1FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x52, 0x00, 0x52, 0x52, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x52, 0x00, 0x37, 0x00, 0x00, 0x00, 0x00,
	0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 200 - 23F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x00, 0x00, 0x52, 0x00, 0x00,
	// Entry 240 - 27F
	0x00, 0x00, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x4a, 0x00, 0x4b, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 280 - 2BF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x4f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	// Entry 2C0 - 2FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
	0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00,
	// Entry 300 - 33F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x52, 0x52,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	// Entry 340 - 37F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x52,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x52, 0x00, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	// Entry 380 - 3BF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52,
	0x00, 0x00, 0x00, 0x00, 0x75, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x52,
	0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
	// Entry 3C0 - 3FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x1e, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 400 - 43F
	0x00, 0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00,
	// Entry 440 - 47F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcd, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xd5, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x52, 0x00, 0x52, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00,
	// Entry 480 - 4BF
	0x52, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 4C0 - 4FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 500 - 53F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
}

const (
	_001 = 1
	_419 = 30
	_BR  = 64
	_CA  = 72
	_ES  = 109
	_GB  = 122
	_MD  = 187
	_PT  = 237
	_UK  = 305
	_US  = 308
	_ZZ  = 356
	_XA  = 322
	_XC  = 324
	_XK  = 332
)

// isoRegionOffset needs to be added to the index of regionISO to obtain the regionID
// for 2-letter ISO codes. (The first isoRegionOffset regionIDs are reserved for
// the UN.M49 codes used for groups.)
const isoRegionOffset = 31

// regionTypes defines the status of a region for various standards.
// Size: 357 bytes, 357 elements
var regionTypes = [357]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 40 - 7F
	0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x04, 0x00,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06,
	0x04, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x04,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06,
	0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 80 - BF
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x00, 0x04, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry C0 - FF
	0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06,
	0x06, 0x06, 0x06, 0x00, 0x06, 0x04, 0x06, 0x06,
	0x06, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06,
	0x06, 0x00, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	// Entry 100 - 13F
	0x05, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x02, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 140 - 17F
	0x00, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x04, 0x06, 0x06, 0x04,
	0x06, 0x06, 0x04, 0x06, 0x05,
}

// regionISO holds a list of alphabetically sorted 2-letter ISO region codes.
// Each 2-letter codes is followed by two bytes with the following meaning:
//     - [A-Z}{2}: the first letter of the 2-letter code plus these two
//                 letters form the 3-letter ISO code.
//     - 0, n:     index into altRegionISO3.
const regionISO tag.Index = "" + // Size: 1308 bytes
	"AAAAACSCADNDAEREAFFGAGTGAIIAALLBAMRMANNTAOGOAQTAARRGASSMATUTAUUSAWBWAXLA" +
	"AZZEBAIHBBRBBDGDBEELBFFABGGRBHHRBIDIBJENBLLMBMMUBNRNBOOLBQESBRRABSHSBTTN" +
	"BUURBVVTBWWABYLRBZLZCAANCCCKCDODCFAFCGOGCHHECIIVCKOKCLHLCMMRCNHNCOOLCPPT" +
	"CRRICS\x00\x00CTTECUUBCVPVCWUWCXXRCYYPCZZEDDDRDEEUDGGADJJIDKNKDMMADOOMDY" +
	"HYDZZAEA  ECCUEESTEGGYEHSHERRIESSPETTHEU\x00\x03EZ  FIINFJJIFKLKFMSMFORO" +
	"FQ\x00\x18FRRAFXXXGAABGBBRGDRDGEEOGFUFGGGYGHHAGIIBGLRLGMMBGNINGPLPGQNQGR" +
	"RCGS\x00\x06GTTMGUUMGWNBGYUYHKKGHMMDHNNDHRRVHTTIHUUNHVVOIC  IDDNIERLILSR" +
	"IMMNINNDIOOTIQRQIRRNISSLITTAJEEYJMAMJOORJPPNJTTNKEENKGGZKHHMKIIRKM\x00" +
	"\x09KNNAKP\x00\x0cKRORKWWTKY\x00\x0fKZAZLAAOLBBNLCCALIIELKKALRBRLSSOLTTU" +
	"LUUXLVVALYBYMAARMCCOMDDAMENEMFAFMGDGMHHLMIIDMKKDMLLIMMMRMNNGMOACMPNPMQTQ" +
	"MRRTMSSRMTLTMUUSMVDVMWWIMXEXMYYSMZOZNAAMNCCLNEERNFFKNGGANHHBNIICNLLDNOOR" +
	"NPPLNQ\x00\x1eNRRUNTTZNUIUNZZLOMMNPAANPCCIPEERPFYFPGNGPHHLPKAKPLOLPM\x00" +
	"\x12PNCNPRRIPSSEPTRTPUUSPWLWPYRYPZCZQAATQMMMQNNNQOOOQPPPQQQQQRRRQSSSQTTT" +
	"QU\x00\x03QVVVQWWWQXXXQYYYQZZZREEURHHOROOURS\x00\x15RUUSRWWASAAUSBLBSCYC" +
	"SDDNSEWESGGPSHHNSIVNSJJMSKVKSLLESMMRSNENSOOMSRURSSSDSTTPSUUNSVLVSXXMSYYR" +
	"SZWZTAAATCCATDCDTF\x00\x18TGGOTHHATJJKTKKLTLLSTMKMTNUNTOONTPMPTRURTTTOTV" +
	"UVTWWNTZZAUAKRUGGAUK  UMMIUN  USSAUYRYUZZBVAATVCCTVDDRVEENVGGBVIIRVNNMVU" +
	"UTWFLFWKAKWSSMXAAAXBBBXCCCXDDDXEEEXFFFXGGGXHHHXIIIXJJJXKKKXLLLXMMMXNNNXO" +
	"OOXPPPXQQQXRRRXSSSXTTTXUUUXVVVXWWWXXXXXYYYXZZZYDMDYEEMYT\x00\x1bYUUGZAAF" +
	"ZMMBZRARZWWEZZZZ\xff\xff\xff\xff"

// altRegionISO3 holds a list of 3-letter region codes that cannot be
// mapped to 2-letter codes using the default algorithm. This is a short list.
const altRegionISO3 string = "SCGQUUSGSCOMPRKCYMSPMSRBATFMYTATN"

// altRegionIDs holds a list of regionIDs the positions of which match those
// of the 3-letter ISO codes in altRegionISO3.
// Size: 22 bytes, 11 elements
var altRegionIDs = [11]uint16{
	0x0056, 0x006f, 0x0087, 0x00a7, 0x00a9, 0x00ac, 0x00e9, 0x0104,
	0x0120, 0x015e, 0x00db,
}

// Size: 80 bytes, 20 elements
var regionOldMap = [20]fromTo{
	0:  {from: 0x43, to: 0xc3},
	1:  {from: 0x57, to: 0xa6},
	2:  {from: 0x5e, to: 0x5f},
	3:  {from: 0x65, to: 0x3a},
	4:  {from: 0x78, to: 0x77},
	5:  {from: 0x92, to: 0x36},
	6:  {from: 0xa2, to: 0x132},
	7:  {from: 0xc0, to: 0x132},
	8:  {from: 0xd6, to: 0x13e},
	9:  {from: 0xdb, to: 0x2a},
	10: {from: 0xee, to: 0x132},
	11: {from: 0xf1, to: 0xe1},
	12: {from: 0xfb, to: 0x6f},
	13: {from: 0x102, to: 0x163},
	14: {from: 0x129, to: 0x125},
	15: {from: 0x131, to: 0x7a},
	16: {from: 0x139, to: 0x13d},
	17: {from: 0x140, to: 0x132},
	18: {from: 0x15c, to: 0x15d},
	19: {from: 0x162, to: 0x4a},
}

// m49 maps regionIDs to UN.M49 codes. The first isoRegionOffset entries are
// codes indicating collections of regions.
// Size: 714 bytes, 357 elements
var m49 = [357]int16{
	// Entry 0 - 3F
	0, 1, 2, 3, 5, 9, 11, 13,
	14, 15, 17, 18, 19, 21, 29, 30,
	34, 35, 39, 53, 54, 57, 61, 142,
	143, 145, 150, 151, 154, 155, 419, 958,
	0, 20, 784, 4, 28, 660, 8, 51,
	530, 24, 10, 32, 16, 40, 36, 533,
	248, 31, 70, 52, 50, 56, 854, 100,
	48, 108, 204, 652, 60, 96, 68, 535,
	// Entry 40 - 7F
	76, 44, 64, 104, 74, 72, 112, 84,
	124, 166, 180, 140, 178, 756, 384, 184,
	152, 120, 156, 170, 0, 188, 891, 296,
	192, 132, 531, 162, 196, 203, 278, 276,
	0, 262, 208, 212, 214, 204, 12, 0,
	218, 233, 818, 732, 232, 724, 231, 967,
	0, 246, 242, 238, 583, 234, 0, 250,
	249, 266, 826, 308, 268, 254, 831, 288,
	// Entry 80 - BF
	292, 304, 270, 324, 312, 226, 300, 239,
	320, 316, 624, 328, 344, 334, 340, 191,
	332, 348, 854, 0, 360, 372, 376, 833,
	356, 86, 368, 364, 352, 380, 832, 388,
	400, 392, 581, 404, 417, 116, 296, 174,
	659, 408, 410, 414, 136, 398, 418, 422,
	662, 438, 144, 430, 426, 440, 442, 428,
	434, 504, 492, 498, 499, 663, 450, 584,
	// Entry C0 - FF
	581, 807, 466, 104, 496, 446, 580, 474,
	478, 500, 470, 480, 462, 454, 484, 458,
	508, 516, 540, 562, 574, 566, 548, 558,
	528, 578, 524, 10, 520, 536, 570, 554,
	512, 591, 0, 604, 258, 598, 608, 586,
	616, 666, 612, 630, 275, 620, 581, 585,
	600, 591, 634, 959, 960, 961, 962, 963,
	964, 965, 966, 967, 968, 969, 970, 971,
	// Entry 100 - 13F
	972, 638, 716, 642, 688, 643, 646, 682,
	90, 690, 729, 752, 702, 654, 705, 744,
	703, 694, 674, 686, 706, 740, 728, 678,
	810, 222, 534, 760, 748, 0, 796, 148,
	260, 768, 764, 762, 772, 626, 795, 788,
	776, 626, 792, 780, 798, 158, 834, 804,
	800, 826, 581, 0, 840, 858, 860, 336,
	670, 704, 862, 92, 850, 704, 548, 876,
	// Entry 140 - 17F
	581, 882, 973, 974, 975, 976, 977, 978,
	979, 980, 981, 982, 983, 984, 985, 986,
	987, 988, 989, 990, 991, 992, 993, 994,
	995, 996, 997, 998, 720, 887, 175, 891,
	710, 894, 180, 716, 999,
}

// m49Index gives indexes into fromM49 based on the three most significant bits
// of a 10-bit UN.M49 code. To search an UN.M49 code in fromM49, search in
//    fromM49[m49Index[msb39(code)]:m49Index[msb3(code)+1]]
// for an entry where the first 7 bits match the 7 lsb of the UN.M49 code.
// The region code is stored in the 9 lsb of the indexed value.
// Size: 18 bytes, 9 elements
var m49Index = [9]int16{
	0, 59, 107, 142, 180, 219, 258, 290,
	332,
}

// fromM49 contains entries to map UN.M49 codes to regions. See m49Index for details.
// Size: 664 bytes, 332 elements
var fromM49 = [332]uint16{
	// Entry 0 - 3F
	0x0201, 0x0402, 0x0603, 0x0823, 0x0a04, 0x1026, 0x1205, 0x142a,
	0x1606, 0x1866, 0x1a07, 0x1c08, 0x1e09, 0x202c, 0x220a, 0x240b,
	0x260c, 0x2821, 0x2a0d, 0x3029, 0x3824, 0x3a0e, 0x3c0f, 0x3e31,
	0x402b, 0x4410, 0x4611, 0x482e, 0x4e12, 0x502d, 0x5841, 0x6038,
	0x6434, 0x6627, 0x6833, 0x6a13, 0x6c14, 0x7035, 0x7215, 0x783c,
	0x7a16, 0x8042, 0x883e, 0x8c32, 0x9045, 0x9444, 0x9840, 0xa847,
	0xac99, 0xb508, 0xb93b, 0xc03d, 0xc837, 0xd0c3, 0xd839, 0xe046,
	0xe8a5, 0xf051, 0xf848, 0x0859, 0x10ac, 0x184b, 0x1c17, 0x1e18,
	// Entry 40 - 7F
	0x20b2, 0x2219, 0x291f, 0x2c1a, 0x2e1b, 0x3050, 0x341c, 0x361d,
	0x3852, 0x3d2d, 0x445b, 0x4c49, 0x5453, 0x5ca7, 0x5f5e, 0x644c,
	0x684a, 0x704f, 0x7855, 0x7e8f, 0x8058, 0x885c, 0x965d, 0x983a,
	0xa062, 0xa863, 0xac64, 0xb468, 0xbd19, 0xc485, 0xcc6e, 0xce6e,
	0xd06c, 0xd269, 0xd475, 0xdc73, 0xde87, 0xe472, 0xec71, 0xf030,
	0xf278, 0xf477, 0xfc7d, 0x04e4, 0x0920, 0x0c61, 0x1479, 0x187c,
	0x1c82, 0x26ec, 0x285f, 0x2c5e, 0x305f, 0x407f, 0x4880, 0x50a6,
	0x5886, 0x6081, 0x687b, 0x7084, 0x7889, 0x8088, 0x8883, 0x908b,
	// Entry 80 - BF
	0x9890, 0x9c8d, 0xa137, 0xa88e, 0xb08c, 0xb891, 0xc09c, 0xc898,
	0xd094, 0xd89b, 0xe09a, 0xe895, 0xf096, 0xf89d, 0x004e, 0x089f,
	0x10a1, 0x1cad, 0x20a0, 0x28a3, 0x30a9, 0x34aa, 0x3cab, 0x42a4,
	0x44ae, 0x461e, 0x4caf, 0x54b4, 0x58b7, 0x5cb3, 0x64b8, 0x6cb1,
	0x70b5, 0x74b6, 0x7cc5, 0x84be, 0x8ccd, 0x94cf, 0x9ccc, 0xa4c2,
	0xacca, 0xb4c7, 0xbcc8, 0xc0cb, 0xc8ce, 0xd8ba, 0xe0c4, 0xe4bb,
	0xe6bc, 0xe8c9, 0xf0b9, 0xf8d0, 0x00e0, 0x08d1, 0x10dc, 0x18da,
	0x20d8, 0x2428, 0x265a, 0x2a2f, 0x2d1a, 0x2e3f, 0x30dd, 0x38d2,
	// Entry C0 - FF
	0x493e, 0x54df, 0x5cd7, 0x64d3, 0x6cd5, 0x74de, 0x7cd4, 0x84d9,
	0x88c6, 0x8b32, 0x8e74, 0x90bf, 0x92ef, 0x94e7, 0x9ee1, 0xace5,
	0xb0f0, 0xb8e3, 0xc0e6, 0xc8ea, 0xd0e8, 0xd8ed, 0xe08a, 0xe525,
	0xeceb, 0xf4f2, 0xfd01, 0x0503, 0x0705, 0x0d06, 0x183b, 0x1d0d,
	0x26a8, 0x2825, 0x2cb0, 0x2ebd, 0x34e9, 0x3d38, 0x4512, 0x4d17,
	0x5507, 0x5d13, 0x6104, 0x6509, 0x6d11, 0x7d0c, 0x7f10, 0x813d,
	0x830e, 0x8514, 0x8d60, 0x9963, 0xa15c, 0xa86d, 0xb116, 0xb30a,
	0xb86b, 0xc10a, 0xc915, 0xd10f, 0xd91c, 0xe10b, 0xe84d, 0xf11b,
	// Entry 100 - 13F
	0xf523, 0xf922, 0x0121, 0x0924, 0x1128, 0x192b, 0x2022, 0x2927,
	0x312a, 0x3726, 0x391e, 0x3d2c, 0x4130, 0x492f, 0x4ec1, 0x5518,
	0x646a, 0x747a, 0x7e7e, 0x809e, 0x8297, 0x852e, 0x9134, 0xa53c,
	0xac36, 0xb535, 0xb936, 0xbd3a, 0xd93f, 0xe541, 0xed5d, 0xef5d,
	0xf656, 0xfd61, 0x7c1f, 0x7ef3, 0x80f4, 0x82f5, 0x84f6, 0x86f7,
	0x88f8, 0x8af9, 0x8cfa, 0x8e6f, 0x90fc, 0x92fd, 0x94fe, 0x96ff,
	0x9900, 0x9b42, 0x9d43, 0x9f44, 0xa145, 0xa346, 0xa547, 0xa748,
	0xa949, 0xab4a, 0xad4b, 0xaf4c, 0xb14d, 0xb34e, 0xb54f, 0xb750,
	// Entry 140 - 17F
	0xb951, 0xbb52, 0xbd53, 0xbf54, 0xc155, 0xc356, 0xc557, 0xc758,
	0xc959, 0xcb5a, 0xcd5b, 0xcf64,
}

// Size: 1463 bytes
var variantIndex = map[string]uint8{
	"1606nict": 0x0,
	"1694acad": 0x1,
	"1901":     0x2,
	"1959acad": 0x3,
	"1994":     0x45,
	"1996":     0x4,
	"abl1943":  0x5,
	"alalc97":  0x47,
	"aluku":    0x6,
	"ao1990":   0x7,
	"arevela":  0x8,
	"arevmda":  0x9,
	"baku1926": 0xa,
	"balanka":  0xb,
	"barla":    0xc,
	"basiceng": 0xd,
	"bauddha":  0xe,
	"biscayan": 0xf,
	"biske":    0x40,
	"bohoric":  0x10,
	"boont":    0x11,
	"colb1945": 0x12,
	"cornu":    0x13,
	"dajnko":   0x14,
	"ekavsk":   0x15,
	"emodeng":  0x16,
	"fonipa":   0x48,
	"fonnapa":  0x49,
	"fonupa":   0x4a,
	"fonxsamp": 0x4b,
	"hepburn":  0x17,
	"heploc":   0x46,
	"hognorsk": 0x18,
	"ijekavsk": 0x19,
	"itihasa":  0x1a,
	"jauer":    0x1b,
	"jyutping": 0x1c,
	"kkcor":    0x1d,
	"kociewie": 0x1e,
	"kscor":    0x1f,
	"laukika":  0x20,
	"lipaw":    0x41,
	"luna1918": 0x21,
	"metelko":  0x22,
	"monoton":  0x23,
	"ndyuka":   0x24,
	"nedis":    0x25,
	"newfound": 0x26,
	"njiva":    0x42,
	"nulik":    0x27,
	"osojs":    0x43,
	"oxendict": 0x28,
	"pamaka":   0x29,
	"petr1708": 0x2a,
	"pinyin":   0x2b,
	"polyton":  0x2c,
	"puter":    0x2d,
	"rigik":    0x2e,
	"rozaj":    0x2f,
	"rumgr":    0x30,
	"scotland": 0x31,
	"scouse":   0x32,
	"simple":   0x4c,
	"solba":    0x44,
	"sotav":    0x33,
	"surmiran": 0x34,
	"sursilv":  0x35,
	"sutsilv":  0x36,
	"tarask":   0x37,
	"uccor":    0x38,
	"ucrcor":   0x39,
	"ulster":   0x3a,
	"unifon":   0x3b,
	"vaidika":  0x3c,
	"valencia": 0x3d,
	"vallader": 0x3e,
	"wadegile": 0x3f,
}

// variantNumSpecialized is the number of specialized variants in variants.
const variantNumSpecialized = 71

// nRegionGroups is the number of region groups.
const nRegionGroups = 32

type likelyLangRegion struct {
	lang   uint16
	region uint16
}

// likelyScript is a lookup table, indexed by scriptID, for the most likely
// languages and regions given a script.
// Size: 928 bytes, 232 elements
var likelyScript = [232]likelyLangRegion{
	1:   {lang: 0x149, region: 0x83},
	3:   {lang: 0x299, region: 0x105},
	4:   {lang: 0x1e, region: 0x98},
	5:   {lang: 0x39, region: 0x6a},
	7:   {lang: 0x3a, region: 0x9b},
	8:   {lang: 0x1d0, region: 0x27},
	9:   {lang: 0x12, region: 0x9b},
	10:  {lang: 0x5a, region: 0x94},
	11:  {lang: 0x5f, region: 0x51},
	12:  {lang: 0xb7, region: 0xb3},
	13:  {lang: 0x62, region: 0x94},
	14:  {lang: 0xa3, region: 0x34},
	15:  {lang: 0x3e0, region: 0x98},
	17:  {lang: 0x51f, region: 0x12d},
	18:  {lang: 0x3a8, region: 0x98},
	19:  {lang: 0x159, region: 0x77},
	20:  {lang: 0xc0, region: 0x94},
	21:  {lang: 0x9b, region: 0xe6},
	22:  {lang: 0xd9, region: 0x34},
	23:  {lang: 0xf0, region: 0x48},
	24:  {lang: 0x4e6, region: 0x12a},
	25:  {lang: 0xe5, region: 0x13d},
	26:  {lang: 0xe3, region: 0x134},
	28:  {lang: 0xee, region: 0x6a},
	29:  {lang: 0x199, region: 0x5c},
	30:  {lang: 0x3d9, region: 0x105},
	32:  {lang: 0x1b7, region: 0x98},
	34:  {lang: 0x159, region: 0x77},
	37:  {lang: 0x12f, region: 0x6a},
	38:  {lang: 0x427, region: 0x26},
	39:  {lang: 0x26, region: 0x6e},
	41:  {lang: 0x208, region: 0x7c},
	42:  {lang: 0xfa, region: 0x37},
	43:  {lang: 0x198, region: 0x12f},
	44:  {lang: 0x3e0, region: 0x98},
	45:  {lang: 0x131, region: 0x86},
	46:  {lang: 0x19d, region: 0x98},
	47:  {lang: 0x394, region: 0x98},
	48:  {lang: 0x51f, region: 0x12d},
	49:  {lang: 0x24b, region: 0xaa},
	50:  {lang: 0x51f, region: 0x52},
	51:  {lang: 0x1c4, region: 0xe6},
	52:  {lang: 0x51f, region: 0x52},
	53:  {lang: 0x51f, region: 0x12d},
	54:  {lang: 0x2f4, region: 0x9a},
	55:  {lang: 0x1b5, region: 0x96},
	56:  {lang: 0x1f8, region: 0xa1},
	57:  {lang: 0x1be, region: 0x12a},
	58:  {lang: 0x1c3, region: 0xae},
	60:  {lang: 0x1ce, region: 0x91},
	62:  {lang: 0x13d, region: 0x9d},
	63:  {lang: 0x24b, region: 0xaa},
	64:  {lang: 0x206, region: 0x94},
	65:  {lang: 0x1f8, region: 0xa1},
	67:  {lang: 0x130, region: 0xc3},
	68:  {lang: 0x1f8, region: 0xa1},
	69:  {lang: 0x3b2, region: 0xe7},
	70:  {lang: 0x242, region: 0xa5},
	71:  {lang: 0x3f0, region: 0x98},
	74:  {lang: 0x249, region: 0x98},
	75:  {lang: 0x24b, region: 0xaa},
	77:  {lang: 0x87, region: 0x98},
	78:  {lang: 0x367, region: 0x122},
	79:  {lang: 0x2af, region: 0xae},
	84:  {lang: 0x296, region: 0x98},
	85:  {lang: 0x29f, region: 0x98},
	86:  {lang: 0x286, region: 0x86},
	87:  {lang: 0x199, region: 0x86},
	88:  {lang: 0x2a3, region: 0x52},
	90:  {lang: 0x4ea, region: 0x12a},
	91:  {lang: 0x4eb, region: 0x12a},
	92:  {lang: 0x1b7, region: 0x98},
	93:  {lang: 0x32e, region: 0x9b},
	94:  {lang: 0x4ed, region: 0x52},
	95:  {lang: 0xa7, region: 0x52},
	97:  {lang: 0x2df, region: 0x111},
	98:  {lang: 0x4ee, region: 0x10a},
	99:  {lang: 0x4ee, region: 0x10a},
	100: {lang: 0x2fb, region: 0x98},
	101: {lang: 0x312, region: 0x98},
	102: {lang: 0x302, region: 0x52},
	104: {lang: 0x315, region: 0x34},
	105: {lang: 0x305, region: 0x98},
	106: {lang: 0x40a, region: 0xe7},
	107: {lang: 0x328, region: 0xc3},
	108: {lang: 0x4ef, region: 0x107},
	109: {lang: 0x3a, region: 0xa0},
	110: {lang: 0x34a, region: 0xda},
	112: {lang: 0x2c7, region: 0x83},
	114: {lang: 0x3f9, region: 0x95},
	115: {lang: 0x3e5, region: 0x98},
	116: {lang: 0x392, region: 0xc4},
	117: {lang: 0x38c, region: 0x98},
	118: {lang: 0x390, region: 0x134},
	119: {lang: 0x41f, region: 0x114},
	120: {lang: 0x3a, region: 0x11b},
	121: {lang: 0xf9, region: 0xc3},
	122: {lang: 0x274, region: 0x105},
	123: {lang: 0x2c0, region: 0x52},
	124: {lang: 0x396, region: 0x9b},
	125: {lang: 0x396, region: 0x52},
	127: {lang: 0x3a4, region: 0xaf},
	129: {lang: 0x1bf, region: 0x52},
	130: {lang: 0x4f3, region: 0x9b},
	181: {lang: 0x3c2, region: 0x94},
	183: {lang: 0x369, region: 0x10b},
	184: {lang: 0x416, region: 0x96},
	186: {lang: 0x4f5, region: 0x15d},
	187: {lang: 0x3e6, region: 0x98},
	188: {lang: 0x44, region: 0x134},
	189: {lang: 0x134, region: 0x7a},
	190: {lang: 0x3e0, region: 0x98},
	191: {lang: 0x3e0, region: 0x98},
	192: {lang: 0x3f0, region: 0x98},
	193: {lang: 0x402, region: 0xb2},
	194: {lang: 0x429, region: 0x98},
	195: {lang: 0x434, region: 0x94},
	196: {lang: 0x443, region: 0x34},
	197: {lang: 0x444, region: 0x9a},
	201: {lang: 0x450, region: 0xe6},
	202: {lang: 0x116, region: 0x98},
	203: {lang: 0x454, region: 0x52},
	204: {lang: 0x22a, region: 0x52},
	205: {lang: 0x446, region: 0x98},
	206: {lang: 0x49b, region: 0x52},
	207: {lang: 0x9d, region: 0x13d},
	208: {lang: 0x457, region: 0x98},
	210: {lang: 0x51e, region: 0xb9},
	211: {lang: 0x14e, region: 0xe6},
	212: {lang: 0x124, region: 0xcc},
	213: {lang: 0x461, region: 0x122},
	214: {lang: 0xa7, region: 0x52},
	215: {lang: 0x2c5, region: 0x98},
	216: {lang: 0x4a3, region: 0x11b},
	217: {lang: 0x4b4, region: 0xb3},
	219: {lang: 0x1c7, region: 0x98},
	221: {lang: 0x3a0, region: 0x9b},
	222: {lang: 0x21, region: 0x9a},
	223: {lang: 0x1e2, region: 0x52},
}

type likelyScriptRegion struct {
	region uint16
	script uint8
	flags  uint8
}

// likelyLang is a lookup table, indexed by langID, for the most likely
// scripts and regions given incomplete information. If more entries exist for a
// given language, region and script are the index and size respectively
// of the list in likelyLangList.
// Size: 5276 bytes, 1319 elements
var likelyLang = [1319]likelyScriptRegion{
	0:    {region: 0x134, script: 0x52, flags: 0x0},
	1:    {region: 0x6e, script: 0x52, flags: 0x0},
	2:    {region: 0x164, script: 0x52, flags: 0x0},
	3:    {region: 0x164, script: 0x52, flags: 0x0},
	4:    {region: 0x164, script: 0x52, flags: 0x0},
	5:    {region: 0x7c, script: 0x1e, flags: 0x0},
	6:    {region: 0x164, script: 0x52, flags: 0x0},
	7:    {region: 0x7f, script: 0x52, flags: 0x0},
	8:    {region: 0x164, script: 0x52, flags: 0x0},
	9:    {region: 0x164, script: 0x52, flags: 0x0},
	10:   {region: 0x164, script: 0x52, flags: 0x0},
	11:   {region: 0x94, script: 0x52, flags: 0x0},
	12:   {region: 0x130, script: 0x52, flags: 0x0},
	13:   {region: 0x7f, script: 0x52, flags: 0x0},
	14:   {region: 0x164, script: 0x52, flags: 0x0},
	15:   {region: 0x164, script: 0x52, flags: 0x0},
	16:   {region: 0x105, script: 0x1e, flags: 0x0},
	17:   {region: 0x164, script: 0x52, flags: 0x0},
	18:   {region: 0x9b, script: 0x9, flags: 0x0},
	19:   {region: 0x127, script: 0x5, flags: 0x0},
	20:   {region: 0x164, script: 0x52, flags: 0x0},
	21:   {region: 0x160, script: 0x52, flags: 0x0},
	22:   {region: 0x164, script: 0x52, flags: 0x0},
	23:   {region: 0x164, script: 0x52, flags: 0x0},
	24:   {region: 0x164, script: 0x52, flags: 0x0},
	25:   {region: 0x164, script: 0x52, flags: 0x0},
	26:   {region: 0x164, script: 0x52, flags: 0x0},
	27:   {region: 0x51, script: 0x52, flags: 0x0},
	28:   {region: 0x164, script: 0x52, flags: 0x0},
	29:   {region: 0x164, script: 0x52, flags: 0x0},
	30:   {region: 0x98, script: 0x4, flags: 0x0},
	31:   {region: 0x164, script: 0x52, flags: 0x0},
	32:   {region: 0x7f, script: 0x52, flags: 0x0},
	33:   {region: 0x9a, script: 0xde, flags: 0x0},
	34:   {region: 0x164, script: 0x52, flags: 0x0},
	35:   {region: 0x164, script: 0x52, flags: 0x0},
	36:   {region: 0x14c, script: 0x52, flags: 0x0},
	37:   {region: 0x105, script: 0x1e, flags: 0x0},
	38:   {region: 0x6e, script: 0x27, flags: 0x0},
	39:   {region: 0x164, script: 0x52, flags: 0x0},
	40:   {region: 0x164, script: 0x52, flags: 0x0},
	41:   {region: 0xd5, script: 0x52, flags: 0x0},
	42:   {region: 0x164, script: 0x52, flags: 0x0},
	44:   {region: 0x164, script: 0x52, flags: 0x0},
	45:   {region: 0x164, script: 0x52, flags: 0x0},
	46:   {region: 0x164, script: 0x52, flags: 0x0},
	47:   {region: 0x164, script: 0x52, flags: 0x0},
	48:   {region: 0x164, script: 0x52, flags: 0x0},
	49:   {region: 0x164, script: 0x52, flags: 0x0},
	50:   {region: 0x94, script: 0x52, flags: 0x0},
	51:   {region: 0x164, script: 0x5, flags: 0x0},
	52:   {region: 0x121, script: 0x5, flags: 0x0},
	53:   {region: 0x164, script: 0x52, flags: 0x0},
	54:   {region: 0x164, script: 0x52, flags: 0x0},
	55:   {region: 0x164, script: 0x52, flags: 0x0},
	56:   {region: 0x164, script: 0x52, flags: 0x0},
	57:   {region: 0x6a, script: 0x5, flags: 0x0},
	58:   {region: 0x0, script: 0x3, flags: 0x1},
	59:   {region: 0x164, script: 0x52, flags: 0x0},
	60:   {region: 0x50, script: 0x52, flags: 0x0},
	61:   {region: 0x3e, script: 0x52, flags: 0x0},
	62:   {region: 0x66, script: 0x5, flags: 0x0},
	64:   {region: 0xb9, script: 0x5, flags: 0x0},
	65:   {region: 0x6a, script: 0x5, flags: 0x0},
	66:   {region: 0x98, script: 0xe, flags: 0x0},
	67:   {region: 0x12e, script: 0x52, flags: 0x0},
	68:   {region: 0x134, script: 0xbc, flags: 0x0},
	69:   {region: 0x164, script: 0x52, flags: 0x0},
	70:   {region: 0x164, script: 0x52, flags: 0x0},
	71:   {region: 0x6d, script: 0x52, flags: 0x0},
	72:   {region: 0x164, script: 0x52, flags: 0x0},
	73:   {region: 0x164, script: 0x52, flags: 0x0},
	74:   {region: 0x48, script: 0x52, flags: 0x0},
	75:   {region: 0x164, script: 0x52, flags: 0x0},
	76:   {region: 0x105, script: 0x1e, flags: 0x0},
	77:   {region: 0x164, script: 0x5, flags: 0x0},
	78:   {region: 0x164, script: 0x52, flags: 0x0},
	79:   {region: 0x164, script: 0x52, flags: 0x0},
	80:   {region: 0x164, script: 0x52, flags: 0x0},
	81:   {region: 0x98, script: 0x20, flags: 0x0},
	82:   {region: 0x164, script: 0x52, flags: 0x0},
	83:   {region: 0x164, script: 0x52, flags: 0x0},
	84:   {region: 0x164, script: 0x52, flags: 0x0},
	85:   {region: 0x3e, script: 0x52, flags: 0x0},
	86:   {region: 0x164, script: 0x52, flags: 0x0},
	87:   {region: 0x3, script: 0x5, flags: 0x1},
	88:   {region: 0x105, script: 0x1e, flags: 0x0},
	89:   {region: 0xe7, script: 0x5, flags: 0x0},
	90:   {region: 0x94, script: 0x52, flags: 0x0},
	91:   {region: 0xda, script: 0x20, flags: 0x0},
	92:   {region: 0x2d, script: 0x52, flags: 0x0},
	93:   {region: 0x51, script: 0x52, flags: 0x0},
	94:   {region: 0x164, script: 0x52, flags: 0x0},
	95:   {region: 0x51, script: 0xb, flags: 0x0},
	96:   {region: 0x164, script: 0x52, flags: 0x0},
	97:   {region: 0x164, script: 0x52, flags: 0x0},
	98:   {region: 0x94, script: 0x52, flags: 0x0},
	99:   {region: 0x164, script: 0x52, flags: 0x0},
	100:  {region: 0x51, script: 0x52, flags: 0x0},
	101:  {region: 0x164, script: 0x52, flags: 0x0},
	102:  {region: 0x164, script: 0x52, flags: 0x0},
	103:  {region: 0x164, script: 0x52, flags: 0x0},
	104:  {region: 0x164, script: 0x52, flags: 0x0},
	105:  {region: 0x4e, script: 0x52, flags: 0x0},
	106:  {region: 0x164, script: 0x52, flags: 0x0},
	107:  {region: 0x164, script: 0x52, flags: 0x0},
	108:  {region: 0x164, script: 0x52, flags: 0x0},
	109:  {region: 0x164, script: 0x27, flags: 0x0},
	110:  {region: 0x164, script: 0x52, flags: 0x0},
	111:  {region: 0x164, script: 0x52, flags: 0x0},
	112:  {region: 0x46, script: 0x1e, flags: 0x0},
	113:  {region: 0x164, script: 0x52, flags: 0x0},
	114:  {region: 0x164, script: 0x52, flags: 0x0},
	115:  {region: 0x10a, script: 0x5, flags: 0x0},
	116:  {region: 0x161, script: 0x52, flags: 0x0},
	117:  {region: 0x164, script: 0x52, flags: 0x0},
	118:  {region: 0x94, script: 0x52, flags: 0x0},
	119:  {region: 0x164, script: 0x52, flags: 0x0},
	120:  {region: 0x12e, script: 0x52, flags: 0x0},
	121:  {region: 0x51, script: 0x52, flags: 0x0},
	122:  {region: 0x98, script: 0xcd, flags: 0x0},
	123:  {region: 0xe7, script: 0x5, flags: 0x0},
	124:  {region: 0x98, script: 0x20, flags: 0x0},
	125:  {region: 0x37, script: 0x1e, flags: 0x0},
	126:  {region: 0x98, script: 0x20, flags: 0x0},
	127:  {region: 0xe7, script: 0x5, flags: 0x0},
	128:  {region: 0x12a, script: 0x2d, flags: 0x0},
	130:  {region: 0x98, script: 0x20, flags: 0x0},
	131:  {region: 0x164, script: 0x52, flags: 0x0},
	132:  {region: 0x98, script: 0x20, flags: 0x0},
	133:  {region: 0xe6, script: 0x52, flags: 0x0},
	134:  {region: 0x164, script: 0x52, flags: 0x0},
	135:  {region: 0x98, script: 0x20, flags: 0x0},
	136:  {region: 0x164, script: 0x52, flags: 0x0},
	137:  {region: 0x13e, script: 0x52, flags: 0x0},
	138:  {region: 0x164, script: 0x52, flags: 0x0},
	139:  {region: 0x164, script: 0x52, flags: 0x0},
	140:  {region: 0xe6, script: 0x52, flags: 0x0},
	141:  {region: 0x164, script: 0x52, flags: 0x0},
	142:  {region: 0xd5, script: 0x52, flags: 0x0},
	143:  {region: 0x164, script: 0x52, flags: 0x0},
	144:  {region: 0x164, script: 0x52, flags: 0x0},
	145:  {region: 0x164, script: 0x52, flags: 0x0},
	146:  {region: 0x164, script: 0x27, flags: 0x0},
	147:  {region: 0x98, script: 0x20, flags: 0x0},
	148:  {region: 0x94, script: 0x52, flags: 0x0},
	149:  {region: 0x164, script: 0x52, flags: 0x0},
	150:  {region: 0x164, script: 0x52, flags: 0x0},
	151:  {region: 0x164, script: 0x52, flags: 0x0},
	152:  {region: 0x164, script: 0x52, flags: 0x0},
	153:  {region: 0x51, script: 0x52, flags: 0x0},
	154:  {region: 0x164, script: 0x52, flags: 0x0},
	155:  {region: 0xe6, script: 0x52, flags: 0x0},
	156:  {region: 0x164, script: 0x52, flags: 0x0},
	157:  {region: 0x13d, script: 0xcf, flags: 0x0},
	158:  {region: 0xc2, script: 0x52, flags: 0x0},
	159:  {region: 0x164, script: 0x52, flags: 0x0},
	160:  {region: 0x164, script: 0x52, flags: 0x0},
	161:  {region: 0xc2, script: 0x52, flags: 0x0},
	162:  {region: 0x164, script: 0x52, flags: 0x0},
	163:  {region: 0x34, script: 0xe, flags: 0x0},
	164:  {region: 0x164, script: 0x52, flags: 0x0},
	165:  {region: 0x164, script: 0x52, flags: 0x0},
	166:  {region: 0x164, script: 0x52, flags: 0x0},
	167:  {region: 0x52, script: 0xd6, flags: 0x0},
	168:  {region: 0x164, script: 0x52, flags: 0x0},
	169:  {region: 0x164, script: 0x52, flags: 0x0},
	170:  {region: 0x164, script: 0x52, flags: 0x0},
	171:  {region: 0x98, script: 0xe, flags: 0x0},
	172:  {region: 0x164, script: 0x52, flags: 0x0},
	173:  {region: 0x9b, script: 0x5, flags: 0x0},
	174:  {region: 0x164, script: 0x52, flags: 0x0},
	175:  {region: 0x4e, script: 0x52, flags: 0x0},
	176:  {region: 0x77, script: 0x52, flags: 0x0},
	177:  {region: 0x98, script: 0x20, flags: 0x0},
	178:  {region: 0xe7, script: 0x5, flags: 0x0},
	179:  {region: 0x98, script: 0x20, flags: 0x0},
	180:  {region: 0x164, script: 0x52, flags: 0x0},
	181:  {region: 0x32, script: 0x52, flags: 0x0},
	182:  {region: 0x164, script: 0x52, flags: 0x0},
	183:  {region: 0xb3, script: 0xc, flags: 0x0},
	184:  {region: 0x51, script: 0x52, flags: 0x0},
	185:  {region: 0x164, script: 0x27, flags: 0x0},
	186:  {region: 0xe6, script: 0x52, flags: 0x0},
	187:  {region: 0x164, script: 0x52, flags: 0x0},
	188:  {region: 0xe7, script: 0x20, flags: 0x0},
	189:  {region: 0x105, script: 0x1e, flags: 0x0},
	190:  {region: 0x15e, script: 0x52, flags: 0x0},
	191:  {region: 0x164, script: 0x52, flags: 0x0},
	192:  {region: 0x94, script: 0x52, flags: 0x0},
	193:  {region: 0x164, script: 0x52, flags: 0x0},
	194:  {region: 0x51, script: 0x52, flags: 0x0},
	195:  {region: 0x164, script: 0x52, flags: 0x0},
	196:  {region: 0x164, script: 0x52, flags: 0x0},
	197:  {region: 0x164, script: 0x52, flags: 0x0},
	198:  {region: 0x85, script: 0x52, flags: 0x0},
	199:  {region: 0x164, script: 0x52, flags: 0x0},
	200:  {region: 0x164, script: 0x52, flags: 0x0},
	201:  {region: 0x164, script: 0x52, flags: 0x0},
	202:  {region: 0x164, script: 0x52, flags: 0x0},
	203:  {region: 0x6c, script: 0x27, flags: 0x0},
	204:  {region: 0x164, script: 0x52, flags: 0x0},
	205:  {region: 0x164, script: 0x52, flags: 0x0},
	206:  {region: 0x51, script: 0x52, flags: 0x0},
	207:  {region: 0x164, script: 0x52, flags: 0x0},
	208:  {region: 0x164, script: 0x52, flags: 0x0},
	209:  {region: 0xc2, script: 0x52, flags: 0x0},
	210:  {region: 0x164, script: 0x52, flags: 0x0},
	211:  {region: 0x164, script: 0x52, flags: 0x0},
	212:  {region: 0x164, script: 0x52, flags: 0x0},
	213:  {region: 0x6d, script: 0x52, flags: 0x0},
	214:  {region: 0x164, script: 0x52, flags: 0x0},
	215:  {region: 0x164, script: 0x52, flags: 0x0},
	216:  {region: 0xd5, script: 0x52, flags: 0x0},
	217:  {region: 0x8, script: 0x2, flags: 0x1},
	218:  {region: 0x105, script: 0x1e, flags: 0x0},
	219:  {region: 0xe6, script: 0x52, flags: 0x0},
	220:  {region: 0x164, script: 0x52, flags: 0x0},
	221:  {region: 0x130, script: 0x52, flags: 0x0},
	222:  {region: 0x89, script: 0x52, flags: 0x0},
	223:  {region: 0x74, script: 0x52, flags: 0x0},
	224:  {region: 0x105, script: 0x1e, flags: 0x0},
	225:  {region: 0x134, script: 0x52, flags: 0x0},
	226:  {region: 0x48, script: 0x52, flags: 0x0},
	227:  {region: 0x134, script: 0x1a, flags: 0x0},
	228:  {region: 0xa5, script: 0x5, flags: 0x0},
	229:  {region: 0x13d, script: 0x19, flags: 0x0},
	230:  {region: 0x164, script: 0x52, flags: 0x0},
	231:  {region: 0x9a, script: 0x5, flags: 0x0},
	232:  {region: 0x164, script: 0x52, flags: 0x0},
	233:  {region: 0x164, script: 0x52, flags: 0x0},
	234:  {region: 0x164, script: 0x52, flags: 0x0},
	235:  {region: 0x164, script: 0x52, flags: 0x0},
	236:  {region: 0x164, script: 0x52, flags: 0x0},
	237:  {region: 0x77, script: 0x52, flags: 0x0},
	238:  {region: 0x6a, script: 0x1c, flags: 0x0},
	239:  {region: 0xe6, script: 0x52, flags: 0x0},
	240:  {region: 0x48, script: 0x17, flags: 0x0},
	241:  {region: 0x48, script: 0x17, flags: 0x0},
	242:  {region: 0x48, script: 0x17, flags: 0x0},
	243:  {region: 0x48, script: 0x17, flags: 0x0},
	244:  {region: 0x48, script: 0x17, flags: 0x0},
	245:  {region: 0x109, script: 0x52, flags: 0x0},
	246:  {region: 0x5d, script: 0x52, flags: 0x0},
	247:  {region: 0xe8, script: 0x52, flags: 0x0},
	248:  {region: 0x48, script: 0x17, flags: 0x0},
	249:  {region: 0xc3, script: 0x79, flags: 0x0},
	250:  {region: 0xa, script: 0x2, flags: 0x1},
	251:  {region: 0x105, script: 0x1e, flags: 0x0},
	252:  {region: 0x7a, script: 0x52, flags: 0x0},
	253:  {region: 0x62, script: 0x52, flags: 0x0},
	254:  {region: 0x164, script: 0x52, flags: 0x0},
	255:  {region: 0x164, script: 0x52, flags: 0x0},
	256:  {region: 0x164, script: 0x52, flags: 0x0},
	257:  {region: 0x164, script: 0x52, flags: 0x0},
	258:  {region: 0x134, script: 0x52, flags: 0x0},
	259:  {region: 0x105, script: 0x1e, flags: 0x0},
	260:  {region: 0xa3, script: 0x52, flags: 0x0},
	261:  {region: 0x164, script: 0x52, flags: 0x0},
	262:  {region: 0x164, script: 0x52, flags: 0x0},
	263:  {region: 0x98, script: 0x5, flags: 0x0},
	264:  {region: 0x164, script: 0x52, flags: 0x0},
	265:  {region: 0x5f, script: 0x52, flags: 0x0},
	266:  {region: 0x164, script: 0x52, flags: 0x0},
	267:  {region: 0x48, script: 0x52, flags: 0x0},
	268:  {region: 0x164, script: 0x52, flags: 0x0},
	269:  {region: 0x164, script: 0x52, flags: 0x0},
	270:  {region: 0x164, script: 0x52, flags: 0x0},
	271:  {region: 0x164, script: 0x5, flags: 0x0},
	272:  {region: 0x48, script: 0x52, flags: 0x0},
	273:  {region: 0x164, script: 0x52, flags: 0x0},
	274:  {region: 0x164, script: 0x52, flags: 0x0},
	275:  {region: 0xd3, script: 0x52, flags: 0x0},
	276:  {region: 0x4e, script: 0x52, flags: 0x0},
	277:  {region: 0x164, script: 0x52, flags: 0x0},
	278:  {region: 0x98, script: 0x5, flags: 0x0},
	279:  {region: 0x164, script: 0x52, flags: 0x0},
	280:  {region: 0x164, script: 0x52, flags: 0x0},
	281:  {region: 0x164, script: 0x52, flags: 0x0},
	282:  {region: 0x164, script: 0x27, flags: 0x0},
	283:  {region: 0x5f, script: 0x52, flags: 0x0},
	284:  {region: 0xc2, script: 0x52, flags: 0x0},
	285:  {region: 0xcf, script: 0x52, flags: 0x0},
	286:  {region: 0x164, script: 0x52, flags: 0x0},
	287:  {region: 0xda, script: 0x20, flags: 0x0},
	288:  {region: 0x51, script: 0x52, flags: 0x0},
	289:  {region: 0x164, script: 0x52, flags: 0x0},
	290:  {region: 0x164, script: 0x52, flags: 0x0},
	291:  {region: 0x164, script: 0x52, flags: 0x0},
	292:  {region: 0xcc, script: 0xd4, flags: 0x0},
	293:  {region: 0x164, script: 0x52, flags: 0x0},
	294:  {region: 0x164, script: 0x52, flags: 0x0},
	295:  {region: 0x113, script: 0x52, flags: 0x0},
	296:  {region: 0x36, script: 0x52, flags: 0x0},
	297:  {region: 0x42, script: 0xd6, flags: 0x0},
	298:  {region: 0x164, script: 0x52, flags: 0x0},
	299:  {region: 0xa3, script: 0x52, flags: 0x0},
	300:  {region: 0x7f, script: 0x52, flags: 0x0},
	301:  {region: 0xd5, script: 0x52, flags: 0x0},
	302:  {region: 0x9d, script: 0x52, flags: 0x0},
	303:  {region: 0x6a, script: 0x25, flags: 0x0},
	304:  {region: 0xc3, script: 0x43, flags: 0x0},
	305:  {region: 0x86, script: 0x2d, flags: 0x0},
	306:  {region: 0x164, script: 0x52, flags: 0x0},
	307:  {region: 0x164, script: 0x52, flags: 0x0},
	308:  {region: 0xc, script: 0x2, flags: 0x1},
	309:  {region: 0x164, script: 0x52, flags: 0x0},
	310:  {region: 0x164, script: 0x52, flags: 0x0},
	311:  {region: 0x1, script: 0x52, flags: 0x0},
	312:  {region: 0x164, script: 0x52, flags: 0x0},
	313:  {region: 0x6d, script: 0x52, flags: 0x0},
	314:  {region: 0x134, script: 0x52, flags: 0x0},
	315:  {region: 0x69, script: 0x52, flags: 0x0},
	316:  {region: 0x164, script: 0x52, flags: 0x0},
	317:  {region: 0x9d, script: 0x3e, flags: 0x0},
	318:  {region: 0x164, script: 0x52, flags: 0x0},
	319:  {region: 0x164, script: 0x52, flags: 0x0},
	320:  {region: 0x6d, script: 0x52, flags: 0x0},
	321:  {region: 0x51, script: 0x52, flags: 0x0},
	322:  {region: 0x6d, script: 0x52, flags: 0x0},
	323:  {region: 0x9b, script: 0x5, flags: 0x0},
	324:  {region: 0x164, script: 0x52, flags: 0x0},
	325:  {region: 0x164, script: 0x52, flags: 0x0},
	326:  {region: 0x164, script: 0x52, flags: 0x0},
	327:  {region: 0x164, script: 0x52, flags: 0x0},
	328:  {region: 0x85, script: 0x52, flags: 0x0},
	329:  {region: 0xe, script: 0x2, flags: 0x1},
	330:  {region: 0x164, script: 0x52, flags: 0x0},
	331:  {region: 0xc2, script: 0x52, flags: 0x0},
	332:  {region: 0x71, script: 0x52, flags: 0x0},
	333:  {region: 0x10a, script: 0x5, flags: 0x0},
	334:  {region: 0xe6, script: 0x52, flags: 0x0},
	335:  {region: 0x10b, script: 0x52, flags: 0x0},
	336:  {region: 0x72, script: 0x52, flags: 0x0},
	337:  {region: 0x164, script: 0x52, flags: 0x0},
	338:  {region: 0x164, script: 0x52, flags: 0x0},
	339:  {region: 0x75, script: 0x52, flags: 0x0},
	340:  {region: 0x164, script: 0x52, flags: 0x0},
	341:  {region: 0x3a, script: 0x52, flags: 0x0},
	342:  {region: 0x164, script: 0x52, flags: 0x0},
	343:  {region: 0x164, script: 0x52, flags: 0x0},
	344:  {region: 0x164, script: 0x52, flags: 0x0},
	345:  {region: 0x77, script: 0x52, flags: 0x0},
	346:  {region: 0x134, script: 0x52, flags: 0x0},
	347:  {region: 0x77, script: 0x52, flags: 0x0},
	348:  {region: 0x5f, script: 0x52, flags: 0x0},
	349:  {region: 0x5f, script: 0x52, flags: 0x0},
	350:  {region: 0x51, script: 0x5, flags: 0x0},
	351:  {region: 0x13f, script: 0x52, flags: 0x0},
	352:  {region: 0x164, script: 0x52, flags: 0x0},
	353:  {region: 0x83, script: 0x52, flags: 0x0},
	354:  {region: 0x164, script: 0x52, flags: 0x0},
	355:  {region: 0xd3, script: 0x52, flags: 0x0},
	356:  {region: 0x9d, script: 0x52, flags: 0x0},
	357:  {region: 0xd5, script: 0x52, flags: 0x0},
	358:  {region: 0x164, script: 0x52, flags: 0x0},
	359:  {region: 0x10a, script: 0x52, flags: 0x0},
	360:  {region: 0xd8, script: 0x52, flags: 0x0},
	361:  {region: 0x95, script: 0x52, flags: 0x0},
	362:  {region: 0x7f, script: 0x52, flags: 0x0},
	363:  {region: 0x164, script: 0x52, flags: 0x0},
	364:  {region: 0xbb, script: 0x52, flags: 0x0},
	365:  {region: 0x164, script: 0x52, flags: 0x0},
	366:  {region: 0x164, script: 0x52, flags: 0x0},
	367:  {region: 0x164, script: 0x52, flags: 0x0},
	368:  {region: 0x52, script: 0x34, flags: 0x0},
	369:  {region: 0x164, script: 0x52, flags: 0x0},
	370:  {region: 0x94, script: 0x52, flags: 0x0},
	371:  {region: 0x164, script: 0x52, flags: 0x0},
	372:  {region: 0x98, script: 0x20, flags: 0x0},
	373:  {region: 0x164, script: 0x52, flags: 0x0},
	374:  {region: 0x9b, script: 0x5, flags: 0x0},
	375:  {region: 0x7d, script: 0x52, flags: 0x0},
	376:  {region: 0x7a, script: 0x52, flags: 0x0},
	377:  {region: 0x164, script: 0x52, flags: 0x0},
	378:  {region: 0x164, script: 0x52, flags: 0x0},
	379:  {region: 0x164, script: 0x52, flags: 0x0},
	380:  {region: 0x164, script: 0x52, flags: 0x0},
	381:  {region: 0x164, script: 0x52, flags: 0x0},
	382:  {region: 0x164, script: 0x52, flags: 0x0},
	383:  {region: 0x6e, script: 0x27, flags: 0x0},
	384:  {region: 0x164, script: 0x52, flags: 0x0},
	385:  {region: 0xda, script: 0x20, flags: 0x0},
	386:  {region: 0x164, script: 0x52, flags: 0x0},
	387:  {region: 0xa6, script: 0x52, flags: 0x0},
	388:  {region: 0x164, script: 0x52, flags: 0x0},
	389:  {region: 0xe7, script: 0x5, flags: 0x0},
	390:  {region: 0x164, script: 0x52, flags: 0x0},
	391:  {region: 0xe7, script: 0x5, flags: 0x0},
	392:  {region: 0x164, script: 0x52, flags: 0x0},
	393:  {region: 0x164, script: 0x52, flags: 0x0},
	394:  {region: 0x6d, script: 0x52, flags: 0x0},
	395:  {region: 0x9b, script: 0x5, flags: 0x0},
	396:  {region: 0x164, script: 0x52, flags: 0x0},
	397:  {region: 0x164, script: 0x27, flags: 0x0},
	398:  {region: 0xf0, script: 0x52, flags: 0x0},
	399:  {region: 0x164, script: 0x52, flags: 0x0},
	400:  {region: 0x164, script: 0x52, flags: 0x0},
	401:  {region: 0x164, script: 0x52, flags: 0x0},
	402:  {region: 0x164, script: 0x27, flags: 0x0},
	403:  {region: 0x164, script: 0x52, flags: 0x0},
	404:  {region: 0x98, script: 0x20, flags: 0x0},
	405:  {region: 0x98, script: 0xd0, flags: 0x0},
	406:  {region: 0x94, script: 0x52, flags: 0x0},
	407:  {region: 0xd8, script: 0x52, flags: 0x0},
	408:  {region: 0x12f, script: 0x2b, flags: 0x0},
	409:  {region: 0x10, script: 0x2, flags: 0x1},
	410:  {region: 0x98, script: 0xe, flags: 0x0},
	411:  {region: 0x164, script: 0x52, flags: 0x0},
	412:  {region: 0x4d, script: 0x52, flags: 0x0},
	413:  {region: 0x98, script: 0x2e, flags: 0x0},
	414:  {region: 0x40, script: 0x52, flags: 0x0},
	415:  {region: 0x53, script: 0x52, flags: 0x0},
	416:  {region: 0x164, script: 0x52, flags: 0x0},
	417:  {region: 0x7f, script: 0x52, flags: 0x0},
	418:  {region: 0x164, script: 0x52, flags: 0x0},
	419:  {region: 0x164, script: 0x52, flags: 0x0},
	420:  {region: 0xa3, script: 0x52, flags: 0x0},
	421:  {region: 0x97, script: 0x52, flags: 0x0},
	422:  {region: 0x164, script: 0x52, flags: 0x0},
	423:  {region: 0xda, script: 0x20, flags: 0x0},
	424:  {region: 0x164, script: 0x52, flags: 0x0},
	425:  {region: 0x164, script: 0x5, flags: 0x0},
	426:  {region: 0x48, script: 0x52, flags: 0x0},
	427:  {region: 0x164, script: 0x5, flags: 0x0},
	428:  {region: 0x164, script: 0x52, flags: 0x0},
	429:  {region: 0x12, script: 0x3, flags: 0x1},
	430:  {region: 0x164, script: 0x52, flags: 0x0},
	431:  {region: 0x52, script: 0x34, flags: 0x0},
	432:  {region: 0x164, script: 0x52, flags: 0x0},
	433:  {region: 0x134, script: 0x52, flags: 0x0},
	434:  {region: 0x23, script: 0x5, flags: 0x0},
	435:  {region: 0x164, script: 0x52, flags: 0x0},
	436:  {region: 0x164, script: 0x27, flags: 0x0},
	437:  {region: 0x96, script: 0x37, flags: 0x0},
	438:  {region: 0x164, script: 0x52, flags: 0x0},
	439:  {region: 0x98, script: 0x20, flags: 0x0},
	440:  {region: 0x164, script: 0x52, flags: 0x0},
	441:  {region: 0x72, script: 0x52, flags: 0x0},
	442:  {region: 0x164, script: 0x52, flags: 0x0},
	443:  {region: 0x164, script: 0x52, flags: 0x0},
	444:  {region: 0xe6, script: 0x52, flags: 0x0},
	445:  {region: 0x164, script: 0x52, flags: 0x0},
	446:  {region: 0x12a, script: 0x39, flags: 0x0},
	447:  {region: 0x52, script: 0x81, flags: 0x0},
	448:  {region: 0x164, script: 0x52, flags: 0x0},
	449:  {region: 0xe7, script: 0x5, flags: 0x0},
	450:  {region: 0x98, script: 0x20, flags: 0x0},
	451:  {region: 0xae, script: 0x3a, flags: 0x0},
	452:  {region: 0xe6, script: 0x52, flags: 0x0},
	453:  {region: 0xe7, script: 0x5, flags: 0x0},
	454:  {region: 0xe5, script: 0x52, flags: 0x0},
	455:  {region: 0x98, script: 0x20, flags: 0x0},
	456:  {region: 0x98, script: 0x20, flags: 0x0},
	457:  {region: 0x164, script: 0x52, flags: 0x0},
	458:  {region: 0x8f, script: 0x52, flags: 0x0},
	459:  {region: 0x5f, script: 0x52, flags: 0x0},
	460:  {region: 0x52, script: 0x34, flags: 0x0},
	461:  {region: 0x90, script: 0x52, flags: 0x0},
	462:  {region: 0x91, script: 0x52, flags: 0x0},
	463:  {region: 0x164, script: 0x52, flags: 0x0},
	464:  {region: 0x27, script: 0x8, flags: 0x0},
	465:  {region: 0xd1, script: 0x52, flags: 0x0},
	466:  {region: 0x77, script: 0x52, flags: 0x0},
	467:  {region: 0x164, script: 0x52, flags: 0x0},
	468:  {region: 0x164, script: 0x52, flags: 0x0},
	469:  {region: 0xcf, script: 0x52, flags: 0x0},
	470:  {region: 0xd5, script: 0x52, flags: 0x0},
	471:  {region: 0x164, script: 0x52, flags: 0x0},
	472:  {region: 0x164, script: 0x52, flags: 0x0},
	473:  {region: 0x164, script: 0x52, flags: 0x0},
	474:  {region: 0x94, script: 0x52, flags: 0x0},
	475:  {region: 0x164, script: 0x52, flags: 0x0},
	476:  {region: 0x164, script: 0x52, flags: 0x0},
	477:  {region: 0x164, script: 0x52, flags: 0x0},
	479:  {region: 0xd5, script: 0x52, flags: 0x0},
	480:  {region: 0x164, script: 0x52, flags: 0x0},
	481:  {region: 0x164, script: 0x52, flags: 0x0},
	482:  {region: 0x52, script: 0xdf, flags: 0x0},
	483:  {region: 0x164, script: 0x52, flags: 0x0},
	484:  {region: 0x134, script: 0x52, flags: 0x0},
	485:  {region: 0x164, script: 0x52, flags: 0x0},
	486:  {region: 0x48, script: 0x52, flags: 0x0},
	487:  {region: 0x164, script: 0x52, flags: 0x0},
	488:  {region: 0x164, script: 0x52, flags: 0x0},
	489:  {region: 0xe6, script: 0x52, flags: 0x0},
	490:  {region: 0x164, script: 0x52, flags: 0x0},
	491:  {region: 0x94, script: 0x52, flags: 0x0},
	492:  {region: 0x105, script: 0x1e, flags: 0x0},
	494:  {region: 0x164, script: 0x52, flags: 0x0},
	495:  {region: 0x164, script: 0x52, flags: 0x0},
	496:  {region: 0x9c, script: 0x52, flags: 0x0},
	497:  {region: 0x9d, script: 0x52, flags: 0x0},
	498:  {region: 0x48, script: 0x17, flags: 0x0},
	499:  {region: 0x96, script: 0x37, flags: 0x0},
	500:  {region: 0x164, script: 0x52, flags: 0x0},
	501:  {region: 0x164, script: 0x52, flags: 0x0},
	502:  {region: 0x105, script: 0x52, flags: 0x0},
	503:  {region: 0x164, script: 0x52, flags: 0x0},
	504:  {region: 0xa1, script: 0x41, flags: 0x0},
	505:  {region: 0x164, script: 0x52, flags: 0x0},
	506:  {region: 0x9f, script: 0x52, flags: 0x0},
	508:  {region: 0x164, script: 0x52, flags: 0x0},
	509:  {region: 0x164, script: 0x52, flags: 0x0},
	510:  {region: 0x164, script: 0x52, flags: 0x0},
	511:  {region: 0x51, script: 0x52, flags: 0x0},
	512:  {region: 0x12f, script: 0x37, flags: 0x0},
	513:  {region: 0x164, script: 0x52, flags: 0x0},
	514:  {region: 0x12e, script: 0x52, flags: 0x0},
	515:  {region: 0xda, script: 0x20, flags: 0x0},
	516:  {region: 0x164, script: 0x52, flags: 0x0},
	517:  {region: 0x62, script: 0x52, flags: 0x0},
	518:  {region: 0x94, script: 0x52, flags: 0x0},
	519:  {region: 0x94, script: 0x52, flags: 0x0},
	520:  {region: 0x7c, script: 0x29, flags: 0x0},
	521:  {region: 0x136, script: 0x1e, flags: 0x0},
	522:  {region: 0x66, script: 0x52, flags: 0x0},
	523:  {region: 0xc3, script: 0x52, flags: 0x0},
	524:  {region: 0x164, script: 0x52, flags: 0x0},
	525:  {region: 0x164, script: 0x52, flags: 0x0},
	526:  {region: 0xd5, script: 0x52, flags: 0x0},
	527:  {region: 0xa3, script: 0x52, flags: 0x0},
	528:  {region: 0xc2, script: 0x52, flags: 0x0},
	529:  {region: 0x105, script: 0x1e, flags: 0x0},
	530:  {region: 0x164, script: 0x52, flags: 0x0},
	531:  {region: 0x164, script: 0x52, flags: 0x0},
	532:  {region: 0x164, script: 0x52, flags: 0x0},
	533:  {region: 0x164, script: 0x52, flags: 0x0},
	534:  {region: 0xd3, script: 0x5, flags: 0x0},
	535:  {region: 0xd5, script: 0x52, flags: 0x0},
	536:  {region: 0x163, script: 0x52, flags: 0x0},
	537:  {region: 0x164, script: 0x52, flags: 0x0},
	538:  {region: 0x164, script: 0x52, flags: 0x0},
	539:  {region: 0x12e, script: 0x52, flags: 0x0},
	540:  {region: 0x121, script: 0x5, flags: 0x0},
	541:  {region: 0x164, script: 0x52, flags: 0x0},
	542:  {region: 0x122, script: 0xd5, flags: 0x0},
	543:  {region: 0x59, script: 0x52, flags: 0x0},
	544:  {region: 0x51, script: 0x52, flags: 0x0},
	545:  {region: 0x164, script: 0x52, flags: 0x0},
	546:  {region: 0x4e, script: 0x52, flags: 0x0},
	547:  {region: 0x98, script: 0x20, flags: 0x0},
	548:  {region: 0x98, script: 0x20, flags: 0x0},
	549:  {region: 0x4a, script: 0x52, flags: 0x0},
	550:  {region: 0x94, script: 0x52, flags: 0x0},
	551:  {region: 0x164, script: 0x52, flags: 0x0},
	552:  {region: 0x40, script: 0x52, flags: 0x0},
	553:  {region: 0x98, script: 0x52, flags: 0x0},
	554:  {region: 0x52, script: 0xcc, flags: 0x0},
	555:  {region: 0x98, script: 0x20, flags: 0x0},
	556:  {region: 0xc2, script: 0x52, flags: 0x0},
	557:  {region: 0x164, script: 0x52, flags: 0x0},
	558:  {region: 0x98, script: 0x6b, flags: 0x0},
	559:  {region: 0xe7, script: 0x5, flags: 0x0},
	560:  {region: 0x164, script: 0x52, flags: 0x0},
	561:  {region: 0xa3, script: 0x52, flags: 0x0},
	562:  {region: 0x164, script: 0x52, flags: 0x0},
	563:  {region: 0x12a, script: 0x52, flags: 0x0},
	564:  {region: 0x164, script: 0x52, flags: 0x0},
	565:  {region: 0xd1, script: 0x52, flags: 0x0},
	566:  {region: 0x164, script: 0x52, flags: 0x0},
	567:  {region: 0xae, script: 0x4f, flags: 0x0},
	568:  {region: 0x164, script: 0x52, flags: 0x0},
	569:  {region: 0x164, script: 0x52, flags: 0x0},
	570:  {region: 0x15, script: 0x6, flags: 0x1},
	571:  {region: 0x164, script: 0x52, flags: 0x0},
	572:  {region: 0x51, script: 0x52, flags: 0x0},
	573:  {region: 0x81, script: 0x52, flags: 0x0},
	574:  {region: 0xa3, script: 0x52, flags: 0x0},
	575:  {region: 0x164, script: 0x52, flags: 0x0},
	576:  {region: 0x164, script: 0x52, flags: 0x0},
	577:  {region: 0x164, script: 0x52, flags: 0x0},
	578:  {region: 0xa5, script: 0x46, flags: 0x0},
	579:  {region: 0x29, script: 0x52, flags: 0x0},
	580:  {region: 0x164, script: 0x52, flags: 0x0},
	581:  {region: 0x164, script: 0x52, flags: 0x0},
	582:  {region: 0x164, script: 0x52, flags: 0x0},
	583:  {region: 0x164, script: 0x52, flags: 0x0},
	584:  {region: 0x164, script: 0x52, flags: 0x0},
	585:  {region: 0x98, script: 0x4a, flags: 0x0},
	586:  {region: 0x164, script: 0x52, flags: 0x0},
	587:  {region: 0xaa, script: 0x4b, flags: 0x0},
	588:  {region: 0x105, script: 0x1e, flags: 0x0},
	589:  {region: 0x98, script: 0x20, flags: 0x0},
	590:  {region: 0x164, script: 0x52, flags: 0x0},
	591:  {region: 0x74, script: 0x52, flags: 0x0},
	592:  {region: 0x164, script: 0x52, flags: 0x0},
	593:  {region: 0xb3, script: 0x52, flags: 0x0},
	594:  {region: 0x164, script: 0x52, flags: 0x0},
	595:  {region: 0x164, script: 0x52, flags: 0x0},
	596:  {region: 0x164, script: 0x52, flags: 0x0},
	597:  {region: 0x164, script: 0x52, flags: 0x0},
	598:  {region: 0x164, script: 0x52, flags: 0x0},
	599:  {region: 0x164, script: 0x52, flags: 0x0},
	600:  {region: 0x164, script: 0x52, flags: 0x0},
	601:  {region: 0x164, script: 0x27, flags: 0x0},
	603:  {region: 0x105, script: 0x1e, flags: 0x0},
	604:  {region: 0x111, script: 0x52, flags: 0x0},
	605:  {region: 0xe6, script: 0x52, flags: 0x0},
	606:  {region: 0x105, script: 0x52, flags: 0x0},
	607:  {region: 0x164, script: 0x52, flags: 0x0},
	608:  {region: 0x98, script: 0x20, flags: 0x0},
	609:  {region: 0x98, script: 0x5, flags: 0x0},
	610:  {region: 0x12e, script: 0x52, flags: 0x0},
	611:  {region: 0x164, script: 0x52, flags: 0x0},
	612:  {region: 0x51, script: 0x52, flags: 0x0},
	613:  {region: 0x5f, script: 0x52, flags: 0x0},
	614:  {region: 0x164, script: 0x52, flags: 0x0},
	615:  {region: 0x164, script: 0x52, flags: 0x0},
	616:  {region: 0x164, script: 0x27, flags: 0x0},
	617:  {region: 0x164, script: 0x52, flags: 0x0},
	618:  {region: 0x164, script: 0x52, flags: 0x0},
	619:  {region: 0x1b, script: 0x3, flags: 0x1},
	620:  {region: 0x164, script: 0x52, flags: 0x0},
	621:  {region: 0x164, script: 0x52, flags: 0x0},
	622:  {region: 0x164, script: 0x52, flags: 0x0},
	623:  {region: 0x164, script: 0x52, flags: 0x0},
	624:  {region: 0x105, script: 0x1e, flags: 0x0},
	625:  {region: 0x164, script: 0x52, flags: 0x0},
	626:  {region: 0x164, script: 0x52, flags: 0x0},
	627:  {region: 0x164, script: 0x52, flags: 0x0},
	628:  {region: 0x105, script: 0x1e, flags: 0x0},
	629:  {region: 0x164, script: 0x52, flags: 0x0},
	630:  {region: 0x94, script: 0x52, flags: 0x0},
	631:  {region: 0xe7, script: 0x5, flags: 0x0},
	632:  {region: 0x7a, script: 0x52, flags: 0x0},
	633:  {region: 0x164, script: 0x52, flags: 0x0},
	634:  {region: 0x164, script: 0x52, flags: 0x0},
	635:  {region: 0x164, script: 0x52, flags: 0x0},
	636:  {region: 0x164, script: 0x27, flags: 0x0},
	637:  {region: 0x122, script: 0xd5, flags: 0x0},
	638:  {region: 0xe7, script: 0x5, flags: 0x0},
	639:  {region: 0x164, script: 0x52, flags: 0x0},
	640:  {region: 0x164, script: 0x52, flags: 0x0},
	641:  {region: 0x1e, script: 0x5, flags: 0x1},
	642:  {region: 0x164, script: 0x52, flags: 0x0},
	643:  {region: 0x164, script: 0x52, flags: 0x0},
	644:  {region: 0x164, script: 0x52, flags: 0x0},
	645:  {region: 0x137, script: 0x52, flags: 0x0},
	646:  {region: 0x86, script: 0x56, flags: 0x0},
	647:  {region: 0x96, script: 0x37, flags: 0x0},
	648:  {region: 0x12e, script: 0x52, flags: 0x0},
	649:  {region: 0xe7, script: 0x5, flags: 0x0},
	650:  {region: 0x130, script: 0x52, flags: 0x0},
	651:  {region: 0x164, script: 0x52, flags: 0x0},
	652:  {region: 0xb6, script: 0x52, flags: 0x0},
	653:  {region: 0x105, script: 0x1e, flags: 0x0},
	654:  {region: 0x164, script: 0x52, flags: 0x0},
	655:  {region: 0x94, script: 0x52, flags: 0x0},
	656:  {region: 0x164, script: 0x52, flags: 0x0},
	657:  {region: 0x52, script: 0xd5, flags: 0x0},
	658:  {region: 0x164, script: 0x52, flags: 0x0},
	659:  {region: 0x164, script: 0x52, flags: 0x0},
	660:  {region: 0x164, script: 0x52, flags: 0x0},
	661:  {region: 0x164, script: 0x52, flags: 0x0},
	662:  {region: 0x98, script: 0x54, flags: 0x0},
	663:  {region: 0x164, script: 0x52, flags: 0x0},
	664:  {region: 0x164, script: 0x52, flags: 0x0},
	665:  {region: 0x105, script: 0x1e, flags: 0x0},
	666:  {region: 0x130, script: 0x52, flags: 0x0},
	667:  {region: 0x164, script: 0x52, flags: 0x0},
	668:  {region: 0xd8, script: 0x52, flags: 0x0},
	669:  {region: 0x164, script: 0x52, flags: 0x0},
	670:  {region: 0x164, script: 0x52, flags: 0x0},
	671:  {region: 0x23, script: 0x2, flags: 0x1},
	672:  {region: 0x164, script: 0x52, flags: 0x0},
	673:  {region: 0x164, script: 0x52, flags: 0x0},
	674:  {region: 0x9d, script: 0x52, flags: 0x0},
	675:  {region: 0x52, script: 0x58, flags: 0x0},
	676:  {region: 0x94, script: 0x52, flags: 0x0},
	677:  {region: 0x9b, script: 0x5, flags: 0x0},
	678:  {region: 0x134, script: 0x52, flags: 0x0},
	679:  {region: 0x164, script: 0x52, flags: 0x0},
	680:  {region: 0x164, script: 0x52, flags: 0x0},
	681:  {region: 0x98, script: 0xd0, flags: 0x0},
	682:  {region: 0x9d, script: 0x52, flags: 0x0},
	683:  {region: 0x164, script: 0x52, flags: 0x0},
	684:  {region: 0x4a, script: 0x52, flags: 0x0},
	685:  {region: 0x164, script: 0x52, flags: 0x0},
	686:  {region: 0x164, script: 0x52, flags: 0x0},
	687:  {region: 0xae, script: 0x4f, flags: 0x0},
	688:  {region: 0x164, script: 0x52, flags: 0x0},
	689:  {region: 0x164, script: 0x52, flags: 0x0},
	690:  {region: 0x4a, script: 0x52, flags: 0x0},
	691:  {region: 0x164, script: 0x52, flags: 0x0},
	692:  {region: 0x164, script: 0x52, flags: 0x0},
	693:  {region: 0x161, script: 0x52, flags: 0x0},
	694:  {region: 0x9b, script: 0x5, flags: 0x0},
	695:  {region: 0xb5, script: 0x52, flags: 0x0},
	696:  {region: 0xb7, script: 0x52, flags: 0x0},
	697:  {region: 0x4a, script: 0x52, flags: 0x0},
	698:  {region: 0x4a, script: 0x52, flags: 0x0},
	699:  {region: 0xa3, script: 0x52, flags: 0x0},
	700:  {region: 0xa3, script: 0x52, flags: 0x0},
	701:  {region: 0x9b, script: 0x5, flags: 0x0},
	702:  {region: 0xb7, script: 0x52, flags: 0x0},
	703:  {region: 0x122, script: 0xd5, flags: 0x0},
	704:  {region: 0x52, script: 0x34, flags: 0x0},
	705:  {region: 0x12a, script: 0x52, flags: 0x0},
	706:  {region: 0x94, script: 0x52, flags: 0x0},
	707:  {region: 0x51, script: 0x52, flags: 0x0},
	708:  {region: 0x98, script: 0x20, flags: 0x0},
	709:  {region: 0x98, script: 0x20, flags: 0x0},
	710:  {region: 0x94, script: 0x52, flags: 0x0},
	711:  {region: 0x25, script: 0x3, flags: 0x1},
	712:  {region: 0xa3, script: 0x52, flags: 0x0},
	713:  {region: 0x164, script: 0x52, flags: 0x0},
	714:  {region: 0xce, script: 0x52, flags: 0x0},
	715:  {region: 0x164, script: 0x52, flags: 0x0},
	716:  {region: 0x164, script: 0x52, flags: 0x0},
	717:  {region: 0x164, script: 0x52, flags: 0x0},
	718:  {region: 0x164, script: 0x52, flags: 0x0},
	719:  {region: 0x164, script: 0x52, flags: 0x0},
	720:  {region: 0x164, script: 0x52, flags: 0x0},
	721:  {region: 0x164, script: 0x52, flags: 0x0},
	722:  {region: 0x164, script: 0x52, flags: 0x0},
	723:  {region: 0x164, script: 0x52, flags: 0x0},
	724:  {region: 0x164, script: 0x52, flags: 0x0},
	725:  {region: 0x164, script: 0x52, flags: 0x0},
	726:  {region: 0x164, script: 0x5, flags: 0x0},
	727:  {region: 0x105, script: 0x1e, flags: 0x0},
	728:  {region: 0xe6, script: 0x52, flags: 0x0},
	729:  {region: 0x164, script: 0x52, flags: 0x0},
	730:  {region: 0x94, script: 0x52, flags: 0x0},
	731:  {region: 0x164, script: 0x27, flags: 0x0},
	732:  {region: 0x164, script: 0x52, flags: 0x0},
	733:  {region: 0x164, script: 0x52, flags: 0x0},
	734:  {region: 0x164, script: 0x52, flags: 0x0},
	735:  {region: 0x111, script: 0x52, flags: 0x0},
	736:  {region: 0xa3, script: 0x52, flags: 0x0},
	737:  {region: 0x164, script: 0x52, flags: 0x0},
	738:  {region: 0x164, script: 0x52, flags: 0x0},
	739:  {region: 0x122, script: 0x5, flags: 0x0},
	740:  {region: 0xcb, script: 0x52, flags: 0x0},
	741:  {region: 0x164, script: 0x52, flags: 0x0},
	742:  {region: 0x164, script: 0x52, flags: 0x0},
	743:  {region: 0x164, script: 0x52, flags: 0x0},
	744:  {region: 0xbe, script: 0x52, flags: 0x0},
	745:  {region: 0xd0, script: 0x52, flags: 0x0},
	746:  {region: 0x164, script: 0x52, flags: 0x0},
	747:  {region: 0x51, script: 0x52, flags: 0x0},
	748:  {region: 0xda, script: 0x20, flags: 0x0},
	749:  {region: 0x12e, script: 0x52, flags: 0x0},
	750:  {region: 0xbf, script: 0x52, flags: 0x0},
	751:  {region: 0x164, script: 0x52, flags: 0x0},
	752:  {region: 0x164, script: 0x52, flags: 0x0},
	753:  {region: 0xdf, script: 0x52, flags: 0x0},
	754:  {region: 0x164, script: 0x52, flags: 0x0},
	755:  {region: 0x94, script: 0x52, flags: 0x0},
	756:  {region: 0x9a, script: 0x36, flags: 0x0},
	757:  {region: 0x164, script: 0x52, flags: 0x0},
	758:  {region: 0xc1, script: 0x1e, flags: 0x0},
	759:  {region: 0x164, script: 0x5, flags: 0x0},
	760:  {region: 0x164, script: 0x52, flags: 0x0},
	761:  {region: 0x164, script: 0x52, flags: 0x0},
	762:  {region: 0x164, script: 0x52, flags: 0x0},
	763:  {region: 0x98, script: 0x64, flags: 0x0},
	764:  {region: 0x164, script: 0x52, flags: 0x0},
	765:  {region: 0x164, script: 0x52, flags: 0x0},
	766:  {region: 0x10a, script: 0x52, flags: 0x0},
	767:  {region: 0x164, script: 0x52, flags: 0x0},
	768:  {region: 0x164, script: 0x52, flags: 0x0},
	769:  {region: 0x164, script: 0x52, flags: 0x0},
	770:  {region: 0x28, script: 0x3, flags: 0x1},
	771:  {region: 0x164, script: 0x52, flags: 0x0},
	772:  {region: 0x164, script: 0x52, flags: 0x0},
	773:  {region: 0x98, script: 0xe, flags: 0x0},
	774:  {region: 0xc3, script: 0x6b, flags: 0x0},
	776:  {region: 0x164, script: 0x52, flags: 0x0},
	777:  {region: 0x48, script: 0x52, flags: 0x0},
	778:  {region: 0x48, script: 0x52, flags: 0x0},
	779:  {region: 0x36, script: 0x52, flags: 0x0},
	780:  {region: 0x164, script: 0x52, flags: 0x0},
	781:  {region: 0x164, script: 0x52, flags: 0x0},
	782:  {region: 0x164, script: 0x52, flags: 0x0},
	783:  {region: 0x164, script: 0x52, flags: 0x0},
	784:  {region: 0x164, script: 0x52, flags: 0x0},
	785:  {region: 0x164, script: 0x52, flags: 0x0},
	786:  {region: 0x98, script: 0x20, flags: 0x0},
	787:  {region: 0xda, script: 0x20, flags: 0x0},
	788:  {region: 0x105, script: 0x1e, flags: 0x0},
	789:  {region: 0x34, script: 0x68, flags: 0x0},
	790:  {region: 0x2b, script: 0x3, flags: 0x1},
	791:  {region: 0xca, script: 0x52, flags: 0x0},
	792:  {region: 0x164, script: 0x52, flags: 0x0},
	793:  {region: 0x164, script: 0x52, flags: 0x0},
	794:  {region: 0x164, script: 0x52, flags: 0x0},
	795:  {region: 0x98, script: 0x20, flags: 0x0},
	796:  {region: 0x51, script: 0x52, flags: 0x0},
	798:  {region: 0x164, script: 0x52, flags: 0x0},
	799:  {region: 0x134, script: 0x52, flags: 0x0},
	800:  {region: 0x164, script: 0x52, flags: 0x0},
	801:  {region: 0x164, script: 0x52, flags: 0x0},
	802:  {region: 0xe7, script: 0x5, flags: 0x0},
	803:  {region: 0xc2, script: 0x52, flags: 0x0},
	804:  {region: 0x98, script: 0x20, flags: 0x0},
	805:  {region: 0x94, script: 0x52, flags: 0x0},
	806:  {region: 0x163, script: 0x52, flags: 0x0},
	807:  {region: 0x164, script: 0x52, flags: 0x0},
	808:  {region: 0xc3, script: 0x6b, flags: 0x0},
	809:  {region: 0x164, script: 0x52, flags: 0x0},
	810:  {region: 0x164, script: 0x27, flags: 0x0},
	811:  {region: 0x105, script: 0x1e, flags: 0x0},
	812:  {region: 0x164, script: 0x52, flags: 0x0},
	813:  {region: 0x130, script: 0x52, flags: 0x0},
	814:  {region: 0x9b, script: 0x5d, flags: 0x0},
	815:  {region: 0x164, script: 0x52, flags: 0x0},
	816:  {region: 0x164, script: 0x52, flags: 0x0},
	817:  {region: 0x9b, script: 0x5, flags: 0x0},
	818:  {region: 0x164, script: 0x52, flags: 0x0},
	819:  {region: 0x164, script: 0x52, flags: 0x0},
	820:  {region: 0x164, script: 0x52, flags: 0x0},
	821:  {region: 0xdc, script: 0x52, flags: 0x0},
	822:  {region: 0x164, script: 0x52, flags: 0x0},
	823:  {region: 0x164, script: 0x52, flags: 0x0},
	825:  {region: 0x164, script: 0x52, flags: 0x0},
	826:  {region: 0x52, script: 0x34, flags: 0x0},
	827:  {region: 0x9d, script: 0x52, flags: 0x0},
	828:  {region: 0xd1, script: 0x52, flags: 0x0},
	829:  {region: 0x164, script: 0x52, flags: 0x0},
	830:  {region: 0xd9, script: 0x52, flags: 0x0},
	831:  {region: 0x164, script: 0x52, flags: 0x0},
	832:  {region: 0x164, script: 0x52, flags: 0x0},
	833:  {region: 0x164, script: 0x52, flags: 0x0},
	834:  {region: 0xce, script: 0x52, flags: 0x0},
	835:  {region: 0x164, script: 0x52, flags: 0x0},
	836:  {region: 0x164, script: 0x52, flags: 0x0},
	837:  {region: 0x163, script: 0x52, flags: 0x0},
	838:  {region: 0xd0, script: 0x52, flags: 0x0},
	839:  {region: 0x5f, script: 0x52, flags: 0x0},
	840:  {region: 0xda, script: 0x20, flags: 0x0},
	841:  {region: 0x164, script: 0x52, flags: 0x0},
	842:  {region: 0xda, script: 0x20, flags: 0x0},
	843:  {region: 0x164, script: 0x52, flags: 0x0},
	844:  {region: 0x164, script: 0x52, flags: 0x0},
	845:  {region: 0xd1, script: 0x52, flags: 0x0},
	846:  {region: 0x164, script: 0x52, flags: 0x0},
	847:  {region: 0x164, script: 0x52, flags: 0x0},
	848:  {region: 0xd0, script: 0x52, flags: 0x0},
	849:  {region: 0x164, script: 0x52, flags: 0x0},
	850:  {region: 0xce, script: 0x52, flags: 0x0},
	851:  {region: 0xce, script: 0x52, flags: 0x0},
	852:  {region: 0x164, script: 0x52, flags: 0x0},
	853:  {region: 0x164, script: 0x52, flags: 0x0},
	854:  {region: 0x94, script: 0x52, flags: 0x0},
	855:  {region: 0x164, script: 0x52, flags: 0x0},
	856:  {region: 0xde, script: 0x52, flags: 0x0},
	857:  {region: 0x164, script: 0x52, flags: 0x0},
	858:  {region: 0x164, script: 0x52, flags: 0x0},
	859:  {region: 0x98, script: 0x52, flags: 0x0},
	860:  {region: 0x164, script: 0x52, flags: 0x0},
	861:  {region: 0x164, script: 0x52, flags: 0x0},
	862:  {region: 0xd8, script: 0x52, flags: 0x0},
	863:  {region: 0x51, script: 0x52, flags: 0x0},
	864:  {region: 0x164, script: 0x52, flags: 0x0},
	865:  {region: 0xd9, script: 0x52, flags: 0x0},
	866:  {region: 0x164, script: 0x52, flags: 0x0},
	867:  {region: 0x51, script: 0x52, flags: 0x0},
	868:  {region: 0x164, script: 0x52, flags: 0x0},
	869:  {region: 0x164, script: 0x52, flags: 0x0},
	870:  {region: 0xd9, script: 0x52, flags: 0x0},
	871:  {region: 0x122, script: 0x4e, flags: 0x0},
	872:  {region: 0x98, script: 0x20, flags: 0x0},
	873:  {region: 0x10b, script: 0xb7, flags: 0x0},
	874:  {region: 0x164, script: 0x52, flags: 0x0},
	875:  {region: 0x164, script: 0x52, flags: 0x0},
	876:  {region: 0x83, script: 0x70, flags: 0x0},
	877:  {region: 0x160, script: 0x52, flags: 0x0},
	878:  {region: 0x164, script: 0x52, flags: 0x0},
	879:  {region: 0x48, script: 0x17, flags: 0x0},
	880:  {region: 0x164, script: 0x52, flags: 0x0},
	881:  {region: 0x160, script: 0x52, flags: 0x0},
	882:  {region: 0x164, script: 0x52, flags: 0x0},
	883:  {region: 0x164, script: 0x52, flags: 0x0},
	884:  {region: 0x164, script: 0x52, flags: 0x0},
	885:  {region: 0x164, script: 0x52, flags: 0x0},
	886:  {region: 0x164, script: 0x52, flags: 0x0},
	887:  {region: 0x116, script: 0x52, flags: 0x0},
	888:  {region: 0x164, script: 0x52, flags: 0x0},
	889:  {region: 0x164, script: 0x52, flags: 0x0},
	890:  {region: 0x134, script: 0x52, flags: 0x0},
	891:  {region: 0x164, script: 0x52, flags: 0x0},
	892:  {region: 0x52, script: 0x52, flags: 0x0},
	893:  {region: 0x164, script: 0x52, flags: 0x0},
	894:  {region: 0xcd, script: 0x52, flags: 0x0},
	895:  {region: 0x12e, script: 0x52, flags: 0x0},
	896:  {region: 0x130, script: 0x52, flags: 0x0},
	897:  {region: 0x7f, script: 0x52, flags: 0x0},
	898:  {region: 0x77, script: 0x52, flags: 0x0},
	899:  {region: 0x164, script: 0x52, flags: 0x0},
	901:  {region: 0x164, script: 0x52, flags: 0x0},
	902:  {region: 0x164, script: 0x52, flags: 0x0},
	903:  {region: 0x6e, script: 0x52, flags: 0x0},
	904:  {region: 0x164, script: 0x52, flags: 0x0},
	905:  {region: 0x164, script: 0x52, flags: 0x0},
	906:  {region: 0x164, script: 0x52, flags: 0x0},
	907:  {region: 0x164, script: 0x52, flags: 0x0},
	908:  {region: 0x98, script: 0x75, flags: 0x0},
	909:  {region: 0x164, script: 0x52, flags: 0x0},
	910:  {region: 0x164, script: 0x5, flags: 0x0},
	911:  {region: 0x7c, script: 0x1e, flags: 0x0},
	912:  {region: 0x134, script: 0x76, flags: 0x0},
	913:  {region: 0x164, script: 0x5, flags: 0x0},
	914:  {region: 0xc4, script: 0x74, flags: 0x0},
	915:  {region: 0x164, script: 0x52, flags: 0x0},
	916:  {region: 0x2e, script: 0x3, flags: 0x1},
	917:  {region: 0xe6, script: 0x52, flags: 0x0},
	918:  {region: 0x31, script: 0x2, flags: 0x1},
	919:  {region: 0xe6, script: 0x52, flags: 0x0},
	920:  {region: 0x2f, script: 0x52, flags: 0x0},
	921:  {region: 0xef, script: 0x52, flags: 0x0},
	922:  {region: 0x164, script: 0x52, flags: 0x0},
	923:  {region: 0x77, script: 0x52, flags: 0x0},
	924:  {region: 0xd5, script: 0x52, flags: 0x0},
	925:  {region: 0x134, script: 0x52, flags: 0x0},
	926:  {region: 0x48, script: 0x52, flags: 0x0},
	927:  {region: 0x164, script: 0x52, flags: 0x0},
	928:  {region: 0x9b, script: 0xdd, flags: 0x0},
	929:  {region: 0x164, script: 0x52, flags: 0x0},
	930:  {region: 0x5f, script: 0x52, flags: 0x0},
	931:  {region: 0x164, script: 0x5, flags: 0x0},
	932:  {region: 0xaf, script: 0x7f, flags: 0x0},
	934:  {region: 0x164, script: 0x52, flags: 0x0},
	935:  {region: 0x164, script: 0x52, flags: 0x0},
	936:  {region: 0x98, script: 0x12, flags: 0x0},
	937:  {region: 0xa3, script: 0x52, flags: 0x0},
	938:  {region: 0xe8, script: 0x52, flags: 0x0},
	939:  {region: 0x164, script: 0x52, flags: 0x0},
	940:  {region: 0x9d, script: 0x52, flags: 0x0},
	941:  {region: 0x164, script: 0x52, flags: 0x0},
	942:  {region: 0x164, script: 0x52, flags: 0x0},
	943:  {region: 0x86, script: 0x2d, flags: 0x0},
	944:  {region: 0x74, script: 0x52, flags: 0x0},
	945:  {region: 0x164, script: 0x52, flags: 0x0},
	946:  {region: 0xe7, script: 0x45, flags: 0x0},
	947:  {region: 0x9b, script: 0x5, flags: 0x0},
	948:  {region: 0x1, script: 0x52, flags: 0x0},
	949:  {region: 0x23, script: 0x5, flags: 0x0},
	950:  {region: 0x164, script: 0x52, flags: 0x0},
	951:  {region: 0x40, script: 0x52, flags: 0x0},
	952:  {region: 0x164, script: 0x52, flags: 0x0},
	953:  {region: 0x79, script: 0x52, flags: 0x0},
	954:  {region: 0x164, script: 0x52, flags: 0x0},
	955:  {region: 0xe3, script: 0x52, flags: 0x0},
	956:  {region: 0x88, script: 0x52, flags: 0x0},
	957:  {region: 0x68, script: 0x52, flags: 0x0},
	958:  {region: 0x164, script: 0x52, flags: 0x0},
	959:  {region: 0x98, script: 0x20, flags: 0x0},
	960:  {region: 0x164, script: 0x52, flags: 0x0},
	961:  {region: 0x101, script: 0x52, flags: 0x0},
	962:  {region: 0x94, script: 0x52, flags: 0x0},
	963:  {region: 0x164, script: 0x52, flags: 0x0},
	964:  {region: 0x164, script: 0x52, flags: 0x0},
	965:  {region: 0x9d, script: 0x52, flags: 0x0},
	966:  {region: 0x164, script: 0x5, flags: 0x0},
	967:  {region: 0x98, script: 0x52, flags: 0x0},
	968:  {region: 0x33, script: 0x2, flags: 0x1},
	969:  {region: 0xda, script: 0x20, flags: 0x0},
	970:  {region: 0x34, script: 0xe, flags: 0x0},
	971:  {region: 0x4d, script: 0x52, flags: 0x0},
	972:  {region: 0x71, script: 0x52, flags: 0x0},
	973:  {region: 0x4d, script: 0x52, flags: 0x0},
	974:  {region: 0x9b, script: 0x5, flags: 0x0},
	975:  {region: 0x10b, script: 0x52, flags: 0x0},
	976:  {region: 0x39, script: 0x52, flags: 0x0},
	977:  {region: 0x164, script: 0x52, flags: 0x0},
	978:  {region: 0xd0, script: 0x52, flags: 0x0},
	979:  {region: 0x103, script: 0x52, flags: 0x0},
	980:  {region: 0x94, script: 0x52, flags: 0x0},
	981:  {region: 0x12e, script: 0x52, flags: 0x0},
	982:  {region: 0x164, script: 0x52, flags: 0x0},
	983:  {region: 0x164, script: 0x52, flags: 0x0},
	984:  {region: 0x72, script: 0x52, flags: 0x0},
	985:  {region: 0x105, script: 0x1e, flags: 0x0},
	986:  {region: 0x12f, script: 0x1e, flags: 0x0},
	987:  {region: 0x108, script: 0x52, flags: 0x0},
	988:  {region: 0x106, script: 0x52, flags: 0x0},
	989:  {region: 0x12e, script: 0x52, flags: 0x0},
	990:  {region: 0x164, script: 0x52, flags: 0x0},
	991:  {region: 0xa1, script: 0x44, flags: 0x0},
	992:  {region: 0x98, script: 0x20, flags: 0x0},
	993:  {region: 0x7f, script: 0x52, flags: 0x0},
	994:  {region: 0x105, script: 0x1e, flags: 0x0},
	995:  {region: 0xa3, script: 0x52, flags: 0x0},
	996:  {region: 0x94, script: 0x52, flags: 0x0},
	997:  {region: 0x98, script: 0x52, flags: 0x0},
	998:  {region: 0x98, script: 0xbb, flags: 0x0},
	999:  {region: 0x164, script: 0x52, flags: 0x0},
	1000: {region: 0x164, script: 0x52, flags: 0x0},
	1001: {region: 0x12e, script: 0x52, flags: 0x0},
	1002: {region: 0x9d, script: 0x52, flags: 0x0},
	1003: {region: 0x98, script: 0x20, flags: 0x0},
	1004: {region: 0x164, script: 0x5, flags: 0x0},
	1005: {region: 0x9d, script: 0x52, flags: 0x0},
	1006: {region: 0x7a, script: 0x52, flags: 0x0},
	1007: {region: 0x48, script: 0x52, flags: 0x0},
	1008: {region: 0x35, script: 0x4, flags: 0x1},
	1009: {region: 0x9d, script: 0x52, flags: 0x0},
	1010: {region: 0x9b, script: 0x5, flags: 0x0},
	1011: {region: 0xd9, script: 0x52, flags: 0x0},
	1012: {region: 0x4e, script: 0x52, flags: 0x0},
	1013: {region: 0xd0, script: 0x52, flags: 0x0},
	1014: {region: 0xce, script: 0x52, flags: 0x0},
	1015: {region: 0xc2, script: 0x52, flags: 0x0},
	1016: {region: 0x4b, script: 0x52, flags: 0x0},
	1017: {region: 0x95, script: 0x72, flags: 0x0},
	1018: {region: 0xb5, script: 0x52, flags: 0x0},
	1019: {region: 0x164, script: 0x27, flags: 0x0},
	1020: {region: 0x164, script: 0x52, flags: 0x0},
	1022: {region: 0xb9, script: 0xd2, flags: 0x0},
	1023: {region: 0x164, script: 0x52, flags: 0x0},
	1024: {region: 0xc3, script: 0x6b, flags: 0x0},
	1025: {region: 0x164, script: 0x5, flags: 0x0},
	1026: {region: 0xb2, script: 0xc1, flags: 0x0},
	1027: {region: 0x6e, script: 0x52, flags: 0x0},
	1028: {region: 0x164, script: 0x52, flags: 0x0},
	1029: {region: 0x164, script: 0x52, flags: 0x0},
	1030: {region: 0x164, script: 0x52, flags: 0x0},
	1031: {region: 0x164, script: 0x52, flags: 0x0},
	1032: {region: 0x110, script: 0x52, flags: 0x0},
	1033: {region: 0x164, script: 0x52, flags: 0x0},
	1034: {region: 0xe7, script: 0x5, flags: 0x0},
	1035: {region: 0x164, script: 0x52, flags: 0x0},
	1036: {region: 0x10e, script: 0x52, flags: 0x0},
	1037: {region: 0x164, script: 0x52, flags: 0x0},
	1038: {region: 0xe8, script: 0x52, flags: 0x0},
	1039: {region: 0x164, script: 0x52, flags: 0x0},
	1040: {region: 0x94, script: 0x52, flags: 0x0},
	1041: {region: 0x141, script: 0x52, flags: 0x0},
	1042: {region: 0x10b, script: 0x52, flags: 0x0},
	1044: {region: 0x10b, script: 0x52, flags: 0x0},
	1045: {region: 0x71, script: 0x52, flags: 0x0},
	1046: {region: 0x96, script: 0xb8, flags: 0x0},
	1047: {region: 0x164, script: 0x52, flags: 0x0},
	1048: {region: 0x71, script: 0x52, flags: 0x0},
	1049: {region: 0x163, script: 0x52, flags: 0x0},
	1050: {region: 0x164, script: 0x52, flags: 0x0},
	1051: {region: 0xc2, script: 0x52, flags: 0x0},
	1052: {region: 0x164, script: 0x52, flags: 0x0},
	1053: {region: 0x164, script: 0x52, flags: 0x0},
	1054: {region: 0x164, script: 0x52, flags: 0x0},
	1055: {region: 0x114, script: 0x52, flags: 0x0},
	1056: {region: 0x164, script: 0x52, flags: 0x0},
	1057: {region: 0x164, script: 0x52, flags: 0x0},
	1058: {region: 0x122, script: 0xd5, flags: 0x0},
	1059: {region: 0x164, script: 0x52, flags: 0x0},
	1060: {region: 0x164, script: 0x52, flags: 0x0},
	1061: {region: 0x164, script: 0x52, flags: 0x0},
	1062: {region: 0x164, script: 0x52, flags: 0x0},
	1063: {region: 0x26, script: 0x52, flags: 0x0},
	1064: {region: 0x39, script: 0x5, flags: 0x1},
	1065: {region: 0x98, script: 0xc2, flags: 0x0},
	1066: {region: 0x115, script: 0x52, flags: 0x0},
	1067: {region: 0x113, script: 0x52, flags: 0x0},
	1068: {region: 0x98, script: 0x20, flags: 0x0},
	1069: {region: 0x160, script: 0x52, flags: 0x0},
	1070: {region: 0x164, script: 0x52, flags: 0x0},
	1071: {region: 0x164, script: 0x52, flags: 0x0},
	1072: {region: 0x6c, script: 0x52, flags: 0x0},
	1073: {region: 0x160, script: 0x52, flags: 0x0},
	1074: {region: 0x164, script: 0x52, flags: 0x0},
	1075: {region: 0x5f, script: 0x52, flags: 0x0},
	1076: {region: 0x94, script: 0x52, flags: 0x0},
	1077: {region: 0x164, script: 0x52, flags: 0x0},
	1078: {region: 0x164, script: 0x52, flags: 0x0},
	1079: {region: 0x12e, script: 0x52, flags: 0x0},
	1080: {region: 0x164, script: 0x52, flags: 0x0},
	1081: {region: 0x83, script: 0x52, flags: 0x0},
	1082: {region: 0x10b, script: 0x52, flags: 0x0},
	1083: {region: 0x12e, script: 0x52, flags: 0x0},
	1084: {region: 0x15e, script: 0x5, flags: 0x0},
	1085: {region: 0x4a, script: 0x52, flags: 0x0},
	1086: {region: 0x5f, script: 0x52, flags: 0x0},
	1087: {region: 0x164, script: 0x52, flags: 0x0},
	1088: {region: 0x98, script: 0x20, flags: 0x0},
	1089: {region: 0x94, script: 0x52, flags: 0x0},
	1090: {region: 0x164, script: 0x52, flags: 0x0},
	1091: {region: 0x34, script: 0xe, flags: 0x0},
	1092: {region: 0x9a, script: 0xc5, flags: 0x0},
	1093: {region: 0xe8, script: 0x52, flags: 0x0},
	1094: {region: 0x98, script: 0xcd, flags: 0x0},
	1095: {region: 0xda, script: 0x20, flags: 0x0},
	1096: {region: 0x164, script: 0x52, flags: 0x0},
	1097: {region: 0x164, script: 0x52, flags: 0x0},
	1098: {region: 0x164, script: 0x52, flags: 0x0},
	1099: {region: 0x164, script: 0x52, flags: 0x0},
	1100: {region: 0x164, script: 0x52, flags: 0x0},
	1101: {region: 0x164, script: 0x52, flags: 0x0},
	1102: {region: 0x164, script: 0x52, flags: 0x0},
	1103: {region: 0x164, script: 0x52, flags: 0x0},
	1104: {region: 0xe6, script: 0x52, flags: 0x0},
	1105: {region: 0x164, script: 0x52, flags: 0x0},
	1106: {region: 0x164, script: 0x52, flags: 0x0},
	1107: {region: 0x98, script: 0x4a, flags: 0x0},
	1108: {region: 0x52, script: 0xcb, flags: 0x0},
	1109: {region: 0xda, script: 0x20, flags: 0x0},
	1110: {region: 0xda, script: 0x20, flags: 0x0},
	1111: {region: 0x98, script: 0xd0, flags: 0x0},
	1112: {region: 0x164, script: 0x52, flags: 0x0},
	1113: {region: 0x111, script: 0x52, flags: 0x0},
	1114: {region: 0x130, script: 0x52, flags: 0x0},
	1115: {region: 0x125, script: 0x52, flags: 0x0},
	1116: {region: 0x164, script: 0x52, flags: 0x0},
	1117: {region: 0x3e, script: 0x3, flags: 0x1},
	1118: {region: 0x164, script: 0x52, flags: 0x0},
	1119: {region: 0x164, script: 0x52, flags: 0x0},
	1120: {region: 0x164, script: 0x52, flags: 0x0},
	1121: {region: 0x122, script: 0xd5, flags: 0x0},
	1122: {region: 0xda, script: 0x20, flags: 0x0},
	1123: {region: 0xda, script: 0x20, flags: 0x0},
	1124: {region: 0xda, script: 0x20, flags: 0x0},
	1125: {region: 0x6e, script: 0x27, flags: 0x0},
	1126: {region: 0x164, script: 0x52, flags: 0x0},
	1127: {region: 0x6c, script: 0x27, flags: 0x0},
	1128: {region: 0x164, script: 0x52, flags: 0x0},
	1129: {region: 0x164, script: 0x52, flags: 0x0},
	1130: {region: 0x164, script: 0x52, flags: 0x0},
	1131: {region: 0xd5, script: 0x52, flags: 0x0},
	1132: {region: 0x126, script: 0x52, flags: 0x0},
	1133: {region: 0x124, script: 0x52, flags: 0x0},
	1134: {region: 0x31, script: 0x52, flags: 0x0},
	1135: {region: 0xda, script: 0x20, flags: 0x0},
	1136: {region: 0xe6, script: 0x52, flags: 0x0},
	1137: {region: 0x164, script: 0x52, flags: 0x0},
	1138: {region: 0x164, script: 0x52, flags: 0x0},
	1139: {region: 0x31, script: 0x52, flags: 0x0},
	1140: {region: 0xd3, script: 0x52, flags: 0x0},
	1141: {region: 0x164, script: 0x52, flags: 0x0},
	1142: {region: 0x160, script: 0x52, flags: 0x0},
	1143: {region: 0x164, script: 0x52, flags: 0x0},
	1144: {region: 0x128, script: 0x52, flags: 0x0},
	1145: {region: 0x164, script: 0x52, flags: 0x0},
	1146: {region: 0xcd, script: 0x52, flags: 0x0},
	1147: {region: 0x164, script: 0x52, flags: 0x0},
	1148: {region: 0xe5, script: 0x52, flags: 0x0},
	1149: {region: 0x164, script: 0x52, flags: 0x0},
	1150: {region: 0x164, script: 0x52, flags: 0x0},
	1151: {region: 0x164, script: 0x52, flags: 0x0},
	1152: {region: 0x12a, script: 0x52, flags: 0x0},
	1153: {region: 0x12a, script: 0x52, flags: 0x0},
	1154: {region: 0x12d, script: 0x52, flags: 0x0},
	1155: {region: 0x164, script: 0x5, flags: 0x0},
	1156: {region: 0x160, script: 0x52, flags: 0x0},
	1157: {region: 0x86, script: 0x2d, flags: 0x0},
	1158: {region: 0xda, script: 0x20, flags: 0x0},
	1159: {region: 0xe6, script: 0x52, flags: 0x0},
	1160: {region: 0x42, script: 0xd6, flags: 0x0},
	1161: {region: 0x164, script: 0x52, flags: 0x0},
	1162: {region: 0x105, script: 0x1e, flags: 0x0},
	1163: {region: 0x164, script: 0x52, flags: 0x0},
	1164: {region: 0x164, script: 0x52, flags: 0x0},
	1165: {region: 0x130, script: 0x52, flags: 0x0},
	1166: {region: 0x164, script: 0x52, flags: 0x0},
	1167: {region: 0x122, script: 0xd5, flags: 0x0},
	1168: {region: 0x31, script: 0x52, flags: 0x0},
	1169: {region: 0x164, script: 0x52, flags: 0x0},
	1170: {region: 0x164, script: 0x52, flags: 0x0},
	1171: {region: 0xcd, script: 0x52, flags: 0x0},
	1172: {region: 0x164, script: 0x52, flags: 0x0},
	1173: {region: 0x164, script: 0x52, flags: 0x0},
	1174: {region: 0x12c, script: 0x52, flags: 0x0},
	1175: {region: 0x164, script: 0x52, flags: 0x0},
	1177: {region: 0x164, script: 0x52, flags: 0x0},
	1178: {region: 0xd3, script: 0x52, flags: 0x0},
	1179: {region: 0x52, script: 0xce, flags: 0x0},
	1180: {region: 0xe4, script: 0x52, flags: 0x0},
	1181: {region: 0x164, script: 0x52, flags: 0x0},
	1182: {region: 0x105, script: 0x1e, flags: 0x0},
	1183: {region: 0xb9, script: 0x52, flags: 0x0},
	1184: {region: 0x164, script: 0x52, flags: 0x0},
	1185: {region: 0x105, script: 0x1e, flags: 0x0},
	1186: {region: 0x41, script: 0x4, flags: 0x1},
	1187: {region: 0x11b, script: 0xd8, flags: 0x0},
	1188: {region: 0x12f, script: 0x1e, flags: 0x0},
	1189: {region: 0x74, script: 0x52, flags: 0x0},
	1190: {region: 0x29, script: 0x52, flags: 0x0},
	1192: {region: 0x45, script: 0x3, flags: 0x1},
	1193: {region: 0x98, script: 0xe, flags: 0x0},
	1194: {region: 0xe7, script: 0x5, flags: 0x0},
	1195: {region: 0x164, script: 0x52, flags: 0x0},
	1196: {region: 0x164, script: 0x52, flags: 0x0},
	1197: {region: 0x164, script: 0x52, flags: 0x0},
	1198: {region: 0x164, script: 0x52, flags: 0x0},
	1199: {region: 0x164, script: 0x52, flags: 0x0},
	1200: {region: 0x164, script: 0x52, flags: 0x0},
	1201: {region: 0x164, script: 0x52, flags: 0x0},
	1202: {region: 0x48, script: 0x4, flags: 0x1},
	1203: {region: 0x164, script: 0x52, flags: 0x0},
	1204: {region: 0xb3, script: 0xd9, flags: 0x0},
	1205: {region: 0x164, script: 0x52, flags: 0x0},
	1206: {region: 0x160, script: 0x52, flags: 0x0},
	1207: {region: 0x9d, script: 0x52, flags: 0x0},
	1208: {region: 0x105, script: 0x52, flags: 0x0},
	1209: {region: 0x13d, script: 0x52, flags: 0x0},
	1210: {region: 0x11a, script: 0x52, flags: 0x0},
	1211: {region: 0x164, script: 0x52, flags: 0x0},
	1212: {region: 0x35, script: 0x52, flags: 0x0},
	1213: {region: 0x5f, script: 0x52, flags: 0x0},
	1214: {region: 0xd0, script: 0x52, flags: 0x0},
	1215: {region: 0x1, script: 0x52, flags: 0x0},
	1216: {region: 0x105, script: 0x52, flags: 0x0},
	1217: {region: 0x69, script: 0x52, flags: 0x0},
	1218: {region: 0x12e, script: 0x52, flags: 0x0},
	1219: {region: 0x164, script: 0x52, flags: 0x0},
	1220: {region: 0x35, script: 0x52, flags: 0x0},
	1221: {region: 0x4d, script: 0x52, flags: 0x0},
	1222: {region: 0x164, script: 0x52, flags: 0x0},
	1223: {region: 0x6e, script: 0x27, flags: 0x0},
	1224: {region: 0x164, script: 0x52, flags: 0x0},
	1225: {region: 0xe6, script: 0x52, flags: 0x0},
	1226: {region: 0x2e, script: 0x52, flags: 0x0},
	1227: {region: 0x98, script: 0xd0, flags: 0x0},
	1228: {region: 0x98, script: 0x20, flags: 0x0},
	1229: {region: 0x164, script: 0x52, flags: 0x0},
	1230: {region: 0x164, script: 0x52, flags: 0x0},
	1231: {region: 0x164, script: 0x52, flags: 0x0},
	1232: {region: 0x164, script: 0x52, flags: 0x0},
	1233: {region: 0x164, script: 0x52, flags: 0x0},
	1234: {region: 0x164, script: 0x52, flags: 0x0},
	1235: {region: 0x164, script: 0x52, flags: 0x0},
	1236: {region: 0x164, script: 0x52, flags: 0x0},
	1237: {region: 0x164, script: 0x52, flags: 0x0},
	1238: {region: 0x13f, script: 0x52, flags: 0x0},
	1239: {region: 0x164, script: 0x52, flags: 0x0},
	1240: {region: 0x164, script: 0x52, flags: 0x0},
	1241: {region: 0xa7, script: 0x5, flags: 0x0},
	1242: {region: 0x164, script: 0x52, flags: 0x0},
	1243: {region: 0x113, script: 0x52, flags: 0x0},
	1244: {region: 0x164, script: 0x52, flags: 0x0},
	1245: {region: 0x164, script: 0x52, flags: 0x0},
	1246: {region: 0x164, script: 0x52, flags: 0x0},
	1247: {region: 0x164, script: 0x52, flags: 0x0},
	1248: {region: 0x98, script: 0x20, flags: 0x0},
	1249: {region: 0x52, script: 0x34, flags: 0x0},
	1250: {region: 0x164, script: 0x52, flags: 0x0},
	1251: {region: 0x164, script: 0x52, flags: 0x0},
	1252: {region: 0x40, script: 0x52, flags: 0x0},
	1253: {region: 0x164, script: 0x52, flags: 0x0},
	1254: {region: 0x12a, script: 0x18, flags: 0x0},
	1255: {region: 0x164, script: 0x52, flags: 0x0},
	1256: {region: 0x160, script: 0x52, flags: 0x0},
	1257: {region: 0x164, script: 0x52, flags: 0x0},
	1258: {region: 0x12a, script: 0x5a, flags: 0x0},
	1259: {region: 0x12a, script: 0x5b, flags: 0x0},
	1260: {region: 0x7c, script: 0x29, flags: 0x0},
	1261: {region: 0x52, script: 0x5e, flags: 0x0},
	1262: {region: 0x10a, script: 0x62, flags: 0x0},
	1263: {region: 0x107, script: 0x6c, flags: 0x0},
	1264: {region: 0x98, script: 0x20, flags: 0x0},
	1265: {region: 0x130, script: 0x52, flags: 0x0},
	1266: {region: 0x164, script: 0x52, flags: 0x0},
	1267: {region: 0x9b, script: 0x82, flags: 0x0},
	1268: {region: 0x164, script: 0x52, flags: 0x0},
	1269: {region: 0x15d, script: 0xba, flags: 0x0},
	1270: {region: 0x164, script: 0x52, flags: 0x0},
	1271: {region: 0x164, script: 0x52, flags: 0x0},
	1272: {region: 0xda, script: 0x20, flags: 0x0},
	1273: {region: 0x164, script: 0x52, flags: 0x0},
	1274: {region: 0x164, script: 0x52, flags: 0x0},
	1275: {region: 0xd0, script: 0x52, flags: 0x0},
	1276: {region: 0x74, script: 0x52, flags: 0x0},
	1277: {region: 0x164, script: 0x52, flags: 0x0},
	1278: {region: 0x164, script: 0x52, flags: 0x0},
	1279: {region: 0x51, script: 0x52, flags: 0x0},
	1280: {region: 0x164, script: 0x52, flags: 0x0},
	1281: {region: 0x164, script: 0x52, flags: 0x0},
	1282: {region: 0x164, script: 0x52, flags: 0x0},
	1283: {region: 0x51, script: 0x52, flags: 0x0},
	1284: {region: 0x164, script: 0x52, flags: 0x0},
	1285: {region: 0x164, script: 0x52, flags: 0x0},
	1286: {region: 0x164, script: 0x52, flags: 0x0},
	1287: {region: 0x164, script: 0x52, flags: 0x0},
	1288: {region: 0x1, script: 0x37, flags: 0x0},
	1289: {region: 0x164, script: 0x52, flags: 0x0},
	1290: {region: 0x164, script: 0x52, flags: 0x0},
	1291: {region: 0x164, script: 0x52, flags: 0x0},
	1292: {region: 0x164, script: 0x52, flags: 0x0},
	1293: {region: 0x164, script: 0x52, flags: 0x0},
	1294: {region: 0xd5, script: 0x52, flags: 0x0},
	1295: {region: 0x164, script: 0x52, flags: 0x0},
	1296: {region: 0x164, script: 0x52, flags: 0x0},
	1297: {region: 0x164, script: 0x52, flags: 0x0},
	1298: {region: 0x40, script: 0x52, flags: 0x0},
	1299: {region: 0x164, script: 0x52, flags: 0x0},
	1300: {region: 0xce, script: 0x52, flags: 0x0},
	1301: {region: 0x4c, script: 0x3, flags: 0x1},
	1302: {region: 0x164, script: 0x52, flags: 0x0},
	1303: {region: 0x164, script: 0x52, flags: 0x0},
	1304: {region: 0x164, script: 0x52, flags: 0x0},
	1305: {region: 0x52, script: 0x52, flags: 0x0},
	1306: {region: 0x10a, script: 0x52, flags: 0x0},
	1308: {region: 0xa7, script: 0x5, flags: 0x0},
	1309: {region: 0xd8, script: 0x52, flags: 0x0},
	1310: {region: 0xb9, script: 0xd2, flags: 0x0},
	1311: {region: 0x4f, script: 0x14, flags: 0x1},
	1312: {region: 0x164, script: 0x52, flags: 0x0},
	1313: {region: 0x121, script: 0x52, flags: 0x0},
	1314: {region: 0xcf, script: 0x52, flags: 0x0},
	1315: {region: 0x164, script: 0x52, flags: 0x0},
	1316: {region: 0x160, script: 0x52, flags: 0x0},
	1318: {region: 0x12a, script: 0x52, flags: 0x0},
}

// likelyLangList holds lists info associated with likelyLang.
// Size: 396 bytes, 99 elements
var likelyLangList = [99]likelyScriptRegion{
	0:  {region: 0x9b, script: 0x7, flags: 0x0},
	1:  {region: 0xa0, script: 0x6d, flags: 0x2},
	2:  {region: 0x11b, script: 0x78, flags: 0x2},
	3:  {region: 0x31, script: 0x52, flags: 0x0},
	4:  {region: 0x9a, script: 0x5, flags: 0x4},
	5:  {region: 0x9b, script: 0x5, flags: 0x4},
	6:  {region: 0x105, script: 0x1e, flags: 0x4},
	7:  {region: 0x9b, script: 0x5, flags: 0x2},
	8:  {region: 0x98, script: 0xe, flags: 0x0},
	9:  {region: 0x34, script: 0x16, flags: 0x2},
	10: {region: 0x105, script: 0x1e, flags: 0x0},
	11: {region: 0x37, script: 0x2a, flags: 0x2},
	12: {region: 0x134, script: 0x52, flags: 0x0},
	13: {region: 0x7a, script: 0xbd, flags: 0x2},
	14: {region: 0x113, script: 0x52, flags: 0x0},
	15: {region: 0x83, script: 0x1, flags: 0x2},
	16: {region: 0x5c, script: 0x1d, flags: 0x0},
	17: {region: 0x86, script: 0x57, flags: 0x2},
	18: {region: 0xd5, script: 0x52, flags: 0x0},
	19: {region: 0x51, script: 0x5, flags: 0x4},
	20: {region: 0x10a, script: 0x5, flags: 0x4},
	21: {region: 0xad, script: 0x1e, flags: 0x0},
	22: {region: 0x23, script: 0x5, flags: 0x4},
	23: {region: 0x52, script: 0x5, flags: 0x4},
	24: {region: 0x9b, script: 0x5, flags: 0x4},
	25: {region: 0xc4, script: 0x5, flags: 0x4},
	26: {region: 0x52, script: 0x5, flags: 0x2},
	27: {region: 0x12a, script: 0x52, flags: 0x0},
	28: {region: 0xaf, script: 0x5, flags: 0x4},
	29: {region: 0x9a, script: 0x5, flags: 0x2},
	30: {region: 0xa4, script: 0x1e, flags: 0x0},
	31: {region: 0x52, script: 0x5, flags: 0x4},
	32: {region: 0x12a, script: 0x52, flags: 0x4},
	33: {region: 0x52, script: 0x5, flags: 0x2},
	34: {region: 0x12a, script: 0x52, flags: 0x2},
	35: {region: 0xda, script: 0x20, flags: 0x0},
	36: {region: 0x98, script: 0x55, flags: 0x2},
	37: {region: 0x82, script: 0x52, flags: 0x0},
	38: {region: 0x83, script: 0x70, flags: 0x4},
	39: {region: 0x83, script: 0x70, flags: 0x2},
	40: {region: 0xc4, script: 0x1e, flags: 0x0},
	41: {region: 0x52, script: 0x66, flags: 0x4},
	42: {region: 0x52, script: 0x66, flags: 0x2},
	43: {region: 0xcf, script: 0x52, flags: 0x0},
	44: {region: 0x49, script: 0x5, flags: 0x4},
	45: {region: 0x94, script: 0x5, flags: 0x4},
	46: {region: 0x98, script: 0x2f, flags: 0x0},
	47: {region: 0xe7, script: 0x5, flags: 0x4},
	48: {region: 0xe7, script: 0x5, flags: 0x2},
	49: {region: 0x9b, script: 0x7c, flags: 0x0},
	50: {region: 0x52, script: 0x7d, flags: 0x2},
	51: {region: 0xb9, script: 0xd2, flags: 0x0},
	52: {region: 0xd8, script: 0x52, flags: 0x4},
	53: {region: 0xe7, script: 0x5, flags: 0x0},
	54: {region: 0x98, script: 0x20, flags: 0x2},
	55: {region: 0x98, script: 0x47, flags: 0x2},
	56: {region: 0x98, script: 0xc0, flags: 0x2},
	57: {region: 0x104, script: 0x1e, flags: 0x0},
	58: {region: 0xbc, script: 0x52, flags: 0x4},
	59: {region: 0x103, script: 0x52, flags: 0x4},
	60: {region: 0x105, script: 0x52, flags: 0x4},
	61: {region: 0x12a, script: 0x52, flags: 0x4},
	62: {region: 0x123, script: 0x1e, flags: 0x0},
	63: {region: 0xe7, script: 0x5, flags: 0x4},
	64: {region: 0xe7, script: 0x5, flags: 0x2},
	65: {region: 0x52, script: 0x5, flags: 0x0},
	66: {region: 0xad, script: 0x1e, flags: 0x4},
	67: {region: 0xc4, script: 0x1e, flags: 0x4},
	68: {region: 0xad, script: 0x1e, flags: 0x2},
	69: {region: 0x98, script: 0xe, flags: 0x0},
	70: {region: 0xda, script: 0x20, flags: 0x4},
	71: {region: 0xda, script: 0x20, flags: 0x2},
	72: {region: 0x136, script: 0x52, flags: 0x0},
	73: {region: 0x23, script: 0x5, flags: 0x4},
	74: {region: 0x52, script: 0x1e, flags: 0x4},
	75: {region: 0x23, script: 0x5, flags: 0x2},
	76: {region: 0x8c, script: 0x35, flags: 0x0},
	77: {region: 0x52, script: 0x34, flags: 0x4},
	78: {region: 0x52, script: 0x34, flags: 0x2},
	79: {region: 0x52, script: 0x34, flags: 0x0},
	80: {region: 0x2e, script: 0x35, flags: 0x4},
	81: {region: 0x3d, script: 0x35, flags: 0x4},
	82: {region: 0x7a, script: 0x35, flags: 0x4},
	83: {region: 0x7d, script: 0x35, flags: 0x4},
	84: {region: 0x8c, script: 0x35, flags: 0x4},
	85: {region: 0x94, script: 0x35, flags: 0x4},
	86: {region: 0xc5, script: 0x35, flags: 0x4},
	87: {region: 0xcf, script: 0x35, flags: 0x4},
	88: {region: 0xe1, script: 0x35, flags: 0x4},
	89: {region: 0xe4, script: 0x35, flags: 0x4},
	90: {region: 0xe6, script: 0x35, flags: 0x4},
	91: {region: 0x115, script: 0x35, flags: 0x4},
	92: {region: 0x122, script: 0x35, flags: 0x4},
	93: {region: 0x12d, script: 0x35, flags: 0x4},
	94: {region: 0x134, script: 0x35, flags: 0x4},
	95: {region: 0x13d, script: 0x35, flags: 0x4},
	96: {region: 0x12d, script: 0x11, flags: 0x2},
	97: {region: 0x12d, script: 0x30, flags: 0x2},
	98: {region: 0x12d, script: 0x35, flags: 0x2},
}

type likelyLangScript struct {
	lang   uint16
	script uint8
	flags  uint8
}

// likelyRegion is a lookup table, indexed by regionID, for the most likely
// languages and scripts given incomplete information. If more entries exist
// for a given regionID, lang and script are the index and size respectively
// of the list in likelyRegionList.
// TODO: exclude containers and user-definable regions from the list.
// Size: 1428 bytes, 357 elements
var likelyRegion = [357]likelyLangScript{
	33:  {lang: 0xd5, script: 0x52, flags: 0x0},
	34:  {lang: 0x39, script: 0x5, flags: 0x0},
	35:  {lang: 0x0, script: 0x2, flags: 0x1},
	38:  {lang: 0x2, script: 0x2, flags: 0x1},
	39:  {lang: 0x4, script: 0x2, flags: 0x1},
	41:  {lang: 0x3b7, script: 0x52, flags: 0x0},
	42:  {lang: 0x0, script: 0x52, flags: 0x0},
	43:  {lang: 0x139, script: 0x52, flags: 0x0},
	44:  {lang: 0x411, script: 0x52, flags: 0x0},
	45:  {lang: 0x109, script: 0x52, flags: 0x0},
	47:  {lang: 0x35e, script: 0x52, flags: 0x0},
	48:  {lang: 0x43a, script: 0x52, flags: 0x0},
	49:  {lang: 0x57, script: 0x52, flags: 0x0},
	50:  {lang: 0x6, script: 0x2, flags: 0x1},
	52:  {lang: 0xa3, script: 0xe, flags: 0x0},
	53:  {lang: 0x35e, script: 0x52, flags: 0x0},
	54:  {lang: 0x159, script: 0x52, flags: 0x0},
	55:  {lang: 0x7d, script: 0x1e, flags: 0x0},
	56:  {lang: 0x39, script: 0x5, flags: 0x0},
	57:  {lang: 0x3d0, script: 0x52, flags: 0x0},
	58:  {lang: 0x159, script: 0x52, flags: 0x0},
	59:  {lang: 0x159, script: 0x52, flags: 0x0},
	61:  {lang: 0x316, script: 0x52, flags: 0x0},
	62:  {lang: 0x139, script: 0x52, flags: 0x0},
	63:  {lang: 0x398, script: 0x52, flags: 0x0},
	64:  {lang: 0x3b7, script: 0x52, flags: 0x0},
	66:  {lang: 0x8, script: 0x2, flags: 0x1},
	68:  {lang: 0x0, script: 0x52, flags: 0x0},
	70:  {lang: 0x70, script: 0x1e, flags: 0x0},
	72:  {lang: 0x508, script: 0x37, flags: 0x2},
	73:  {lang: 0x316, script: 0x5, flags: 0x2},
	74:  {lang: 0x43b, script: 0x52, flags: 0x0},
	75:  {lang: 0x159, script: 0x52, flags: 0x0},
	76:  {lang: 0x159, script: 0x52, flags: 0x0},
	77:  {lang: 0x109, script: 0x52, flags: 0x0},
	78:  {lang: 0x159, script: 0x52, flags: 0x0},
	80:  {lang: 0x139, script: 0x52, flags: 0x0},
	81:  {lang: 0x159, script: 0x52, flags: 0x0},
	82:  {lang: 0xa, script: 0x5, flags: 0x1},
	83:  {lang: 0x139, script: 0x52, flags: 0x0},
	84:  {lang: 0x0, script: 0x52, flags: 0x0},
	85:  {lang: 0x139, script: 0x52, flags: 0x0},
	88:  {lang: 0x139, script: 0x52, flags: 0x0},
	89:  {lang: 0x3b7, script: 0x52, flags: 0x0},
	90:  {lang: 0x398, script: 0x52, flags: 0x0},
	92:  {lang: 0xf, script: 0x2, flags: 0x1},
	93:  {lang: 0xf6, script: 0x52, flags: 0x0},
	95:  {lang: 0x109, script: 0x52, flags: 0x0},
	97:  {lang: 0x1, script: 0x52, flags: 0x0},
	98:  {lang: 0xfd, script: 0x52, flags: 0x0},
	100: {lang: 0x139, script: 0x52, flags: 0x0},
	102: {lang: 0x11, script: 0x2, flags: 0x1},
	103: {lang: 0x139, script: 0x52, flags: 0x0},
	104: {lang: 0x139, script: 0x52, flags: 0x0},
	105: {lang: 0x13b, script: 0x52, flags: 0x0},
	106: {lang: 0x39, script: 0x5, flags: 0x0},
	107: {lang: 0x39, script: 0x5, flags: 0x0},
	108: {lang: 0x465, script: 0x27, flags: 0x0},
	109: {lang: 0x139, script: 0x52, flags: 0x0},
	110: {lang: 0x13, script: 0x2, flags: 0x1},
	112: {lang: 0x109, script: 0x52, flags: 0x0},
	113: {lang: 0x14c, script: 0x52, flags: 0x0},
	114: {lang: 0x1b9, script: 0x20, flags: 0x2},
	117: {lang: 0x153, script: 0x52, flags: 0x0},
	119: {lang: 0x159, script: 0x52, flags: 0x0},
	121: {lang: 0x159, script: 0x52, flags: 0x0},
	122: {lang: 0x15, script: 0x2, flags: 0x1},
	124: {lang: 0x17, script: 0x3, flags: 0x1},
	125: {lang: 0x159, script: 0x52, flags: 0x0},
	127: {lang: 0x20, script: 0x52, flags: 0x0},
	129: {lang: 0x23d, script: 0x52, flags: 0x0},
	131: {lang: 0x159, script: 0x52, flags: 0x0},
	132: {lang: 0x159, script: 0x52, flags: 0x0},
	133: {lang: 0x139, script: 0x52, flags: 0x0},
	134: {lang: 0x1a, script: 0x2, flags: 0x1},
	135: {lang: 0x0, script: 0x52, flags: 0x0},
	136: {lang: 0x139, script: 0x52, flags: 0x0},
	138: {lang: 0x3b7, script: 0x52, flags: 0x0},
	140: {lang: 0x51f, script: 0x35, flags: 0x0},
	141: {lang: 0x0, script: 0x52, flags: 0x0},
	142: {lang: 0x139, script: 0x52, flags: 0x0},
	143: {lang: 0x1ca, script: 0x52, flags: 0x0},
	144: {lang: 0x1cd, script: 0x52, flags: 0x0},
	145: {lang: 0x1ce, script: 0x52, flags: 0x0},
	147: {lang: 0x139, script: 0x52, flags: 0x0},
	148: {lang: 0x1c, script: 0x2, flags: 0x1},
	150: {lang: 0x1b5, script: 0x37, flags: 0x0},
	152: {lang: 0x1e, script: 0x3, flags: 0x1},
	154: {lang: 0x39, script: 0x5, flags: 0x0},
	155: {lang: 0x21, script: 0x2, flags: 0x1},
	156: {lang: 0x1f0, script: 0x52, flags: 0x0},
	157: {lang: 0x1f1, script: 0x52, flags: 0x0},
	160: {lang: 0x39, script: 0x5, flags: 0x0},
	161: {lang: 0x1f8, script: 0x41, flags: 0x0},
	163: {lang: 0x43b, script: 0x52, flags: 0x0},
	164: {lang: 0x281, script: 0x1e, flags: 0x0},
	165: {lang: 0x23, script: 0x3, flags: 0x1},
	167: {lang: 0x26, script: 0x2, flags: 0x1},
	169: {lang: 0x24b, script: 0x4b, flags: 0x0},
	170: {lang: 0x24b, script: 0x4b, flags: 0x0},
	171: {lang: 0x39, script: 0x5, flags: 0x0},
	173: {lang: 0x3d9, script: 0x1e, flags: 0x0},
	174: {lang: 0x28, script: 0x2, flags: 0x1},
	175: {lang: 0x39, script: 0x5, flags: 0x0},
	177: {lang: 0x109, script: 0x52, flags: 0x0},
	178: {lang: 0x402, script: 0xc1, flags: 0x0},
	180: {lang: 0x431, script: 0x52, flags: 0x0},
	181: {lang: 0x2b7, script: 0x52, flags: 0x0},
	182: {lang: 0x159, script: 0x52, flags: 0x0},
	183: {lang: 0x2be, script: 0x52, flags: 0x0},
	184: {lang: 0x39, script: 0x5, flags: 0x0},
	185: {lang: 0x2a, script: 0x2, flags: 0x1},
	186: {lang: 0x159, script: 0x52, flags: 0x0},
	187: {lang: 0x2c, script: 0x2, flags: 0x1},
	188: {lang: 0x428, script: 0x52, flags: 0x0},
	189: {lang: 0x159, script: 0x52, flags: 0x0},
	190: {lang: 0x2e8, script: 0x52, flags: 0x0},
	193: {lang: 0x2e, script: 0x2, flags: 0x1},
	194: {lang: 0x9e, script: 0x52, flags: 0x0},
	195: {lang: 0x30, script: 0x2, flags: 0x1},
	196: {lang: 0x32, script: 0x2, flags: 0x1},
	197: {lang: 0x34, script: 0x2, flags: 0x1},
	199: {lang: 0x159, script: 0x52, flags: 0x0},
	200: {lang: 0x36, script: 0x2, flags: 0x1},
	202: {lang: 0x317, script: 0x52, flags: 0x0},
	203: {lang: 0x38, script: 0x3, flags: 0x1},
	204: {lang: 0x124, script: 0xd4, flags: 0x0},
	206: {lang: 0x139, script: 0x52, flags: 0x0},
	207: {lang: 0x316, script: 0x52, flags: 0x0},
	208: {lang: 0x3b7, script: 0x52, flags: 0x0},
	209: {lang: 0x15, script: 0x52, flags: 0x0},
	210: {lang: 0x159, script: 0x52, flags: 0x0},
	211: {lang: 0x1ad, script: 0x52, flags: 0x0},
	213: {lang: 0x1ad, script: 0x5, flags: 0x2},
	215: {lang: 0x139, script: 0x52, flags: 0x0},
	216: {lang: 0x35e, script: 0x52, flags: 0x0},
	217: {lang: 0x33e, script: 0x52, flags: 0x0},
	218: {lang: 0x348, script: 0x20, flags: 0x0},
	224: {lang: 0x39, script: 0x5, flags: 0x0},
	225: {lang: 0x139, script: 0x52, flags: 0x0},
	227: {lang: 0x139, script: 0x52, flags: 0x0},
	228: {lang: 0x159, script: 0x52, flags: 0x0},
	229: {lang: 0x47c, script: 0x52, flags: 0x0},
	230: {lang: 0x14e, script: 0x52, flags: 0x0},
	231: {lang: 0x3b, script: 0x3, flags: 0x1},
	232: {lang: 0x3e, script: 0x2, flags: 0x1},
	233: {lang: 0x159, script: 0x52, flags: 0x0},
	235: {lang: 0x139, script: 0x52, flags: 0x0},
	236: {lang: 0x39, script: 0x5, flags: 0x0},
	237: {lang: 0x3b7, script: 0x52, flags: 0x0},
	239: {lang: 0x399, script: 0x52, flags: 0x0},
	240: {lang: 0x18e, script: 0x52, flags: 0x0},
	242: {lang: 0x39, script: 0x5, flags: 0x0},
	257: {lang: 0x159, script: 0x52, flags: 0x0},
	259: {lang: 0x40, script: 0x2, flags: 0x1},
	260: {lang: 0x428, script: 0x1e, flags: 0x0},
	261: {lang: 0x42, script: 0x2, flags: 0x1},
	262: {lang: 0x3dc, script: 0x52, flags: 0x0},
	263: {lang: 0x39, script: 0x5, flags: 0x0},
	265: {lang: 0x159, script: 0x52, flags: 0x0},
	266: {lang: 0x39, script: 0x5, flags: 0x0},
	267: {lang: 0x44, script: 0x2, flags: 0x1},
	270: {lang: 0x40c, script: 0x52, flags: 0x0},
	271: {lang: 0x33e, script: 0x52, flags: 0x0},
	272: {lang: 0x46, script: 0x2, flags: 0x1},
	274: {lang: 0x1f1, script: 0x52, flags: 0x0},
	275: {lang: 0x159, script: 0x52, flags: 0x0},
	276: {lang: 0x41f, script: 0x52, flags: 0x0},
	277: {lang: 0x35e, script: 0x52, flags: 0x0},
	279: {lang: 0x3b7, script: 0x52, flags: 0x0},
	281: {lang: 0x139, script: 0x52, flags: 0x0},
	283: {lang: 0x48, script: 0x2, flags: 0x1},
	287: {lang: 0x159, script: 0x52, flags: 0x0},
	288: {lang: 0x159, script: 0x52, flags: 0x0},
	289: {lang: 0x4a, script: 0x2, flags: 0x1},
	290: {lang: 0x4c, script: 0x3, flags: 0x1},
	291: {lang: 0x4f, script: 0x2, flags: 0x1},
	292: {lang: 0x46d, script: 0x52, flags: 0x0},
	293: {lang: 0x3b7, script: 0x52, flags: 0x0},
	294: {lang: 0x46c, script: 0x52, flags: 0x0},
	295: {lang: 0x51, script: 0x2, flags: 0x1},
	296: {lang: 0x478, script: 0x52, flags: 0x0},
	298: {lang: 0x53, script: 0x4, flags: 0x1},
	300: {lang: 0x496, script: 0x52, flags: 0x0},
	301: {lang: 0x57, script: 0x2, flags: 0x1},
	302: {lang: 0x43b, script: 0x52, flags: 0x0},
	303: {lang: 0x59, script: 0x3, flags: 0x1},
	304: {lang: 0x43b, script: 0x52, flags: 0x0},
	308: {lang: 0x508, script: 0x37, flags: 0x2},
	309: {lang: 0x139, script: 0x52, flags: 0x0},
	310: {lang: 0x4b2, script: 0x52, flags: 0x0},
	311: {lang: 0x1f1, script: 0x52, flags: 0x0},
	314: {lang: 0x139, script: 0x52, flags: 0x0},
	317: {lang: 0x4b9, script: 0x52, flags: 0x0},
	318: {lang: 0x89, script: 0x52, flags: 0x0},
	319: {lang: 0x159, script: 0x52, flags: 0x0},
	321: {lang: 0x411, script: 0x52, flags: 0x0},
	332: {lang: 0x5c, script: 0x2, flags: 0x1},
	349: {lang: 0x39, script: 0x5, flags: 0x0},
	350: {lang: 0x5e, script: 0x2, flags: 0x1},
	355: {lang: 0x419, script: 0x52, flags: 0x0},
}

// likelyRegionList holds lists info associated with likelyRegion.
// Size: 384 bytes, 96 elements
var likelyRegionList = [96]likelyLangScript{
	0:  {lang: 0x143, script: 0x5, flags: 0x0},
	1:  {lang: 0x46c, script: 0x52, flags: 0x0},
	2:  {lang: 0x427, script: 0x52, flags: 0x0},
	3:  {lang: 0x2f6, script: 0x1e, flags: 0x0},
	4:  {lang: 0x1d0, script: 0x8, flags: 0x0},
	5:  {lang: 0x26b, script: 0x52, flags: 0x0},
	6:  {lang: 0xb5, script: 0x52, flags: 0x0},
	7:  {lang: 0x428, script: 0x1e, flags: 0x0},
	8:  {lang: 0x129, script: 0xd6, flags: 0x0},
	9:  {lang: 0x348, script: 0x20, flags: 0x0},
	10: {lang: 0x51f, script: 0x34, flags: 0x0},
	11: {lang: 0x4a2, script: 0x5, flags: 0x0},
	12: {lang: 0x515, script: 0x35, flags: 0x0},
	13: {lang: 0x519, script: 0x52, flags: 0x0},
	14: {lang: 0x291, script: 0xd5, flags: 0x0},
	15: {lang: 0x131, script: 0x2d, flags: 0x0},
	16: {lang: 0x480, script: 0x52, flags: 0x0},
	17: {lang: 0x39, script: 0x5, flags: 0x0},
	18: {lang: 0x159, script: 0x52, flags: 0x0},
	19: {lang: 0x26, script: 0x27, flags: 0x0},
	20: {lang: 0x134, script: 0x52, flags: 0x0},
	21: {lang: 0x261, script: 0x5, flags: 0x2},
	22: {lang: 0x508, script: 0x37, flags: 0x2},
	23: {lang: 0x208, script: 0x29, flags: 0x0},
	24: {lang: 0x5, script: 0x1e, flags: 0x0},
	25: {lang: 0x26b, script: 0x52, flags: 0x0},
	26: {lang: 0x131, script: 0x2d, flags: 0x0},
	27: {lang: 0x2f6, script: 0x1e, flags: 0x0},
	28: {lang: 0x1da, script: 0x52, flags: 0x0},
	29: {lang: 0x316, script: 0x5, flags: 0x0},
	30: {lang: 0x1b7, script: 0x20, flags: 0x0},
	31: {lang: 0x4aa, script: 0x5, flags: 0x0},
	32: {lang: 0x22e, script: 0x6b, flags: 0x0},
	33: {lang: 0x143, script: 0x5, flags: 0x0},
	34: {lang: 0x46c, script: 0x52, flags: 0x0},
	35: {lang: 0x242, script: 0x46, flags: 0x0},
	36: {lang: 0xe4, script: 0x5, flags: 0x0},
	37: {lang: 0x21e, script: 0xd5, flags: 0x0},
	38: {lang: 0x39, script: 0x5, flags: 0x0},
	39: {lang: 0x159, script: 0x52, flags: 0x0},
	40: {lang: 0x2af, script: 0x4f, flags: 0x0},
	41: {lang: 0x21e, script: 0xd5, flags: 0x0},
	42: {lang: 0x39, script: 0x5, flags: 0x0},
	43: {lang: 0x159, script: 0x52, flags: 0x0},
	44: {lang: 0x3d3, script: 0x52, flags: 0x0},
	45: {lang: 0x4a4, script: 0x1e, flags: 0x0},
	46: {lang: 0x2f6, script: 0x1e, flags: 0x0},
	47: {lang: 0x427, script: 0x52, flags: 0x0},
	48: {lang: 0x328, script: 0x6b, flags: 0x0},
	49: {lang: 0x20b, script: 0x52, flags: 0x0},
	50: {lang: 0x302, script: 0x1e, flags: 0x0},
	51: {lang: 0x23a, script: 0x5, flags: 0x0},
	52: {lang: 0x51f, script: 0x35, flags: 0x0},
	53: {lang: 0x3b7, script: 0x52, flags: 0x0},
	54: {lang: 0x39, script: 0x5, flags: 0x0},
	55: {lang: 0x159, script: 0x52, flags: 0x0},
	56: {lang: 0x2e4, script: 0x52, flags: 0x0},
	57: {lang: 0x4aa, script: 0x5, flags: 0x0},
	58: {lang: 0x87, script: 0x20, flags: 0x0},
	59: {lang: 0x4aa, script: 0x5, flags: 0x0},
	60: {lang: 0x4aa, script: 0x5, flags: 0x0},
	61: {lang: 0xbc, script: 0x20, flags: 0x0},
	62: {lang: 0x3aa, script: 0x52, flags: 0x0},
	63: {lang: 0x70, script: 0x1e, flags: 0x0},
	64: {lang: 0x3d3, script: 0x52, flags: 0x0},
	65: {lang: 0x7d, script: 0x1e, flags: 0x0},
	66: {lang: 0x3d9, script: 0x1e, flags: 0x0},
	67: {lang: 0x25e, script: 0x52, flags: 0x0},
	68: {lang: 0x43a, script: 0x52, flags: 0x0},
	69: {lang: 0x508, script: 0x37, flags: 0x0},
	70: {lang: 0x408, script: 0x52, flags: 0x0},
	71: {lang: 0x4a4, script: 0x1e, flags: 0x0},
	72: {lang: 0x39, script: 0x5, flags: 0x0},
	73: {lang: 0x159, script: 0x52, flags: 0x0},
	74: {lang: 0x159, script: 0x52, flags: 0x0},
	75: {lang: 0x34, script: 0x5, flags: 0x0},
	76: {lang: 0x461, script: 0xd5, flags: 0x0},
	77: {lang: 0x2e3, script: 0x5, flags: 0x0},
	78: {lang: 0x306, script: 0x6b, flags: 0x0},
	79: {lang: 0x45d, script: 0x1e, flags: 0x0},
	80: {lang: 0x143, script: 0x5, flags: 0x0},
	81: {lang: 0x39, script: 0x5, flags: 0x0},
	82: {lang: 0x159, script: 0x52, flags: 0x0},
	83: {lang: 0x480, script: 0x52, flags: 0x0},
	84: {lang: 0x57, script: 0x5, flags: 0x0},
	85: {lang: 0x211, script: 0x1e, flags: 0x0},
	86: {lang: 0x80, script: 0x2d, flags: 0x0},
	87: {lang: 0x51f, script: 0x35, flags: 0x0},
	88: {lang: 0x482, script: 0x52, flags: 0x0},
	89: {lang: 0x4a4, script: 0x1e, flags: 0x0},
	90: {lang: 0x508, script: 0x37, flags: 0x0},
	91: {lang: 0x3aa, script: 0x52, flags: 0x0},
	92: {lang: 0x427, script: 0x52, flags: 0x0},
	93: {lang: 0x428, script: 0x1e, flags: 0x0},
	94: {lang: 0x159, script: 0x52, flags: 0x0},
	95: {lang: 0x43c, script: 0x5, flags: 0x0},
}

type likelyTag struct {
	lang   uint16
	region uint16
	script uint8
}

// Size: 192 bytes, 32 elements
var likelyRegionGroup = [32]likelyTag{
	1:  {lang: 0x134, region: 0xd5, script: 0x52},
	2:  {lang: 0x134, region: 0x134, script: 0x52},
	3:  {lang: 0x3b7, region: 0x40, script: 0x52},
	4:  {lang: 0x134, region: 0x2e, script: 0x52},
	5:  {lang: 0x134, region: 0xd5, script: 0x52},
	6:  {lang: 0x139, region: 0xce, script: 0x52},
	7:  {lang: 0x43b, region: 0x12e, script: 0x52},
	8:  {lang: 0x39, region: 0x6a, script: 0x5},
	9:  {lang: 0x43b, region: 0x4a, script: 0x52},
	10: {lang: 0x134, region: 0x160, script: 0x52},
	11: {lang: 0x134, region: 0x134, script: 0x52},
	12: {lang: 0x134, region: 0x134, script: 0x52},
	13: {lang: 0x139, region: 0x58, script: 0x52},
	14: {lang: 0x51f, region: 0x52, script: 0x34},
	15: {lang: 0x1b7, region: 0x98, script: 0x20},
	16: {lang: 0x1da, region: 0x94, script: 0x52},
	17: {lang: 0x1f1, region: 0x9d, script: 0x52},
	18: {lang: 0x134, region: 0x2e, script: 0x52},
	19: {lang: 0x134, region: 0xe5, script: 0x52},
	20: {lang: 0x134, region: 0x89, script: 0x52},
	21: {lang: 0x411, region: 0x141, script: 0x52},
	22: {lang: 0x51f, region: 0x52, script: 0x34},
	23: {lang: 0x4b2, region: 0x136, script: 0x52},
	24: {lang: 0x39, region: 0x107, script: 0x5},
	25: {lang: 0x3d9, region: 0x105, script: 0x1e},
	26: {lang: 0x3d9, region: 0x105, script: 0x1e},
	27: {lang: 0x134, region: 0x7a, script: 0x52},
	28: {lang: 0x109, region: 0x5f, script: 0x52},
	29: {lang: 0x139, region: 0x1e, script: 0x52},
	30: {lang: 0x134, region: 0x99, script: 0x52},
	31: {lang: 0x134, region: 0x7a, script: 0x52},
}

type mutualIntelligibility struct {
	want   uint16
	have   uint16
	conf   uint8
	oneway bool
}

type scriptIntelligibility struct {
	lang uint16
	want uint8
	have uint8
	conf uint8
}

// matchLang holds pairs of langIDs of base languages that are typically
// mutually intelligible. Each pair is associated with a confidence and
// whether the intelligibility goes one or both ways.
// Size: 708 bytes, 118 elements
var matchLang = [118]mutualIntelligibility{
	0:   {want: 0x366, have: 0x33e, conf: 0x2, oneway: false},
	1:   {want: 0x26b, have: 0xe7, conf: 0x2, oneway: false},
	2:   {want: 0x1ca, have: 0xb5, conf: 0x2, oneway: false},
	3:   {want: 0x3fd, have: 0xb5, conf: 0x2, oneway: false},
	4:   {want: 0x428, have: 0xb5, conf: 0x2, oneway: false},
	5:   {want: 0x3fd, have: 0x1ca, conf: 0x2, oneway: false},
	6:   {want: 0x428, have: 0x1ca, conf: 0x2, oneway: false},
	7:   {want: 0x3fd, have: 0x428, conf: 0x2, oneway: false},
	8:   {want: 0x430, have: 0x1, conf: 0x2, oneway: false},
	9:   {want: 0x19c, have: 0x109, conf: 0x2, oneway: true},
	10:  {want: 0x28c, have: 0x109, conf: 0x2, oneway: true},
	11:  {want: 0xfd, have: 0x366, conf: 0x2, oneway: false},
	12:  {want: 0xfd, have: 0x33e, conf: 0x2, oneway: false},
	13:  {want: 0xe7, have: 0x26b, conf: 0x2, oneway: false},
	14:  {want: 0x5, have: 0x3d9, conf: 0x2, oneway: true},
	15:  {want: 0xc, have: 0x134, conf: 0x2, oneway: true},
	16:  {want: 0x15, have: 0x35e, conf: 0x2, oneway: true},
	17:  {want: 0x20, have: 0x134, conf: 0x2, oneway: true},
	18:  {want: 0x55, have: 0x139, conf: 0x2, oneway: true},
	19:  {want: 0x57, have: 0x3d9, conf: 0x2, oneway: true},
	20:  {want: 0x70, have: 0x3d9, conf: 0x2, oneway: true},
	21:  {want: 0x74, have: 0x134, conf: 0x2, oneway: true},
	22:  {want: 0x81, have: 0x1b7, conf: 0x2, oneway: true},
	23:  {want: 0xa3, have: 0x134, conf: 0x2, oneway: true},
	24:  {want: 0xb0, have: 0x159, conf: 0x2, oneway: true},
	25:  {want: 0xdb, have: 0x14e, conf: 0x2, oneway: true},
	26:  {want: 0xe3, have: 0x134, conf: 0x2, oneway: true},
	27:  {want: 0xe7, have: 0x39, conf: 0x2, oneway: true},
	28:  {want: 0xed, have: 0x159, conf: 0x2, oneway: true},
	29:  {want: 0xf5, have: 0x159, conf: 0x2, oneway: true},
	30:  {want: 0xfc, have: 0x134, conf: 0x2, oneway: true},
	31:  {want: 0x12c, have: 0x134, conf: 0x2, oneway: true},
	32:  {want: 0x137, have: 0x134, conf: 0x2, oneway: true},
	33:  {want: 0x13b, have: 0x14c, conf: 0x2, oneway: true},
	34:  {want: 0x140, have: 0x139, conf: 0x2, oneway: true},
	35:  {want: 0x153, have: 0xfd, conf: 0x2, oneway: true},
	36:  {want: 0x168, have: 0x35e, conf: 0x2, oneway: true},
	37:  {want: 0x169, have: 0x134, conf: 0x2, oneway: true},
	38:  {want: 0x16a, have: 0x134, conf: 0x2, oneway: true},
	39:  {want: 0x178, have: 0x134, conf: 0x2, oneway: true},
	40:  {want: 0x18a, have: 0x139, conf: 0x2, oneway: true},
	41:  {want: 0x18e, have: 0x139, conf: 0x2, oneway: true},
	42:  {want: 0x19d, have: 0x1b7, conf: 0x2, oneway: true},
	43:  {want: 0x1ad, have: 0x134, conf: 0x2, oneway: true},
	44:  {want: 0x1b1, have: 0x134, conf: 0x2, oneway: true},
	45:  {want: 0x1cd, have: 0x159, conf: 0x2, oneway: true},
	46:  {want: 0x1d0, have: 0x3d9, conf: 0x2, oneway: true},
	47:  {want: 0x1d2, have: 0x134, conf: 0x2, oneway: true},
	48:  {want: 0x1df, have: 0x134, conf: 0x2, oneway: true},
	49:  {want: 0x1f0, have: 0x134, conf: 0x2, oneway: true},
	50:  {want: 0x206, have: 0x1da, conf: 0x2, oneway: true},
	51:  {want: 0x208, have: 0x134, conf: 0x2, oneway: true},
	52:  {want: 0x225, have: 0x159, conf: 0x2, oneway: true},
	53:  {want: 0x23a, have: 0x3d9, conf: 0x2, oneway: true},
	54:  {want: 0x242, have: 0x134, conf: 0x2, oneway: true},
	55:  {want: 0x249, have: 0x134, conf: 0x2, oneway: true},
	56:  {want: 0x25c, have: 0x134, conf: 0x2, oneway: true},
	57:  {want: 0x26b, have: 0x480, conf: 0x2, oneway: true},
	58:  {want: 0x281, have: 0x3d9, conf: 0x2, oneway: true},
	59:  {want: 0x285, have: 0x1f1, conf: 0x2, oneway: true},
	60:  {want: 0x29a, have: 0x134, conf: 0x2, oneway: true},
	61:  {want: 0x2ac, have: 0x159, conf: 0x2, oneway: true},
	62:  {want: 0x2af, have: 0x134, conf: 0x2, oneway: true},
	63:  {want: 0x2b5, have: 0x134, conf: 0x2, oneway: true},
	64:  {want: 0x2ba, have: 0x159, conf: 0x2, oneway: true},
	65:  {want: 0x2e4, have: 0x134, conf: 0x2, oneway: true},
	66:  {want: 0x2e8, have: 0x159, conf: 0x2, oneway: true},
	67:  {want: 0x2f1, have: 0x134, conf: 0x2, oneway: true},
	68:  {want: 0x2f6, have: 0x7d, conf: 0x2, oneway: true},
	69:  {want: 0x2fb, have: 0x134, conf: 0x2, oneway: true},
	70:  {want: 0x302, have: 0x3d9, conf: 0x2, oneway: true},
	71:  {want: 0x312, have: 0x1b7, conf: 0x2, oneway: true},
	72:  {want: 0x316, have: 0x1da, conf: 0x2, oneway: true},
	73:  {want: 0x317, have: 0x134, conf: 0x2, oneway: true},
	74:  {want: 0x328, have: 0x134, conf: 0x2, oneway: true},
	75:  {want: 0x348, have: 0x134, conf: 0x2, oneway: true},
	76:  {want: 0x361, have: 0x33e, conf: 0x2, oneway: false},
	77:  {want: 0x361, have: 0x366, conf: 0x2, oneway: true},
	78:  {want: 0x371, have: 0x134, conf: 0x2, oneway: true},
	79:  {want: 0x37e, have: 0x134, conf: 0x2, oneway: true},
	80:  {want: 0x380, have: 0x134, conf: 0x2, oneway: true},
	81:  {want: 0x382, have: 0x159, conf: 0x2, oneway: true},
	82:  {want: 0x387, have: 0x134, conf: 0x2, oneway: true},
	83:  {want: 0x38c, have: 0x134, conf: 0x2, oneway: true},
	84:  {want: 0x394, have: 0x134, conf: 0x2, oneway: true},
	85:  {want: 0x39c, have: 0x134, conf: 0x2, oneway: true},
	86:  {want: 0x3b5, have: 0x134, conf: 0x2, oneway: true},
	87:  {want: 0x3bb, have: 0x139, conf: 0x2, oneway: true},
	88:  {want: 0x3cb, have: 0x109, conf: 0x2, oneway: true},
	89:  {want: 0x3d0, have: 0x134, conf: 0x2, oneway: true},
	90:  {want: 0x3dc, have: 0x159, conf: 0x2, oneway: true},
	91:  {want: 0x3e0, have: 0x1b7, conf: 0x2, oneway: true},
	92:  {want: 0x3f0, have: 0x134, conf: 0x2, oneway: true},
	93:  {want: 0x402, have: 0x134, conf: 0x2, oneway: true},
	94:  {want: 0x419, have: 0x134, conf: 0x2, oneway: true},
	95:  {want: 0x41f, have: 0x134, conf: 0x2, oneway: true},
	96:  {want: 0x427, have: 0x134, conf: 0x2, oneway: true},
	97:  {want: 0x431, have: 0x134, conf: 0x2, oneway: true},
	98:  {want: 0x434, have: 0x1da, conf: 0x2, oneway: true},
	99:  {want: 0x43b, have: 0x134, conf: 0x2, oneway: true},
	100: {want: 0x446, have: 0x134, conf: 0x2, oneway: true},
	101: {want: 0x457, have: 0x134, conf: 0x2, oneway: true},
	102: {want: 0x45d, have: 0x3d9, conf: 0x2, oneway: true},
	103: {want: 0x465, have: 0x134, conf: 0x2, oneway: true},
	104: {want: 0x46c, have: 0x3d9, conf: 0x2, oneway: true},
	105: {want: 0x3878, have: 0x134, conf: 0x2, oneway: true},
	106: {want: 0x476, have: 0x134, conf: 0x2, oneway: true},
	107: {want: 0x478, have: 0x134, conf: 0x2, oneway: true},
	108: {want: 0x48a, have: 0x3d9, conf: 0x2, oneway: true},
	109: {want: 0x493, have: 0x134, conf: 0x2, oneway: true},
	110: {want: 0x4a2, have: 0x51f, conf: 0x2, oneway: true},
	111: {want: 0x4aa, have: 0x134, conf: 0x2, oneway: true},
	112: {want: 0x4b2, have: 0x3d9, conf: 0x2, oneway: true},
	113: {want: 0x4db, have: 0x159, conf: 0x2, oneway: true},
	114: {want: 0x4e8, have: 0x134, conf: 0x2, oneway: true},
	115: {want: 0x508, have: 0x134, conf: 0x2, oneway: true},
	116: {want: 0x50e, have: 0x134, conf: 0x2, oneway: true},
	117: {want: 0x524, have: 0x134, conf: 0x2, oneway: true},
}

// matchScript holds pairs of scriptIDs where readers of one script
// can typically also read the other. Each is associated with a confidence.
// Size: 24 bytes, 4 elements
var matchScript = [4]scriptIntelligibility{
	0: {lang: 0x428, want: 0x52, have: 0x1e, conf: 0x2},
	1: {lang: 0x428, want: 0x1e, have: 0x52, conf: 0x2},
	2: {lang: 0x0, want: 0x34, have: 0x35, conf: 0x1},
	3: {lang: 0x0, want: 0x35, have: 0x34, conf: 0x1},
}

// Size: 128 bytes, 32 elements
var regionContainment = [32]uint32{
	0xffffffff, 0x000007a2, 0x00003044, 0x00000008,
	0x403c0010, 0x00000020, 0x00000040, 0x00000080,
	0x00000100, 0x00000200, 0x00000400, 0x2000384c,
	0x00001000, 0x00002000, 0x00004000, 0x00008000,
	0x00010000, 0x00020000, 0x00040000, 0x00080000,
	0x00100000, 0x00200000, 0x01c1c000, 0x00800000,
	0x01000000, 0x1e020000, 0x04000000, 0x08000000,
	0x10000000, 0x20002048, 0x40000000, 0x80000000,
}

// regionInclusion maps region identifiers to sets of regions in regionInclusionBits,
// where each set holds all groupings that are directly connected in a region
// containment graph.
// Size: 357 bytes, 357 elements
var regionInclusion = [357]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06,
	0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e,
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
	0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x20,
	0x21, 0x22, 0x23, 0x24, 0x25, 0x25, 0x22, 0x23,
	0x25, 0x26, 0x21, 0x27, 0x28, 0x29, 0x2a, 0x25,
	0x2b, 0x23, 0x22, 0x25, 0x24, 0x29, 0x2c, 0x2d,
	0x23, 0x2e, 0x2c, 0x25, 0x2f, 0x30, 0x27, 0x25,
	// Entry 40 - 7F
	0x27, 0x25, 0x24, 0x30, 0x21, 0x31, 0x32, 0x33,
	0x2f, 0x21, 0x26, 0x26, 0x26, 0x34, 0x2c, 0x28,
	0x27, 0x26, 0x35, 0x27, 0x21, 0x33, 0x22, 0x20,
	0x25, 0x2c, 0x25, 0x21, 0x36, 0x2d, 0x34, 0x29,
	0x21, 0x2e, 0x37, 0x25, 0x25, 0x20, 0x38, 0x38,
	0x27, 0x37, 0x38, 0x38, 0x2e, 0x39, 0x2e, 0x1f,
	0x20, 0x37, 0x3a, 0x27, 0x3b, 0x2b, 0x20, 0x29,
	0x34, 0x26, 0x37, 0x25, 0x23, 0x27, 0x2b, 0x2c,
	// Entry 80 - BF
	0x22, 0x2f, 0x2c, 0x2c, 0x25, 0x26, 0x39, 0x21,
	0x33, 0x3b, 0x2c, 0x27, 0x35, 0x21, 0x33, 0x39,
	0x25, 0x2d, 0x20, 0x38, 0x30, 0x37, 0x23, 0x2b,
	0x24, 0x21, 0x23, 0x24, 0x2b, 0x39, 0x2b, 0x25,
	0x23, 0x35, 0x20, 0x2e, 0x3c, 0x30, 0x3b, 0x2e,
	0x25, 0x35, 0x35, 0x23, 0x25, 0x3c, 0x30, 0x23,
	0x25, 0x34, 0x24, 0x2c, 0x31, 0x37, 0x29, 0x37,
	0x38, 0x38, 0x34, 0x32, 0x22, 0x25, 0x2e, 0x3b,
	// Entry C0 - FF
	0x20, 0x22, 0x2c, 0x30, 0x35, 0x35, 0x3b, 0x25,
	0x2c, 0x25, 0x39, 0x2e, 0x24, 0x2e, 0x33, 0x30,
	0x2e, 0x31, 0x3a, 0x2c, 0x2a, 0x2c, 0x20, 0x33,
	0x29, 0x2b, 0x24, 0x20, 0x3b, 0x23, 0x28, 0x2a,
	0x23, 0x33, 0x20, 0x27, 0x28, 0x3a, 0x30, 0x24,
	0x2d, 0x2f, 0x28, 0x25, 0x23, 0x39, 0x20, 0x3b,
	0x27, 0x20, 0x23, 0x20, 0x20, 0x1e, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	// Entry 100 - 13F
	0x20, 0x2e, 0x20, 0x2d, 0x22, 0x32, 0x2e, 0x23,
	0x3a, 0x2e, 0x38, 0x37, 0x30, 0x2c, 0x39, 0x2b,
	0x2d, 0x2c, 0x22, 0x2c, 0x2e, 0x27, 0x2e, 0x26,
	0x32, 0x33, 0x25, 0x23, 0x31, 0x21, 0x25, 0x26,
	0x21, 0x2c, 0x30, 0x3c, 0x28, 0x30, 0x3c, 0x38,
	0x28, 0x30, 0x23, 0x25, 0x28, 0x35, 0x2e, 0x32,
	0x2e, 0x20, 0x21, 0x20, 0x2f, 0x27, 0x3c, 0x22,
	0x25, 0x20, 0x27, 0x25, 0x25, 0x30, 0x3a, 0x28,
	// Entry 140 - 17F
	0x20, 0x28, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x22, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x23, 0x23, 0x2e, 0x22,
	0x31, 0x2e, 0x26, 0x2e, 0x20,
}

// regionInclusionBits is an array of bit vectors where every vector represents
// a set of region groupings.  These sets are used to compute the distance
// between two regions for the purpose of language matching.
// Size: 288 bytes, 72 elements
var regionInclusionBits = [72]uint32{
	// Entry 0 - 1F
	0x82400813, 0x000007a3, 0x00003844, 0x20000808,
	0x403c0011, 0x00000022, 0x20000844, 0x00000082,
	0x00000102, 0x00000202, 0x00000402, 0x2000384d,
	0x00001804, 0x20002804, 0x00404000, 0x00408000,
	0x00410000, 0x02020000, 0x00040010, 0x00080010,
	0x00100010, 0x00200010, 0x01c1c001, 0x00c00000,
	0x01400000, 0x1e020001, 0x06000000, 0x0a000000,
	0x12000000, 0x20002848, 0x40000010, 0x80000001,
	// Entry 20 - 3F
	0x00000001, 0x40000000, 0x00020000, 0x01000000,
	0x00008000, 0x00002000, 0x00000200, 0x00000008,
	0x00200000, 0x90000000, 0x00040000, 0x08000000,
	0x00000020, 0x84000000, 0x00000080, 0x00001000,
	0x00010000, 0x00000400, 0x04000000, 0x00000040,
	0x10000000, 0x00004000, 0x81000000, 0x88000000,
	0x00000100, 0x80020000, 0x00080000, 0x00100000,
	0x00800000, 0xffffffff, 0x82400fb3, 0xc27c0813,
	// Entry 40 - 5F
	0xa240385f, 0x83c1c813, 0x9e420813, 0x92000001,
	0x86000001, 0x81400001, 0x8a000001, 0x82020001,
}

// regionInclusionNext marks, for each entry in regionInclusionBits, the set of
// all groups that are reachable from the groups set in the respective entry.
// Size: 72 bytes, 72 elements
var regionInclusionNext = [72]uint8{
	// Entry 0 - 3F
	0x3d, 0x3e, 0x0b, 0x0b, 0x3f, 0x01, 0x0b, 0x01,
	0x01, 0x01, 0x01, 0x40, 0x0b, 0x0b, 0x16, 0x16,
	0x16, 0x19, 0x04, 0x04, 0x04, 0x04, 0x41, 0x16,
	0x16, 0x42, 0x19, 0x19, 0x19, 0x0b, 0x04, 0x00,
	0x00, 0x1e, 0x11, 0x18, 0x0f, 0x0d, 0x09, 0x03,
	0x15, 0x43, 0x12, 0x1b, 0x05, 0x44, 0x07, 0x0c,
	0x10, 0x0a, 0x1a, 0x06, 0x1c, 0x0e, 0x45, 0x46,
	0x08, 0x47, 0x13, 0x14, 0x17, 0x3d, 0x3d, 0x3d,
	// Entry 40 - 7F
	0x3d, 0x3d, 0x3d, 0x42, 0x42, 0x41, 0x42, 0x42,
}

type parentRel struct {
	lang       uint16
	script     uint8
	maxScript  uint8
	toRegion   uint16
	fromRegion []uint16
}

// Size: 412 bytes, 5 elements
var parents = [5]parentRel{
	0: {lang: 0x134, script: 0x0, maxScript: 0x52, toRegion: 0x1, fromRegion: []uint16{0x1a, 0x24, 0x25, 0x2e, 0x33, 0x35, 0x3c, 0x41, 0x45, 0x47, 0x48, 0x49, 0x4f, 0x51, 0x5b, 0x5c, 0x60, 0x63, 0x6c, 0x72, 0x73, 0x74, 0x7a, 0x7b, 0x7e, 0x7f, 0x80, 0x82, 0x8b, 0x8c, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9e, 0x9f, 0xa3, 0xa6, 0xa8, 0xac, 0xb0, 0xb3, 0xb4, 0xbe, 0xc5, 0xc9, 0xca, 0xcb, 0xcd, 0xcf, 0xd1, 0xd4, 0xd5, 0xdc, 0xde, 0xdf, 0xe5, 0xe6, 0xe7, 0xea, 0xef, 0x106, 0x108, 0x109, 0x10a, 0x10c, 0x10d, 0x111, 0x116, 0x11a, 0x11c, 0x11e, 0x124, 0x128, 0x12b, 0x12c, 0x12e, 0x130, 0x138, 0x13b, 0x13e, 0x141, 0x160, 0x161, 0x163}},
	1: {lang: 0x134, script: 0x0, maxScript: 0x52, toRegion: 0x1a, fromRegion: []uint16{0x2d, 0x4d, 0x5f, 0x62, 0x71, 0xd8, 0x10b, 0x10e}},
	2: {lang: 0x139, script: 0x0, maxScript: 0x52, toRegion: 0x1e, fromRegion: []uint16{0x2b, 0x3e, 0x40, 0x50, 0x53, 0x55, 0x58, 0x64, 0x68, 0x88, 0x8e, 0xce, 0xd7, 0xe1, 0xe3, 0xeb, 0xf0, 0x119, 0x134, 0x135, 0x13a}},
	3: {lang: 0x3b7, script: 0x0, maxScript: 0x52, toRegion: 0xed, fromRegion: []uint16{0x29, 0x4d, 0x59, 0x85, 0x8a, 0xb6, 0xc5, 0xd0, 0x117, 0x125}},
	4: {lang: 0x51f, script: 0x35, maxScript: 0x35, toRegion: 0x8c, fromRegion: []uint16{0xc5}},
}

// Total table size 25825 bytes (25KiB); checksum: 4E97CC5E
