#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.gpm"), aligned (8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[2303]; const double alignment; void * const ptr;}  gpm_resource_data = { {
  0x47, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x18, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x28, 0x05, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
  0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
  0x05, 0x00, 0x00, 0x00, 0xd4, 0xb5, 0x02, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x4c, 0x00, 0xb0, 0x00, 0x00, 0x00, 
  0xb4, 0x00, 0x00, 0x00, 0x4b, 0x50, 0x90, 0x0b, 
  0x00, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 
  0x04, 0x00, 0x4c, 0x00, 0xb8, 0x00, 0x00, 0x00, 
  0xbc, 0x00, 0x00, 0x00, 0x34, 0xc8, 0xd0, 0xb5, 
  0x03, 0x00, 0x00, 0x00, 0xbc, 0x00, 0x00, 0x00, 
  0x0e, 0x00, 0x4c, 0x00, 0xcc, 0x00, 0x00, 0x00, 
  0xd0, 0x00, 0x00, 0x00, 0xb0, 0xb7, 0x24, 0x30, 
  0x01, 0x00, 0x00, 0x00, 0xd0, 0x00, 0x00, 0x00, 
  0x06, 0x00, 0x4c, 0x00, 0xd8, 0x00, 0x00, 0x00, 
  0xdc, 0x00, 0x00, 0x00, 0x1c, 0xa2, 0xa6, 0x0c, 
  0x02, 0x00, 0x00, 0x00, 0xdc, 0x00, 0x00, 0x00, 
  0x11, 0x00, 0x76, 0x00, 0xf0, 0x00, 0x00, 0x00, 
  0xff, 0x08, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x6f, 0x72, 0x67, 0x2f, 
  0x03, 0x00, 0x00, 0x00, 0x70, 0x6f, 0x77, 0x65, 
  0x72, 0x2d, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 
  0x72, 0x2f, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
  0x67, 0x6e, 0x6f, 0x6d, 0x65, 0x2f, 0x00, 0x00, 
  0x02, 0x00, 0x00, 0x00, 0x67, 0x70, 0x6d, 0x2d, 
  0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 
  0x63, 0x73, 0x2e, 0x75, 0x69, 0x00, 0x00, 0x00, 
  0xb8, 0x67, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x78, 0xda, 0xed, 0x5d, 0x5b, 0x73, 0xda, 0x38, 
  0x14, 0x7e, 0xef, 0xaf, 0xd0, 0xfa, 0x75, 0x87, 
  0x10, 0x43, 0x92, 0x4d, 0x76, 0x80, 0xce, 0xb6, 
  0x9d, 0xb6, 0x0f, 0x3b, 0x3b, 0x9d, 0x49, 0xda, 
  0x3e, 0x7a, 0x64, 0xfb, 0x80, 0xb5, 0x08, 0xcb, 
  0x2b, 0x89, 0x00, 0xff, 0x7e, 0x05, 0x06, 0x12, 
  0xc0, 0x77, 0x01, 0x31, 0xae, 0x9e, 0x12, 0x1b, 
  0x1d, 0x59, 0xe7, 0x93, 0xce, 0x4d, 0x7c, 0xc8, 
  0xbd, 0xf7, 0xf3, 0x09, 0x45, 0xcf, 0xc0, 0x05, 
  0x61, 0x61, 0xdf, 0xb2, 0xaf, 0xae, 0x2d, 0x04, 
  0xa1, 0xc7, 0x7c, 0x12, 0x8e, 0xfa, 0xd6, 0xf7, 
  0xa7, 0xcf, 0xad, 0x7b, 0xeb, 0xfd, 0xe0, 0x5d, 
  0xef, 0xb7, 0x56, 0x0b, 0x7d, 0x81, 0x10, 0x38, 
  0x96, 0xe0, 0xa3, 0x19, 0x91, 0x01, 0x1a, 0x51, 
  0xec, 0x03, 0xea, 0x5e, 0xd9, 0xf7, 0x57, 0x36, 
  0x6a, 0xb5, 0x54, 0x23, 0x12, 0x4a, 0xe0, 0x43, 
  0xec, 0xc1, 0xe0, 0x1d, 0x42, 0x3d, 0x0e, 0xff, 
  0x4d, 0x09, 0x07, 0x81, 0x28, 0x71, 0xfb, 0xd6, 
  0x48, 0x8e, 0x7f, 0xb7, 0x5e, 0x1e, 0xa4, 0xc4, 
  0x6e, 0xac, 0xf6, 0xaa, 0x1d, 0x73, 0xff, 0x05, 
  0x4f, 0x22, 0x8f, 0x62, 0x21, 0xfa, 0xd6, 0x17, 
  0x39, 0xfe, 0x2b, 0x8a, 0x28, 0xf1, 0xb0, 0x54, 
  0x0d, 0x7f, 0x92, 0xd0, 0x67, 0x33, 0x0b, 0x11, 
  0xbf, 0x6f, 0xf9, 0x04, 0x53, 0x36, 0x72, 0x84, 
  0xc4, 0x52, 0x58, 0x4b, 0x49, 0x25, 0x1b, 0x71, 
  0x16, 0x01, 0x97, 0x0b, 0x14, 0xe2, 0x09, 0xf4, 
  0x2d, 0x0f, 0x87, 0xce, 0x90, 0x79, 0x53, 0xf5, 
  0xf9, 0x67, 0x4c, 0x05, 0xf4, 0xda, 0x9b, 0x06, 
  0xc9, 0xed, 0x5d, 0xc6, 0x7d, 0xe0, 0xce, 0x8c, 
  0xf8, 0x32, 0xb0, 0x06, 0xf6, 0x7d, 0x5e, 0x7b, 
  0x49, 0x24, 0x05, 0x0b, 0x49, 0x8e, 0x43, 0x41, 
  0xb1, 0xc4, 0x2e, 0x55, 0x37, 0x17, 0xa0, 0x1e, 
  0xf7, 0x8d, 0xcd, 0x80, 0xa3, 0x47, 0x35, 0x36, 
  0x22, 0x24, 0xf1, 0xc4, 0x41, 0x4f, 0x5e, 0x40, 
  0xa8, 0x1f, 0xff, 0x9f, 0xa4, 0xf3, 0x07, 0x36, 
  0x8f, 0xb5, 0x74, 0xd9, 0xdc, 0xb6, 0x36, 0xed, 
  0x0e, 0x47, 0xf0, 0x4c, 0x04, 0x51, 0x4f, 0xb5, 
  0x06, 0x4f, 0x7c, 0x7a, 0xa0, 0x5e, 0x15, 0x48, 
  0x92, 0x64, 0x44, 0x84, 0x3d, 0x35, 0xff, 0x0a, 
  0x91, 0x4e, 0x62, 0xf3, 0x1d, 0x5d, 0x92, 0xf5, 
  0x79, 0xf4, 0x38, 0xa3, 0x14, 0xfc, 0xd7, 0x13, 
  0x28, 0xd6, 0xf7, 0x66, 0xab, 0x7b, 0x1d, 0xeb, 
  0x75, 0x0f, 0x15, 0x34, 0xcd, 0xd1, 0xb6, 0x8c, 
  0x58, 0x10, 0x0f, 0xcd, 0xc5, 0xdc, 0x89, 0x98, 
  0x5a, 0x7b, 0x0b, 0x6b, 0x10, 0x82, 0x5a, 0xab, 
  0x45, 0xe5, 0x45, 0x80, 0x95, 0x46, 0x8e, 0x5c, 
  0x44, 0x6a, 0xbc, 0x24, 0x4c, 0x15, 0x3b, 0x00, 
  0x2e, 0x19, 0xbc, 0x27, 0x0e, 0xf0, 0x83, 0xc0, 
  0x1a, 0x36, 0xa9, 0xae, 0x9e, 0xd5, 0x95, 0xe3, 
  0xab, 0x3f, 0x1e, 0x08, 0x6b, 0xbf, 0x83, 0xc3, 
  0xf1, 0xac, 0x16, 0xb4, 0xb3, 0x34, 0x40, 0x10, 
  0xd2, 0x1a, 0xdc, 0x5d, 0xa7, 0x8d, 0xa8, 0x32, 
  0xf0, 0x1a, 0xe0, 0x27, 0x4e, 0x00, 0x28, 0x5f, 
  0xc2, 0x85, 0xb3, 0x7d, 0x76, 0xea, 0x5a, 0xdd, 
  0xc5, 0x12, 0xad, 0x5c, 0x4e, 0x88, 0x69, 0x6b, 
  0x75, 0xa9, 0x66, 0x02, 0xa8, 0xc2, 0x52, 0x79, 
  0x8e, 0x04, 0x94, 0xd2, 0xa0, 0x7e, 0xdc, 0xca, 
  0xec, 0xe0, 0xdd, 0x7a, 0xe9, 0xab, 0x9d, 0xf0, 
  0xfc, 0x76, 0xf2, 0x64, 0xb6, 0xe3, 0x47, 0xec, 
  0x4d, 0xfc, 0x61, 0xe3, 0xa4, 0x86, 0x3d, 0x65, 
  0x77, 0x63, 0x65, 0x78, 0xd9, 0x8b, 0x0d, 0xe6, 
  0x11, 0x0e, 0xfd, 0x1c, 0x88, 0xf6, 0x85, 0x86, 
  0x84, 0xd2, 0x72, 0x36, 0x11, 0x31, 0x41, 0x62, 
  0x20, 0x53, 0x56, 0x8f, 0xba, 0xbb, 0x3f, 0xdc, 
  0x03, 0x3d, 0x8b, 0xb8, 0x8a, 0x7f, 0x98, 0x04, 
  0x97, 0xb1, 0x71, 0x8c, 0x7e, 0xb8, 0xbe, 0xb2, 
  0xdf, 0xd2, 0x3d, 0x14, 0xb4, 0xd3, 0x7c, 0x27, 
  0x67, 0x5b, 0xf5, 0xb4, 0xb7, 0x82, 0x0e, 0x2b, 
  0x1d, 0x8c, 0x52, 0x8e, 0x8b, 0x84, 0x43, 0x96, 
  0x68, 0x8f, 0x1a, 0x60, 0x68, 0x02, 0x92, 0x24, 
  0x3e, 0xc1, 0x7c, 0x44, 0x42, 0x87, 0xc2, 0x50, 
  0xa6, 0x85, 0xbe, 0x02, 0xe2, 0x9c, 0x8c, 0x02, 
  0x1d, 0x79, 0xc9, 0x22, 0x0d, 0x69, 0x97, 0x49, 
  0xc9, 0x26, 0x85, 0x3a, 0xa8, 0xe2, 0x40, 0x35, 
  0x9c, 0xa8, 0x9d, 0xe4, 0x45, 0x33, 0x3c, 0x69, 
  0xba, 0x37, 0x3d, 0x86, 0xfb, 0xdd, 0xea, 0xbf, 
  0x34, 0x01, 0x35, 0x5c, 0xec, 0x5a, 0xf9, 0xf6, 
  0xfe, 0x37, 0x76, 0x81, 0xc6, 0xfa, 0xd1, 0xe5, 
  0xbf, 0xe7, 0xb2, 0xee, 0xfc, 0x60, 0xb8, 0x27, 
  0x4b, 0xe3, 0x81, 0x26, 0xe4, 0xa9, 0x9f, 0x40, 
  0x62, 0x42, 0x45, 0x7a, 0x67, 0x69, 0x90, 0x27, 
  0xc7, 0xa6, 0xc4, 0x24, 0x19, 0xbb, 0x4e, 0x1c, 
  0x6e, 0x72, 0xc6, 0x9d, 0x10, 0x40, 0x72, 0x66, 
  0x2b, 0x7f, 0x8a, 0x7e, 0x6c, 0x13, 0xe9, 0x67, 
  0x95, 0x49, 0xdf, 0xd4, 0x75, 0x82, 0x76, 0x0b, 
  0x8f, 0x87, 0x52, 0xae, 0x7b, 0x93, 0x9c, 0x3f, 
  0x1c, 0xcb, 0x6b, 0x7f, 0xdd, 0x62, 0x16, 0xa4, 
  0x60, 0x76, 0x4a, 0x4f, 0x9d, 0x8b, 0x5d, 0x85, 
  0x0a, 0xa5, 0x18, 0x12, 0x45, 0xd0, 0xe8, 0xa4, 
  0xba, 0x41, 0x4d, 0x44, 0x8e, 0x81, 0x4a, 0x26, 
  0x32, 0x77, 0x85, 0xa4, 0x33, 0xc1, 0x29, 0xe6, 
  0x05, 0x6f, 0xad, 0x2c, 0xf9, 0x23, 0xc0, 0x74, 
  0x2c, 0xa8, 0xca, 0x79, 0xca, 0x2f, 0x1c, 0x47, 
  0xc1, 0x2a, 0x3c, 0xfc, 0x59, 0xac, 0xf3, 0xf4, 
  0x60, 0x55, 0xc4, 0x8b, 0x6a, 0x67, 0xfc, 0x79, 
  0x9d, 0xe4, 0x57, 0x00, 0x79, 0x3d, 0xe4, 0x56, 
  0x04, 0x87, 0x88, 0xe4, 0xaa, 0x9b, 0x11, 0xfc, 
  0xab, 0xaf, 0xd0, 0x8f, 0x6c, 0xe2, 0x32, 0x65, 
  0xc6, 0x4f, 0x30, 0x97, 0xf1, 0x42, 0xf5, 0x96, 
  0x77, 0x94, 0x39, 0x3b, 0x01, 0x11, 0x92, 0xf1, 
  0xc5, 0x3a, 0xf3, 0xbd, 0x94, 0x75, 0x7b, 0xfa, 
  0xa5, 0xa5, 0xa3, 0xd3, 0x31, 0x57, 0x96, 0x7d, 
  0xae, 0x95, 0x95, 0x07, 0x69, 0x3e, 0x9c, 0xba, 
  0x50, 0xea, 0xc1, 0xa8, 0x65, 0x9c, 0x39, 0xf0, 
  0x65, 0x42, 0xa7, 0x17, 0x4f, 0x6f, 0x4d, 0x3c, 
  0xcd, 0x8b, 0xa7, 0x37, 0xcd, 0x8c, 0xa7, 0x9f, 
  0xd4, 0x15, 0xa2, 0x10, 0x8e, 0x64, 0x60, 0x02, 
  0x6a, 0x03, 0x03, 0x2a, 0x99, 0x98, 0x80, 0x6a, 
  0x02, 0x6a, 0x13, 0x03, 0xaa, 0x7d, 0xca, 0x80, 
  0x9a, 0x05, 0x5b, 0x36, 0x64, 0x5a, 0x4e, 0xad, 
  0x3a, 0x56, 0x95, 0x9d, 0x58, 0x06, 0x46, 0xa9, 
  0xf8, 0x94, 0xd9, 0xc6, 0xd8, 0xdd, 0xfa, 0xe9, 
  0xd6, 0x72, 0x1b, 0x43, 0x2b, 0x77, 0xda, 0xf8, 
  0x5a, 0x93, 0x42, 0xe5, 0xa5, 0x50, 0x0e, 0x9e, 
  0x13, 0xb1, 0x0d, 0x4d, 0x8b, 0xcb, 0x4f, 0xa8, 
  0x06, 0x8b, 0xd6, 0x52, 0xa5, 0xaa, 0x9d, 0xe0, 
  0x70, 0xb4, 0xd4, 0xe7, 0xe1, 0xda, 0x24, 0x5e, 
  0x97, 0x95, 0x78, 0x1d, 0x2c, 0xec, 0xcd, 0x9a, 
  0x0e, 0x99, 0xaf, 0xf2, 0xe9, 0x66, 0x56, 0x0a, 
  0x4f, 0x01, 0x70, 0x40, 0x44, 0xa0, 0x90, 0xa1, 
  0xa5, 0x96, 0x48, 0xaa, 0xbf, 0x44, 0x44, 0x14, 
  0x2f, 0xae, 0x4c, 0x7a, 0x67, 0xd2, 0xbb, 0x66, 
  0xef, 0x97, 0x64, 0xc7, 0xb2, 0xf9, 0xa5, 0x05, 
  0xff, 0x75, 0xfc, 0x9a, 0x17, 0x8c, 0x5f, 0xa7, 
  0x5b, 0x66, 0x95, 0x35, 0xf8, 0x45, 0xcb, 0x88, 
  0x2a, 0xf9, 0xf0, 0x31, 0xaa, 0x08, 0xfb, 0x6d, 
  0xab, 0x88, 0xdd, 0x94, 0xfb, 0xe1, 0xa2, 0xbe, 
  0x0c, 0xbd, 0x2b, 0x2b, 0x19, 0xb0, 0x09, 0x1b, 
  0x41, 0x08, 0xac, 0x30, 0x65, 0xa6, 0xa4, 0x33, 
  0xfb, 0x18, 0x80, 0x37, 0xfe, 0x30, 0x95, 0x72, 
  0xc3, 0x0b, 0xf1, 0x96, 0x37, 0xdc, 0xd5, 0x0d, 
  0x47, 0x4c, 0x18, 0x93, 0x41, 0x85, 0xaa, 0x26, 
  0x3d, 0x75, 0xf8, 0x2e, 0x00, 0xc5, 0xdd, 0x82, 
  0x8f, 0x28, 0x09, 0x2b, 0x99, 0xec, 0x54, 0x80, 
  0x83, 0x57, 0x9c, 0x15, 0x07, 0x47, 0x11, 0x60, 
  0xf5, 0x18, 0x0f, 0x34, 0x1c, 0xc8, 0x31, 0xfd, 
  0x70, 0xd5, 0x2e, 0x38, 0x78, 0x40, 0x9e, 0x41, 
  0x38, 0x3e, 0x0c, 0xf1, 0x94, 0x4a, 0x0d, 0x75, 
  0xe6, 0x98, 0x92, 0x51, 0xd1, 0xd4, 0x79, 0x5f, 
  0xd8, 0xe7, 0x78, 0xc9, 0x07, 0xf3, 0x97, 0xfc, 
  0x6e, 0xc6, 0x8b, 0xea, 0xd3, 0xe0, 0xa8, 0x50, 
  0xb3, 0xec, 0x23, 0xd3, 0x60, 0x23, 0x46, 0x42, 
  0x29, 0x8e, 0x6a, 0xb0, 0x8f, 0x01, 0x9b, 0xc5, 
  0x49, 0x7e, 0xdc, 0xb9, 0xb1, 0x57, 0x63, 0xaf, 
  0x26, 0x8b, 0x6b, 0xc0, 0x66, 0x70, 0xe7, 0xd8, 
  0x69, 0x9c, 0x3e, 0x31, 0xb1, 0xd0, 0x24, 0x96, 
  0x27, 0x25, 0x6a, 0x51, 0x48, 0x3b, 0x97, 0x47, 
  0x21, 0xfd, 0x1a, 0xbb, 0xff, 0x53, 0x52, 0x48, 
  0x0b, 0x9a, 0x5b, 0x8d, 0x99, 0xa7, 0x1d, 0xc3, 
  0x3c, 0x2d, 0x5d, 0x6c, 0xdd, 0x35, 0xac, 0xd8, 
  0xd2, 0xdc, 0xf8, 0xb9, 0xbb, 0xcc, 0xad, 0x1e, 
  0x6d, 0x2e, 0xa5, 0x49, 0xf6, 0xcf, 0x96, 0xec, 
  0xa7, 0xd3, 0x3a, 0x56, 0xbf, 0xb2, 0xcd, 0x63, 
  0x49, 0xd6, 0x60, 0x15, 0x1a, 0xd6, 0x81, 0x61, 
  0x1d, 0xd4, 0x88, 0x75, 0x70, 0xdb, 0x40, 0xd6, 
  0x81, 0xd8, 0xfe, 0xa8, 0xdd, 0x10, 0x0f, 0x8a, 
  0x7d, 0x59, 0x13, 0x3b, 0x4f, 0x43, 0x3b, 0x30, 
  0xb4, 0x83, 0xa6, 0xd0, 0x0e, 0xe2, 0x15, 0x6d, 
  0x48, 0x07, 0x86, 0x74, 0x60, 0x48, 0x07, 0xbf, 
  0x0e, 0xe9, 0x20, 0xb6, 0x7a, 0x43, 0x39, 0x30, 
  0x9b, 0xd5, 0x8d, 0xa4, 0x1c, 0x60, 0xdf, 0x5f, 
  0x65, 0x87, 0xdd, 0x86, 0x90, 0x15, 0xec, 0x6b, 
  0xc3, 0x56, 0x38, 0x39, 0x5b, 0xe1, 0xf5, 0xf1, 
  0x63, 0x86, 0xab, 0x60, 0xbe, 0xfb, 0x34, 0xdb, 
  0x97, 0xb5, 0xe6, 0x2a, 0x1c, 0xcf, 0x5c, 0x0d, 
  0x53, 0xc1, 0x58, 0xab, 0x49, 0xfe, 0x0c, 0x53, 
  0xe1, 0xbc, 0x4c, 0x85, 0x4e, 0x6d, 0x98, 0x0a, 
  0xdd, 0xcb, 0x63, 0x2a, 0xa4, 0x1f, 0xc7, 0x7a, 
  0xf6, 0xc9, 0xaa, 0x35, 0x59, 0xc1, 0x36, 0x64, 
  0x85, 0xd2, 0xc5, 0x56, 0xf7, 0xa2, 0x6a, 0xad, 
  0xee, 0xa9, 0xc9, 0x0a, 0xf7, 0xcd, 0x21, 0x2b, 
  0x7c, 0xe3, 0xcc, 0x03, 0x21, 0x18, 0x47, 0x33, 
  0x3c, 0x86, 0x69, 0x24, 0x90, 0x92, 0x43, 0x02, 
  0x3c, 0x16, 0xfa, 0x86, 0xbe, 0x50, 0xe7, 0x4d, 
  0x4b, 0xc9, 0x24, 0xa6, 0xce, 0x7a, 0xd6, 0x9a, 
  0xb3, 0x20, 0xaf, 0x4d, 0x1a, 0x6b, 0xd2, 0xd8, 
  0xba, 0xf3, 0x20, 0xf2, 0xcf, 0x42, 0xee, 0x5e, 
  0xc0, 0x11, 0xc0, 0x25, 0xce, 0x45, 0xae, 0xe2, 
  0xb1, 0x52, 0xce, 0x47, 0x7e, 0x5b, 0x8f, 0x55, 
  0xb8, 0x8b, 0xaa, 0x07, 0x06, 0xa7, 0x63, 0x91, 
  0x7b, 0x68, 0x70, 0x27, 0xed, 0xd0, 0x60, 0xed, 
  0x2f, 0x0f, 0xcd, 0x6f, 0x29, 0xdf, 0xba, 0xb4, 
  0xed, 0xd6, 0xa6, 0xb4, 0xfd, 0xe3, 0xf2, 0x4a, 
  0xdb, 0x9f, 0xb1, 0xcb, 0x38, 0x4f, 0x5d, 0xdb, 
  0x7d, 0xe3, 0xba, 0x56, 0xff, 0x5d, 0x09, 0x65, 
  0x5e, 0x12, 0xa0, 0xf3, 0xaa, 0x04, 0xbb, 0xea, 
  0xab, 0x12, 0x76, 0x55, 0x7c, 0xf5, 0xe1, 0xcb, 
  0x07, 0xbd, 0xf6, 0xab, 0xf7, 0xeb, 0xfc, 0x0f, 
  0xb5, 0x37, 0x3d, 0xc7, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x28, 0x75, 0x75, 0x61, 0x79, 0x29
} };

static GStaticResource static_resource = { gpm_resource_data.data, sizeof (gpm_resource_data.data), NULL, NULL, NULL };
extern GResource *gpm_get_resource (void);
GResource *gpm_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a sane way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER) && (_MSC_VER >= 1500)
/* Visual studio 2008 and later has _Pragma */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined (_MSC_VER)

#define G_HAS_CONSTRUCTORS 1

/* Pre Visual studio 2008 must use #pragma section */
#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (*p)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(resource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(resource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(resource_destructor)
#endif
G_DEFINE_DESTRUCTOR(resource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void resource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void resource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
