;; Machine Descriptions for R8C/M16C/M32C
;; Copyright (C) 2005-2016 Free Software Foundation, Inc.
;; Contributed by Red Hat.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_constants
  [(R0_REGNO 0)
   (R2_REGNO 1)
   (R1_REGNO 2)
   (R3_REGNO 3)

   (A0_REGNO 4)
   (A1_REGNO 5)
   (SB_REGNO 6)
   (FB_REGNO 7)

   (SP_REGNO 8)
   (PC_REGNO 9)
   (FLG_REGNO 10)
   (MEM0_REGNO 12)
   (MEM7_REGNO 19)
   ])

(define_constants
  [(UNS_PROLOGUE_END 1)
   (UNS_EPILOGUE_START 2)
   (UNS_EH_EPILOGUE 3)
   (UNS_PUSHM 4)
   (UNS_POPM 5)
   (UNS_SMOVF 6)
   (UNS_SSTR 7)
   (UNS_SCMPU 8)
   (UNS_SMOVU 9)
   (UNS_FSETB 10)
   (UNS_FREIT 11)
   ])

;; n = no change, x = clobbered.  The first 16 values are chosen such
;; that the enum has one bit set for each flag.
(define_attr "flags" "x,c,z,zc,s,sc,sz,szc,o,oc,oz,ozc,os,osc,osz,oszc,n" (const_string "n"))
(define_asm_attributes [(set_attr "flags" "x")])

(define_mode_iterator QHI [QI HI])
(define_mode_iterator HPSI [(HI "TARGET_A16") (PSI "TARGET_A24")])
(define_mode_iterator QHPSI [QI HI (PSI "TARGET_A24")])
(define_mode_iterator QHSI [QI HI (SI "TARGET_A24")])
(define_mode_attr bwl [(QI "b") (HI "w") (PSI "l") (SI "l")])

(define_code_iterator eqne_cond [eq ne])


(define_insn "nop"
  [(const_int 0)]
  ""
  "nop"
  [(set_attr "flags" "n")]
)

(define_insn "no_insn"
  [(const_int 1)]
  ""
  ""
  [(set_attr "flags" "n")]
)
