// Boost.Geometry
// Unit Test

// Copyright (c) 2016 Oracle and/or its affiliates.

// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_GEOMETRY_TEST_DIRECT_CASES_HPP
#define BOOST_GEOMETRY_TEST_DIRECT_CASES_HPP

struct coordinates
{
    double lon;
    double lat;
};

struct expected_result
{
    double lon2;
    double lat2;
    double reverse_azimuth;
    double reduced_length;
    double geodesic_scale;
};

struct expected_results
{
    coordinates p1;
    double distance;
    double azimuth12;
    expected_result karney;
    expected_result vincenty;
    expected_result thomas;
};

expected_results expected[] =
{
    {
        { 0, 0 }, 250000, 0,
        { 0.00000000000000000000, 2.26091191238511868278, 0.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
        { 0.00000000000000000000, 2.26091191236402178077, 0.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
        { 0.00000000000000000000, 2.26091189386641744363, 0.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 }
    },{
        { 0, 0 }, 250000, 45,
        { 1.58842150169031337548, 1.59850419267109766785, 45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
        { 1.58842150168977558344, 1.59850419267017707092, 45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
        { 1.58842149958854261804, 1.59850419056543535667, 45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 }
    },{
        { 0, 0 }, 250000, 90,
        { 2.24578821029880382198, 0.00000000000000000000, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
        { 2.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
        { 2.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 }
    },{
        { 0, 0 }, 250000, 135,
        { 1.58842150169031337548, -1.59850419267109766785, 134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
        { 1.58842150168977580549, -1.59850419267017707092, 134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
        { 1.58842149958854261804, -1.59850419056543602281, 134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 }
    },{
        { 0, 0 }, 250000, 180,
        { 0.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
        { 0.00000000000000027517, -2.26091191236402178077, 180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
        { 0.00000000000000000000, -2.26091189386641744363, 180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 }
    },{
        { 0, 0 }, 250000, -45,
        { -1.58842150169031337548, 1.59850419267109766785, -45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
        { -1.58842150168977558344, 1.59850419267017707092, -45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
        { -1.58842149958854261804, 1.59850419056543535667, -45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 }
    },{
        { 0, 0 }, 250000, -90,
        { -2.24578821029880382198, 0.00000000000000000000, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
        { -2.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
        { -2.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 }
    },{
        { 0, 0 }, 250000, -135,
        { -1.58842150169031337548, -1.59850419267109766785, -134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
        { -1.58842150168977580549, -1.59850419267017707092, -134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
        { -1.58842149958854261804, -1.59850419056543602281, -134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 }
    },{
        { 0, 0 }, 250000, -180,
        { 0.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
        { -0.00000000000000027517, -2.26091191236402178077, -180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
        { 0.00000000000000000000, -2.26091189386641744363, -180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 }
    },{
        { -1, 0 }, 250000, 0,
        { -1.00000000000000000000, 2.26091191238511868278, 0.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
        { -1.00000000000000000000, 2.26091191236402178077, 0.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
        { -1.00000000000000000000, 2.26091189386641744363, 0.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 }
    },{
        { -1, 0 }, 250000, 45,
        { 0.58842150169031337548, 1.59850419267109766785, 45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
        { 0.58842150168977558344, 1.59850419267017707092, 45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
        { 0.58842149958854272906, 1.59850419056543535667, 45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 }
    },{
        { -1, 0 }, 250000, 90,
        { 1.24578821029880382198, 0.00000000000000000000, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
        { 1.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
        { 1.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 }
    },{
        { -1, 0 }, 250000, 135,
        { 0.58842150169031337548, -1.59850419267109766785, 134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
        { 0.58842150168977569447, -1.59850419267017707092, 134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
        { 0.58842149958854272906, -1.59850419056543602281, 134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 }
    },{
        { -1, 0 }, 250000, 180,
        { -1.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
        { -0.99999999999999977796, -2.26091191236402178077, 180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
        { -1.00000000000000000000, -2.26091189386641744363, 180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 }
    },{
        { -1, 0 }, 250000, -45,
        { -2.58842150169031359752, 1.59850419267109766785, -45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
        { -2.58842150168977536140, 1.59850419267017707092, -45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
        { -2.58842149958854284009, 1.59850419056543535667, -45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 }
    },{
        { -1, 0 }, 250000, -90,
        { -3.24578821029880382198, 0.00000000000000000000, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
        { -3.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 },
        { -3.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 }
    },{
        { -1, 0 }, 250000, -135,
        { -2.58842150169031359752, -1.59850419267109766785, -134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
        { -2.58842150168977580549, -1.59850419267017707092, -134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
        { -2.58842149958854284009, -1.59850419056543602281, -134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 }
    },{
        { -1, 0 }, 250000, -180,
        { -1.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
        { -1.00000000000000022204, -2.26091191236402178077, -180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
        { -1.00000000000000000000, -2.26091189386641744363, -180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 }
    },{
        { 1, 0 }, 250000, 0,
        { 1.00000000000000000000, 2.26091191238511868278, 0.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
        { 1.00000000000000000000, 2.26091191236402178077, 0.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
        { 1.00000000000000000000, 2.26091189386641744363, 0.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 }
    },{
        { 1, 0 }, 250000, 45,
        { 2.58842150169031359752, 1.59850419267109766785, 45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
        { 2.58842150168977536140, 1.59850419267017707092, 45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
        { 2.58842149958854284009, 1.59850419056543535667, 45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 }
    },{
        { 1, 0 }, 250000, 90,
        { 3.24578821029880382198, 0.00000000000000000000, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
        { 3.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 },
        { 3.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 }
    },{
        { 1, 0 }, 250000, 135,
        { 2.58842150169031359752, -1.59850419267109766785, 134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
        { 2.58842150168977580549, -1.59850419267017707092, 134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
        { 2.58842149958854284009, -1.59850419056543602281, 134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 }
    },{
        { 1, 0 }, 250000, 180,
        { 1.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
        { 1.00000000000000022204, -2.26091191236402178077, 180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
        { 1.00000000000000000000, -2.26091189386641744363, 180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 }
    },{
        { 1, 0 }, 250000, -45,
        { -0.58842150169031337548, 1.59850419267109766785, -45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
        { -0.58842150168977558344, 1.59850419267017707092, -45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
        { -0.58842149958854272906, 1.59850419056543535667, -45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 }
    },{
        { 1, 0 }, 250000, -90,
        { -1.24578821029880382198, 0.00000000000000000000, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
        { -1.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
        { -1.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 }
    },{
        { 1, 0 }, 250000, -135,
        { -0.58842150169031337548, -1.59850419267109766785, -134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
        { -0.58842150168977569447, -1.59850419267017707092, -134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
        { -0.58842149958854272906, -1.59850419056543602281, -134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 }
    },{
        { 1, 0 }, 250000, -180,
        { 1.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
        { 0.99999999999999977796, -2.26091191236402178077, -180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
        { 1.00000000000000000000, -2.26091189386641744363, -180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 }
    },{
        { 0, -1 }, 250000, 0,
        { 0.00000000000000000000, 1.26092062918498104551, 0.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
        { 0.00000000000000000000, 1.26092062916373448545, 0.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
        { 0.00000000000000000000, 1.26092061053506587776, 0.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 }
    },{
        { 0, -1 }, 250000, 45,
        { 1.58789352027561725400, 0.59889382252477618707, 44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
        { 1.58789352027508279264, 0.59889382252384637528, 44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
        { 1.58789351816042789700, 0.59889382039736038799, 44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 }
    },{
        { 0, -1 }, 250000, 90,
        { 2.24612766651409989649, -0.99922666842209439952, 89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
        { 2.24612766651347328661, -0.99922666842209439952, 89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
        { 2.24612766651409945240, -0.99922666842208529570, 89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 }
    },{
        { 0, -1 }, 250000, 135,
        { 1.58943065821228057821, -2.59810442478829362045, 134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
        { 1.58943065821171258811, -2.59810442478739078709, 134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
        { 1.58943065613921019619, -2.59810442273856878614, 134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 }
    },{
        { 0, -1 }, 250000, 180,
        { 0.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
        { 0.00000000000000027540, -3.26088938009322193423, 180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
        { 0.00000000000000000000, -3.26088936183515265554, 180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 }
    },{
        { 0, -1 }, 250000, -45,
        { -1.58789352027561725400, 0.59889382252477618707, -44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
        { -1.58789352027508279264, 0.59889382252384637528, -44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
        { -1.58789351816042789700, 0.59889382039736038799, -44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 }
    },{
        { 0, -1 }, 250000, -90,
        { -2.24612766651409989649, -0.99922666842209439952, -89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
        { -2.24612766651347328661, -0.99922666842209439952, -89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
        { -2.24612766651409945240, -0.99922666842208529570, -89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 }
    },{
        { 0, -1 }, 250000, -135,
        { -1.58943065821228057821, -2.59810442478829362045, -134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
        { -1.58943065821171258811, -2.59810442478739078709, -134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
        { -1.58943065613921019619, -2.59810442273856878614, -134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 }
    },{
        { 0, -1 }, 250000, -180,
        { 0.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
        { -0.00000000000000027540, -3.26088938009322193423, -180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
        { 0.00000000000000000000, -3.26088936183515265554, -180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 }
    },{
        { 0, 1 }, 250000, 0,
        { 0.00000000000000000000, 3.26088938011404927408, 0.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
        { 0.00000000000000000000, 3.26088938009322193423, 0.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
        { 0.00000000000000000000, 3.26088936183515265554, 0.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 }
    },{
        { 0, 1 }, 250000, 45,
        { 1.58943065821228057821, 2.59810442478829362045, 45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
        { 1.58943065821171236607, 2.59810442478739123118, 45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
        { 1.58943065613921019619, 2.59810442273856923023, 45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 }
    },{
        { 0, 1 }, 250000, 90,
        { 2.24612766651409989649, 0.99922666842209439952, 90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
        { 2.24612766651347328661, 0.99922666842209484361, 90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
        { 2.24612766651409945240, 0.99922666842208562876, 90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 }
    },{
        { 0, 1 }, 250000, 135,
        { 1.58789352027561725400, -0.59889382252477618707, 135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
        { 1.58789352027508301468, -0.59889382252384604222, 135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
        { 1.58789351816042789700, -0.59889382039736038799, 135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 }
    },{
        { 0, 1 }, 250000, 180,
        { 0.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
        { 0.00000000000000027502, -1.26092062916373448545, 180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
        { 0.00000000000000000000, -1.26092061053506587776, 180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 }
    },{
        { 0, 1 }, 250000, -45,
        { -1.58943065821228057821, 2.59810442478829362045, -45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
        { -1.58943065821171236607, 2.59810442478739123118, -45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
        { -1.58943065613921019619, 2.59810442273856923023, -45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 }
    },{
        { 0, 1 }, 250000, -90,
        { -2.24612766651409989649, 0.99922666842209439952, -90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
        { -2.24612766651347328661, 0.99922666842209484361, -90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
        { -2.24612766651409945240, 0.99922666842208562876, -90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 }
    },{
        { 0, 1 }, 250000, -135,
        { -1.58789352027561725400, -0.59889382252477618707, -135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
        { -1.58789352027508301468, -0.59889382252384604222, -135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
        { -1.58789351816042789700, -0.59889382039736038799, -135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 }
    },{
        { 0, 1 }, 250000, -180,
        { 0.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
        { -0.00000000000000027502, -1.26092062916373448545, -180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
        { 0.00000000000000000000, -1.26092061053506587776, -180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 }
    },{
        { -1, -1 }, 250000, 0,
        { -1.00000000000000000000, 1.26092062918498104551, 0.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
        { -1.00000000000000000000, 1.26092062916373448545, 0.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
        { -1.00000000000000000000, 1.26092061053506587776, 0.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 }
    },{
        { -1, -1 }, 250000, 45,
        { 0.58789352027561725400, 0.59889382252477618707, 44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
        { 0.58789352027508279264, 0.59889382252384637528, 44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
        { 0.58789351816042800802, 0.59889382039736038799, 44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 }
    },{
        { -1, -1 }, 250000, 90,
        { 1.24612766651409989649, -0.99922666842209439952, 89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
        { 1.24612766651347328661, -0.99922666842209439952, 89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
        { 1.24612766651409945240, -0.99922666842208529570, 89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 }
    },{
        { -1, -1 }, 250000, 135,
        { 0.58943065821228057821, -2.59810442478829362045, 134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
        { 0.58943065821171258811, -2.59810442478739078709, 134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
        { 0.58943065613921030721, -2.59810442273856878614, 134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 }
    },{
        { -1, -1 }, 250000, 180,
        { -1.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
        { -0.99999999999999977796, -3.26088938009322193423, 180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
        { -1.00000000000000000000, -3.26088936183515265554, 180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 }
    },{
        { -1, -1 }, 250000, -45,
        { -2.58789352027561747605, 0.59889382252477618707, -44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
        { -2.58789352027508279264, 0.59889382252384637528, -44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
        { -2.58789351816042811905, 0.59889382039736038799, -44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 }
    },{
        { -1, -1 }, 250000, -90,
        { -3.24612766651409989649, -0.99922666842209439952, -89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
        { -3.24612766651347328661, -0.99922666842209439952, -89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
        { -3.24612766651409989649, -0.99922666842208529570, -89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 }
    },{
        { -1, -1 }, 250000, -135,
        { -2.58943065821228035617, -2.59810442478829362045, -134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
        { -2.58943065821171281016, -2.59810442478739078709, -134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
        { -2.58943065613921019619, -2.59810442273856878614, -134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 }
    },{
        { -1, -1 }, 250000, -180,
        { -1.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
        { -1.00000000000000022204, -3.26088938009322193423, -180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
        { -1.00000000000000000000, -3.26088936183515265554, -180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 }
    },{
        { -1, 1 }, 250000, 0,
        { -1.00000000000000000000, 3.26088938011404927408, 0.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
        { -1.00000000000000000000, 3.26088938009322193423, 0.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
        { -1.00000000000000000000, 3.26088936183515265554, 0.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 }
    },{
        { -1, 1 }, 250000, 45,
        { 0.58943065821228057821, 2.59810442478829362045, 45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
        { 0.58943065821171236607, 2.59810442478739123118, 45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
        { 0.58943065613921030721, 2.59810442273856923023, 45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 }
    },{
        { -1, 1 }, 250000, 90,
        { 1.24612766651409989649, 0.99922666842209439952, 90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
        { 1.24612766651347328661, 0.99922666842209484361, 90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
        { 1.24612766651409945240, 0.99922666842208562876, 90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 }
    },{
        { -1, 1 }, 250000, 135,
        { 0.58789352027561725400, -0.59889382252477618707, 135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
        { 0.58789352027508301468, -0.59889382252384604222, 135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
        { 0.58789351816042800802, -0.59889382039736038799, 135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 }
    },{
        { -1, 1 }, 250000, 180,
        { -1.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
        { -0.99999999999999977796, -1.26092062916373448545, 180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
        { -1.00000000000000000000, -1.26092061053506587776, 180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 }
    },{
        { -1, 1 }, 250000, -45,
        { -2.58943065821228035617, 2.59810442478829362045, -45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
        { -2.58943065821171236607, 2.59810442478739123118, -45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
        { -2.58943065613921019619, 2.59810442273856923023, -45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 }
    },{
        { -1, 1 }, 250000, -90,
        { -3.24612766651409989649, 0.99922666842209439952, -90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
        { -3.24612766651347328661, 0.99922666842209484361, -90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
        { -3.24612766651409989649, 0.99922666842208562876, -90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 }
    },{
        { -1, 1 }, 250000, -135,
        { -2.58789352027561747605, -0.59889382252477618707, -135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
        { -2.58789352027508279264, -0.59889382252384604222, -135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
        { -2.58789351816042811905, -0.59889382039736038799, -135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 }
    },{
        { -1, 1 }, 250000, -180,
        { -1.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
        { -1.00000000000000022204, -1.26092062916373448545, -180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
        { -1.00000000000000000000, -1.26092061053506587776, -180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 }
    },{
        { 1, 1 }, 250000, 0,
        { 1.00000000000000000000, 3.26088938011404927408, 0.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
        { 1.00000000000000000000, 3.26088938009322193423, 0.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
        { 1.00000000000000000000, 3.26088936183515265554, 0.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 }
    },{
        { 1, 1 }, 250000, 45,
        { 2.58943065821228035617, 2.59810442478829362045, 45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
        { 2.58943065821171236607, 2.59810442478739123118, 45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
        { 2.58943065613921019619, 2.59810442273856923023, 45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 }
    },{
        { 1, 1 }, 250000, 90,
        { 3.24612766651409989649, 0.99922666842209439952, 90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
        { 3.24612766651347328661, 0.99922666842209484361, 90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
        { 3.24612766651409989649, 0.99922666842208562876, 90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 }
    },{
        { 1, 1 }, 250000, 135,
        { 2.58789352027561747605, -0.59889382252477618707, 135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
        { 2.58789352027508279264, -0.59889382252384604222, 135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
        { 2.58789351816042811905, -0.59889382039736038799, 135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 }
    },{
        { 1, 1 }, 250000, 180,
        { 1.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
        { 1.00000000000000022204, -1.26092062916373448545, 180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
        { 1.00000000000000000000, -1.26092061053506587776, 180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 }
    },{
        { 1, 1 }, 250000, -45,
        { -0.58943065821228057821, 2.59810442478829362045, -45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
        { -0.58943065821171236607, 2.59810442478739123118, -45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
        { -0.58943065613921030721, 2.59810442273856923023, -45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 }
    },{
        { 1, 1 }, 250000, -90,
        { -1.24612766651409989649, 0.99922666842209439952, -90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
        { -1.24612766651347328661, 0.99922666842209484361, -90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
        { -1.24612766651409945240, 0.99922666842208562876, -90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 }
    },{
        { 1, 1 }, 250000, -135,
        { -0.58789352027561725400, -0.59889382252477618707, -135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
        { -0.58789352027508301468, -0.59889382252384604222, -135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
        { -0.58789351816042800802, -0.59889382039736038799, -135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 }
    },{
        { 1, 1 }, 250000, -180,
        { 1.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
        { 0.99999999999999977796, -1.26092062916373448545, -180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
        { 1.00000000000000000000, -1.26092061053506587776, -180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 }
    },{
        { 1, -1 }, 250000, 0,
        { 1.00000000000000000000, 1.26092062918498104551, 0.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
        { 1.00000000000000000000, 1.26092062916373448545, 0.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
        { 1.00000000000000000000, 1.26092061053506587776, 0.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 }
    },{
        { 1, -1 }, 250000, 45,
        { 2.58789352027561747605, 0.59889382252477618707, 44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
        { 2.58789352027508279264, 0.59889382252384637528, 44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
        { 2.58789351816042811905, 0.59889382039736038799, 44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 }
    },{
        { 1, -1 }, 250000, 90,
        { 3.24612766651409989649, -0.99922666842209439952, 89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
        { 3.24612766651347328661, -0.99922666842209439952, 89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
        { 3.24612766651409989649, -0.99922666842208529570, 89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 }
    },{
        { 1, -1 }, 250000, 135,
        { 2.58943065821228035617, -2.59810442478829362045, 134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
        { 2.58943065821171281016, -2.59810442478739078709, 134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
        { 2.58943065613921019619, -2.59810442273856878614, 134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 }
    },{
        { 1, -1 }, 250000, 180,
        { 1.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
        { 1.00000000000000022204, -3.26088938009322193423, 180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
        { 1.00000000000000000000, -3.26088936183515265554, 180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 }
    },{
        { 1, -1 }, 250000, -45,
        { -0.58789352027561725400, 0.59889382252477618707, -44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
        { -0.58789352027508279264, 0.59889382252384637528, -44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
        { -0.58789351816042800802, 0.59889382039736038799, -44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 }
    },{
        { 1, -1 }, 250000, -90,
        { -1.24612766651409989649, -0.99922666842209439952, -89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
        { -1.24612766651347328661, -0.99922666842209439952, -89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
        { -1.24612766651409945240, -0.99922666842208529570, -89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 }
    },{
        { 1, -1 }, 250000, -135,
        { -0.58943065821228057821, -2.59810442478829362045, -134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
        { -0.58943065821171258811, -2.59810442478739078709, -134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
        { -0.58943065613921030721, -2.59810442273856878614, -134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 }
    },{
        { 1, -1 }, 250000, -180,
        { 1.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
        { 0.99999999999999977796, -3.26088938009322193423, -180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
        { 1.00000000000000000000, -3.26088936183515265554, -180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 }
    }
};

size_t const expected_size = sizeof(expected) / sizeof(expected_results);

#endif // BOOST_GEOMETRY_TEST_DIRECT_CASES_HPP
